/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.mnist;

import java.io.IOException;
import org.deeplearning4j.datasets.mnist.MnistDbFile;

public class MnistImageFile
extends MnistDbFile {
    private int rows = this.readInt();
    private int cols = this.readInt();

    public MnistImageFile(String name, String mode) throws IOException {
        super(name, mode);
    }

    public int[][] readImage() throws IOException {
        int[][] dat = new int[this.getRows()][this.getCols()];
        for (int i = 0; i < this.getCols(); ++i) {
            for (int j = 0; j < this.getRows(); ++j) {
                dat[i][j] = this.readUnsignedByte();
            }
        }
        return dat;
    }

    public byte[][] readImagesUnsafe(int nImages) throws IOException {
        byte[][] out = new byte[nImages][0];
        for (int i = 0; i < nImages; ++i) {
            out[i] = new byte[this.rows * this.cols];
            this.read(out[i]);
        }
        return out;
    }

    public void nextImage() throws IOException {
        super.next();
    }

    public void prevImage() throws IOException {
        super.prev();
    }

    @Override
    protected int getMagicNumber() {
        return 2051;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    @Override
    public int getEntryLength() {
        return this.cols * this.rows;
    }

    @Override
    public int getHeaderSize() {
        return super.getHeaderSize() + 8;
    }
}

