/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers;

import java.util.ArrayList;
import java.util.Map;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasInput
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasInput.class);
    private final int NO_TRUNCATED_BPTT = 0;

    public KerasInput(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasInput(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        if (this.inputShape.length > 4) {
            throw new UnsupportedKerasConfigurationException("Inputs with " + this.inputShape.length + " dimensions not supported");
        }
    }

    public KerasInput(String layerName, int[] inputShape) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        this(layerName, inputShape, true);
    }

    public KerasInput(String layerName, int[] inputShape, boolean enforceTrainingConfig) throws UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        this.className = this.conf.getLAYER_CLASS_NAME_INPUT();
        this.layerName = layerName;
        this.inputShape = inputShape;
        this.inboundLayerNames = new ArrayList();
        this.layer = null;
        this.vertex = null;
        if (this.inputShape.length > 4) {
            throw new UnsupportedKerasConfigurationException("Inputs with " + this.inputShape.length + " dimensions not supported");
        }
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        InputType.InputTypeFeedForward myInputType;
        if (inputType.length > 0) {
            log.warn("Keras Input layer does not accept inputs (received " + inputType.length + "). Ignoring.");
        }
        block0 : switch (this.inputShape.length) {
            case 1: {
                myInputType = new InputType.InputTypeFeedForward((long)this.inputShape[0], null);
                break;
            }
            case 2: {
                if (this.dimOrder != null) {
                    switch (this.dimOrder) {
                        case TENSORFLOW: {
                            myInputType = new InputType.InputTypeRecurrent((long)this.inputShape[1], (long)this.inputShape[0], RNNFormat.NWC);
                            break block0;
                        }
                        case THEANO: {
                            myInputType = new InputType.InputTypeRecurrent((long)this.inputShape[0], (long)this.inputShape[1], RNNFormat.NCW);
                            break block0;
                        }
                        case NONE: {
                            myInputType = new InputType.InputTypeRecurrent((long)this.inputShape[1], (long)this.inputShape[0], RNNFormat.NWC);
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unknown/not supported dimension ordering: " + (Object)((Object)this.dimOrder));
                }
                myInputType = new InputType.InputTypeRecurrent((long)this.inputShape[1], (long)this.inputShape[0], RNNFormat.NWC);
                break;
            }
            case 3: {
                switch (this.dimOrder) {
                    case TENSORFLOW: {
                        myInputType = new InputType.InputTypeConvolutional((long)this.inputShape[0], (long)this.inputShape[1], (long)this.inputShape[2], CNN2DFormat.NHWC);
                        break block0;
                    }
                    case THEANO: {
                        myInputType = new InputType.InputTypeConvolutional((long)this.inputShape[1], (long)this.inputShape[2], (long)this.inputShape[0], CNN2DFormat.NCHW);
                        break block0;
                    }
                }
                this.dimOrder = KerasLayer.DimOrder.THEANO;
                myInputType = new InputType.InputTypeConvolutional((long)this.inputShape[1], (long)this.inputShape[2], (long)this.inputShape[0], CNN2DFormat.NCHW);
                log.warn("Couldn't determine dim ordering / data format from model file. Older Keras versions may come without specified backend, in which case we assume the model was built with theano.");
                break;
            }
            case 4: {
                switch (this.dimOrder) {
                    case TENSORFLOW: {
                        myInputType = new InputType.InputTypeConvolutional3D(Convolution3D.DataFormat.NDHWC, (long)this.inputShape[0], (long)this.inputShape[1], (long)this.inputShape[2], (long)this.inputShape[3]);
                        break block0;
                    }
                    case THEANO: {
                        myInputType = new InputType.InputTypeConvolutional3D(Convolution3D.DataFormat.NCDHW, (long)this.inputShape[3], (long)this.inputShape[0], (long)this.inputShape[1], (long)this.inputShape[2]);
                        break block0;
                    }
                }
                this.dimOrder = KerasLayer.DimOrder.THEANO;
                myInputType = new InputType.InputTypeConvolutional3D(Convolution3D.DataFormat.NCDHW, (long)this.inputShape[3], (long)this.inputShape[0], (long)this.inputShape[1], (long)this.inputShape[2]);
                log.warn("Couldn't determine dim ordering / data format from model file. Older Keras versions may come without specified backend, in which case we assume the model was built with theano.");
                break;
            }
            default: {
                throw new UnsupportedKerasConfigurationException("Inputs with " + this.inputShape.length + " dimensions not supported");
            }
        }
        return myInputType;
    }

    public int getTruncatedBptt() {
        if (this.inputShape.length == 2 && this.inputShape[0] > 0) {
            return this.inputShape[0];
        }
        return 0;
    }

    public int getNO_TRUNCATED_BPTT() {
        return this.NO_TRUNCATED_BPTT;
    }

    public String toString() {
        return "KerasInput(NO_TRUNCATED_BPTT=" + this.getNO_TRUNCATED_BPTT() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasInput)) {
            return false;
        }
        KerasInput other = (KerasInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getNO_TRUNCATED_BPTT() == other.getNO_TRUNCATED_BPTT();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNO_TRUNCATED_BPTT();
        return result;
    }
}

