/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import akka.actor.ActorSystem;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.bagofwords.vectorizer.TextVectorizer;
import org.deeplearning4j.bagofwords.vectorizer.TfidfVectorizer;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectorsImpl;
import org.deeplearning4j.models.word2vec.Huffman;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache;
import org.deeplearning4j.parallel.Parallelization;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.invertedindex.InvertedIndex;
import org.deeplearning4j.text.invertedindex.LuceneInvertedIndex;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.stopwords.StopWords;
import org.deeplearning4j.text.tokenization.tokenizerfactory.DefaultTokenizerFactory;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.deeplearning4j.text.tokenization.tokenizerfactory.UimaTokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Word2Vec
extends WordVectorsImpl {
    protected static final long serialVersionUID = -2367495638286018038L;
    protected transient TokenizerFactory tokenizerFactory = new DefaultTokenizerFactory();
    protected transient SentenceIterator sentenceIter;
    protected transient DocumentIterator docIter;
    protected int batchSize = 1000;
    protected double sample = 0.0;
    protected long totalWords = 1L;
    protected AtomicDouble alpha = new AtomicDouble(0.025);
    protected int window = 5;
    protected transient RandomGenerator g;
    protected static Logger log = LoggerFactory.getLogger(Word2Vec.class);
    protected boolean shouldReset = true;
    protected int numIterations = 1;
    public static final String UNK = "UNK";
    protected long seed = 123L;
    protected boolean saveVocab = false;
    protected double minLearningRate = 0.01;
    protected transient TextVectorizer vectorizer;
    protected int learningRateDecayWords = 10000;
    protected InvertedIndex invertedIndex;
    protected boolean useAdaGrad = false;
    protected int workers = Runtime.getRuntime().availableProcessors();

    public TextVectorizer getVectorizer() {
        return this.vectorizer;
    }

    public void setVectorizer(TextVectorizer vectorizer) {
        this.vectorizer = vectorizer;
    }

    public void fit() throws IOException {
        int[] docs;
        boolean loaded = this.buildVocab();
        if (!loaded && this.saveVocab) {
            this.vocab().saveVocab();
        }
        if (this.stopWords == null) {
            this.readStopWords();
        }
        log.info("Training word2vec multithreaded");
        if (this.sentenceIter != null) {
            this.sentenceIter.reset();
        }
        if (this.docIter != null) {
            this.docIter.reset();
        }
        if ((docs = this.vectorizer.index().allDocs()).length < 1) {
            this.vectorizer.fit();
        }
        if ((docs = this.vectorizer.index().allDocs()).length < 1) {
            throw new IllegalStateException("No documents found");
        }
        this.totalWords = this.vectorizer.numWordsEncountered();
        if (this.totalWords < 1L) {
            throw new IllegalStateException("Unable to train, total words less than 1");
        }
        this.totalWords *= (long)this.numIterations;
        log.info("Processing sentences...");
        AtomicLong numWordsSoFar = new AtomicLong(0L);
        final AtomicLong nextRandom = new AtomicLong(5L);
        ThreadPoolExecutor exec = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                executor.submit(r);
            }
        });
        final ConcurrentLinkedDeque<List<VocabWord>> batch2 = new ConcurrentLinkedDeque<List<VocabWord>>();
        this.vectorizer.index().eachDoc(new Function<List<VocabWord>, Void>(){

            public Void apply(List<VocabWord> input) {
                ArrayList<VocabWord> batch = new ArrayList<VocabWord>();
                Word2Vec.this.addWords(input, nextRandom, batch);
                if (batch.isEmpty()) {
                    return null;
                }
                batch2.add(batch);
                return null;
            }
        }, exec);
        exec.shutdown();
        try {
            exec.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.numIterations; ++i) {
            this.doIteration(batch2, numWordsSoFar, nextRandom);
        }
    }

    private void doIteration(Collection<List<VocabWord>> batch2, final AtomicLong numWordsSoFar, final AtomicLong nextRandom) {
        ActorSystem actorSystem = ActorSystem.create();
        final AtomicLong lastReported = new AtomicLong(System.currentTimeMillis());
        Parallelization.iterateInParallel(batch2, (Parallelization.RunnableWithParams)new Parallelization.RunnableWithParams<List<VocabWord>>(){

            public void run(List<VocabWord> sentence, Object[] args) {
                double alpha = Math.max(Word2Vec.this.minLearningRate, Word2Vec.this.alpha.get() * (1.0 - 1.0 * (double)numWordsSoFar.get() / (double)Word2Vec.this.totalWords));
                long now = System.currentTimeMillis();
                long diff = Math.abs(now - lastReported.get());
                if (numWordsSoFar.get() > 0L && diff > 10000L) {
                    lastReported.set(now);
                    log.info("Words so far " + numWordsSoFar.get() + " with alpha at " + alpha);
                }
                Word2Vec.this.trainSentence(sentence, nextRandom, alpha);
                numWordsSoFar.set(numWordsSoFar.get() + (long)sentence.size());
            }
        }, (ActorSystem)actorSystem);
    }

    protected void addWords(List<VocabWord> sentence, AtomicLong nextRandom, List<VocabWord> currMiniBatch) {
        for (VocabWord word : sentence) {
            if (word == null) continue;
            if (this.sample > 0.0) {
                double numDocs = this.vectorizer.index().numDocuments();
                double ran = (Math.sqrt(word.getWordFrequency() / (this.sample * numDocs)) + 1.0) * (this.sample * numDocs) / word.getWordFrequency();
                if (ran < (double)(nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                currMiniBatch.add(word);
                continue;
            }
            currMiniBatch.add(word);
        }
    }

    public void setup() {
        log.info("Building binary tree");
        this.buildBinaryTree();
        log.info("Resetting weights");
        if (this.shouldReset) {
            this.resetWeights();
        }
    }

    public boolean buildVocab() {
        this.readStopWords();
        if (this.vocab().vocabExists()) {
            log.info("Loading vocab...");
            this.vocab().loadVocab();
            this.lookupTable.resetWeights();
            return true;
        }
        if (this.invertedIndex == null) {
            this.invertedIndex = new LuceneInvertedIndex.Builder().cache(this.vocab()).stopWords(this.stopWords).build();
        }
        if (this.vectorizer == null) {
            this.vectorizer = new TfidfVectorizer.Builder().index(this.invertedIndex).cache(this.vocab()).iterate(this.docIter).iterate(this.sentenceIter).batchSize(this.batchSize).minWords(this.minWordFrequency).stopWords(this.stopWords).tokenize(this.tokenizerFactory).build();
            this.vectorizer.fit();
        } else if (this.vocab().numWords() < 2) {
            this.vectorizer.fit();
        }
        this.setup();
        return false;
    }

    public void trainSentence(List<VocabWord> sentence, AtomicLong nextRandom, double alpha) {
        if (sentence == null || sentence.isEmpty()) {
            return;
        }
        for (int i = 0; i < sentence.size(); ++i) {
            nextRandom.set(nextRandom.get() * 25214903917L + 11L);
            this.skipGram(i, sentence, (int)nextRandom.get() % this.window, nextRandom, alpha);
        }
    }

    public void skipGram(int i, List<VocabWord> sentence, int b, AtomicLong nextRandom, double alpha) {
        VocabWord word = sentence.get(i);
        if (word == null || sentence.isEmpty()) {
            return;
        }
        int end = this.window * 2 + 1 - b;
        for (int a = b; a < end; ++a) {
            int c;
            if (a == this.window || (c = i - this.window + a) < 0 || c >= sentence.size()) continue;
            VocabWord lastWord = sentence.get(c);
            this.iterate(word, lastWord, nextRandom, alpha);
        }
    }

    public void iterate(VocabWord w1, VocabWord w2, AtomicLong nextRandom, double alpha) {
        this.lookupTable.iterateSample(w1, w2, nextRandom, alpha);
    }

    protected void buildBinaryTree() {
        log.info("Constructing priority queue");
        Huffman huffman = new Huffman(this.vocab().vocabWords());
        huffman.build();
        log.info("Built tree");
    }

    protected void resetWeights() {
        this.lookupTable.resetWeights();
    }

    protected void readStopWords() {
        if (this.stopWords != null) {
            return;
        }
        this.stopWords = StopWords.getStopWords();
    }

    public void setSentenceIter(SentenceIterator sentenceIter) {
        this.sentenceIter = sentenceIter;
        this.shouldReset = false;
    }

    public void resetWeightsOnSetup() {
        this.shouldReset = true;
    }

    public int getWindow() {
        return this.window;
    }

    public List<String> getStopWords() {
        return this.stopWords;
    }

    public synchronized SentenceIterator getSentenceIter() {
        return this.sentenceIter;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public void setTokenizerFactory(TokenizerFactory tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    public static class Builder {
        protected int minWordFrequency = 1;
        protected int layerSize = 50;
        protected SentenceIterator iter;
        protected List<String> stopWords = StopWords.getStopWords();
        protected int window = 5;
        protected TokenizerFactory tokenizerFactory;
        protected VocabCache vocabCache;
        protected DocumentIterator docIter;
        protected double lr = 0.25;
        protected int iterations = 1;
        protected long seed = 123L;
        protected boolean saveVocab = false;
        protected int batchSize = 1000;
        protected int learningRateDecayWords = 10000;
        protected boolean useAdaGrad = false;
        protected TextVectorizer textVectorizer;
        protected double minLearningRate = 0.01;
        protected double negative = 0.0;
        protected double sampling = 1.0E-5;
        protected int workers = Runtime.getRuntime().availableProcessors();
        protected InvertedIndex index;
        protected WeightLookupTable lookupTable;

        public Builder lookupTable(WeightLookupTable lookupTable) {
            this.lookupTable = lookupTable;
            return this;
        }

        public Builder index(InvertedIndex index) {
            this.index = index;
            return this;
        }

        public Builder workers(int workers) {
            this.workers = workers;
            return this;
        }

        public Builder sampling(double sample) {
            this.sampling = sample;
            return this;
        }

        public Builder negativeSample(double negative) {
            this.negative = negative;
            return this;
        }

        public Builder minLearningRate(double minLearningRate) {
            this.minLearningRate = minLearningRate;
            return this;
        }

        public Builder useAdaGrad(boolean useAdaGrad) {
            this.useAdaGrad = useAdaGrad;
            return this;
        }

        public Builder vectorizer(TextVectorizer textVectorizer) {
            this.textVectorizer = textVectorizer;
            return this;
        }

        public Builder learningRateDecayWords(int learningRateDecayWords) {
            this.learningRateDecayWords = learningRateDecayWords;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder saveVocab(boolean saveVocab) {
            this.saveVocab = saveVocab;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder learningRate(double lr) {
            this.lr = lr;
            return this;
        }

        public Builder iterate(DocumentIterator iter) {
            this.docIter = iter;
            return this;
        }

        public Builder vocabCache(VocabCache cache) {
            this.vocabCache = cache;
            return this;
        }

        public Builder minWordFrequency(int minWordFrequency) {
            this.minWordFrequency = minWordFrequency;
            return this;
        }

        public Builder tokenizerFactory(TokenizerFactory tokenizerFactory) {
            this.tokenizerFactory = tokenizerFactory;
            return this;
        }

        public Builder layerSize(int layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public Builder stopWords(List<String> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public Builder windowSize(int window) {
            this.window = window;
            return this;
        }

        public Builder iterate(SentenceIterator iter) {
            this.iter = iter;
            return this;
        }

        public Word2Vec build() {
            if (this.iter == null) {
                Word2Vec ret = new Word2Vec();
                ret.window = this.window;
                ret.alpha.set(this.lr);
                ret.vectorizer = this.textVectorizer;
                ret.stopWords = this.stopWords;
                ret.setVocab(this.vocabCache);
                ret.numIterations = this.iterations;
                ret.minWordFrequency = this.minWordFrequency;
                ret.seed = this.seed;
                ret.saveVocab = this.saveVocab;
                ret.batchSize = this.batchSize;
                ret.useAdaGrad = this.useAdaGrad;
                ret.minLearningRate = this.minLearningRate;
                ret.sample = this.sampling;
                ret.workers = this.workers;
                ret.invertedIndex = this.index;
                ret.lookupTable = this.lookupTable;
                try {
                    if (this.tokenizerFactory == null) {
                        this.tokenizerFactory = new UimaTokenizerFactory();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (this.vocabCache == null) {
                    this.vocabCache = new InMemoryLookupCache();
                    ret.setVocab(this.vocabCache);
                }
                if (this.lookupTable == null) {
                    this.lookupTable = new InMemoryLookupTable.Builder().negative(this.negative).useAdaGrad(this.useAdaGrad).lr(this.lr).cache(this.vocabCache).vectorLength(this.layerSize).build();
                }
                ret.docIter = this.docIter;
                ret.lookupTable = this.lookupTable;
                ret.tokenizerFactory = this.tokenizerFactory;
                return ret;
            }
            Word2Vec ret = new Word2Vec();
            ret.alpha.set(this.lr);
            ret.sentenceIter = this.iter;
            ret.window = this.window;
            ret.useAdaGrad = this.useAdaGrad;
            ret.minLearningRate = this.minLearningRate;
            ret.vectorizer = this.textVectorizer;
            ret.stopWords = this.stopWords;
            ret.minWordFrequency = this.minWordFrequency;
            ret.setVocab(this.vocabCache);
            ret.docIter = this.docIter;
            ret.minWordFrequency = this.minWordFrequency;
            ret.numIterations = this.iterations;
            ret.seed = this.seed;
            ret.numIterations = this.iterations;
            ret.saveVocab = this.saveVocab;
            ret.batchSize = this.batchSize;
            ret.sample = this.sampling;
            ret.workers = this.workers;
            ret.invertedIndex = this.index;
            ret.lookupTable = this.lookupTable;
            try {
                if (this.tokenizerFactory == null) {
                    this.tokenizerFactory = new UimaTokenizerFactory();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.vocabCache == null) {
                this.vocabCache = new InMemoryLookupCache();
                ret.setVocab(this.vocabCache);
            }
            if (this.lookupTable == null) {
                this.lookupTable = new InMemoryLookupTable.Builder().negative(this.negative).useAdaGrad(this.useAdaGrad).lr(this.lr).cache(this.vocabCache).vectorLength(this.layerSize).build();
            }
            ret.lookupTable = this.lookupTable;
            ret.tokenizerFactory = this.tokenizerFactory;
            return ret;
        }
    }
}

