/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.uima;

import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UimaResource {
    private AnalysisEngine analysisEngine;
    private CasPool casPool;
    private static Logger log = LoggerFactory.getLogger(UimaResource.class);

    public UimaResource(AnalysisEngine analysisEngine) throws ResourceInitializationException {
        this.analysisEngine = analysisEngine;
        this.casPool = new CasPool(Runtime.getRuntime().availableProcessors(), analysisEngine);
    }

    public UimaResource(AnalysisEngine analysisEngine, CasPool casPool) {
        this.analysisEngine = analysisEngine;
        this.casPool = casPool;
    }

    public AnalysisEngine getAnalysisEngine() {
        return this.analysisEngine;
    }

    public void setAnalysisEngine(AnalysisEngine analysisEngine) {
        this.analysisEngine = analysisEngine;
    }

    public CasPool getCasPool() {
        return this.casPool;
    }

    public void setCasPool(CasPool casPool) {
        this.casPool = casPool;
    }

    public CAS process(String text) {
        CAS cas = this.retrieve();
        if (cas == null) {
            return null;
        }
        cas.setDocumentText(text);
        try {
            this.analysisEngine.process(cas);
        }
        catch (AnalysisEngineProcessException e) {
            log.warn("Unable to process text " + text, (Throwable)e);
        }
        return cas;
    }

    public CAS retrieve() {
        CAS ret = this.casPool.getCas();
        try {
            return ret == null ? this.analysisEngine.newCAS() : ret;
        }
        catch (ResourceInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public void release(CAS cas) {
        this.casPool.releaseCas(cas);
    }
}

