/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.commons.lang.math.RandomUtils;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.plot.Tsne;
import org.nd4j.linalg.api.ndarray.INDArray;

public class JointStorage<T extends SequenceElement>
implements WeightLookupTable<T>,
VocabCache<T> {
    private Map<Long, WeightLookupTable<T>> mapTables = new ConcurrentHashMap<Long, WeightLookupTable<T>>();
    private Map<Long, VocabCache<T>> mapVocabs = new ConcurrentHashMap<Long, VocabCache<T>>();
    private int layerSize;
    protected Long tableId;

    @Override
    public void loadVocab() {
    }

    @Override
    public boolean vocabExists() {
        return false;
    }

    @Override
    public void saveVocab() {
    }

    @Override
    public Collection<String> words() {
        return null;
    }

    @Override
    public void incrementWordCount(String word) {
    }

    @Override
    public void incrementWordCount(String word, int increment) {
    }

    @Override
    public int wordFrequency(String word) {
        return 0;
    }

    @Override
    public boolean containsWord(String word) {
        return false;
    }

    @Override
    public String wordAtIndex(int index) {
        return null;
    }

    @Override
    public T elementAtIndex(int index) {
        return null;
    }

    @Override
    public int indexOf(String word) {
        return 0;
    }

    @Override
    public Collection<T> vocabWords() {
        ArrayList<T> words = new ArrayList<T>();
        for (VocabCache<T> cache : this.mapVocabs.values()) {
            words.addAll(cache.vocabWords());
        }
        return Collections.unmodifiableCollection(words);
    }

    @Override
    public long totalWordOccurrences() {
        return 0L;
    }

    @Override
    public T wordFor(String word) {
        return null;
    }

    @Override
    public void addWordToIndex(int index, String word) {
    }

    @Override
    public void putVocabWord(String word) {
    }

    @Override
    public int numWords() {
        AtomicLong counter = new AtomicLong(0L);
        for (VocabCache<T> cache : this.mapVocabs.values()) {
            counter.addAndGet(cache.numWords());
        }
        return counter.intValue();
    }

    @Override
    public int docAppearedIn(String word) {
        return 0;
    }

    @Override
    public void incrementDocCount(String word, int howMuch) {
    }

    @Override
    public void setCountForDoc(String word, int count) {
    }

    @Override
    public int totalNumberOfDocs() {
        return 0;
    }

    @Override
    public void incrementTotalDocCount() {
    }

    @Override
    public void incrementTotalDocCount(int by) {
    }

    @Override
    public Collection<T> tokens() {
        return null;
    }

    @Override
    public void addToken(SequenceElement word) {
    }

    @Override
    public T tokenFor(String word) {
        return null;
    }

    @Override
    public boolean hasToken(String token) {
        return false;
    }

    @Override
    public void importVocabulary(VocabCache<T> vocabCache) {
    }

    @Override
    public void updateWordsOccurencies() {
    }

    @Override
    public void removeElement(String label) {
    }

    @Override
    public void removeElement(T element) {
    }

    @Override
    public int layerSize() {
        return this.layerSize;
    }

    @Override
    public void resetWeights(boolean reset) {
    }

    @Override
    public void plotVocab(Tsne tsne) {
    }

    @Override
    public void plotVocab() {
    }

    @Override
    public void putCode(int codeIndex, INDArray code) {
    }

    @Override
    public INDArray loadCodes(int[] codes) {
        return null;
    }

    @Override
    public void iterate(T w1, T w2) {
    }

    @Override
    public void iterateSample(T w1, T w2, AtomicLong nextRandom, double alpha) {
    }

    @Override
    public void putVector(String word, INDArray vector) {
    }

    @Override
    public INDArray vector(String word) {
        return null;
    }

    @Override
    public void resetWeights() {
    }

    @Override
    public void setLearningRate(double lr) {
    }

    @Override
    public Iterator<INDArray> vectors() {
        return null;
    }

    @Override
    public INDArray getWeights() {
        return null;
    }

    @Override
    public int getVectorLength() {
        return 0;
    }

    @Override
    public Long getTableId() {
        return this.tableId;
    }

    @Override
    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public static class Builder<T extends SequenceElement> {
        private Map<Long, WeightLookupTable<T>> mapTables = new ConcurrentHashMap<Long, WeightLookupTable<T>>();
        private Map<Long, VocabCache<T>> mapVocabs = new ConcurrentHashMap<Long, VocabCache<T>>();
        private int layerSize;

        public Builder addLookupPair(@NonNull InMemoryLookupTable<T> lookupTable) {
            if (lookupTable == null) {
                throw new NullPointerException("lookupTable");
            }
            return this.addLookupPair(lookupTable, lookupTable.getVocab());
        }

        public Builder addLookupPair(@NonNull WeightLookupTable<T> lookupTable, @NonNull VocabCache<T> cache) {
            if (lookupTable == null) {
                throw new NullPointerException("lookupTable");
            }
            if (cache == null) {
                throw new NullPointerException("cache");
            }
            if (lookupTable.getTableId() == null || lookupTable.getTableId() == 0L) {
                lookupTable.setTableId(RandomUtils.nextLong());
            }
            for (SequenceElement word : cache.vocabWords()) {
                word.setStorageId(lookupTable.getTableId());
            }
            this.mapTables.put(lookupTable.getTableId(), lookupTable);
            this.mapVocabs.put(lookupTable.getTableId(), cache);
            return this;
        }

        public Builder layerSize(int layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public JointStorage build() {
            JointStorage lookupTable = new JointStorage();
            lookupTable.mapTables = this.mapTables;
            lookupTable.mapVocabs = this.mapVocabs;
            lookupTable.layerSize = this.layerSize;
            return lookupTable;
        }
    }
}

