/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

public class LabelsSource
implements Serializable {
    private AtomicLong counter = new AtomicLong(0L);
    private String template;
    private boolean useFormatter = false;
    private List<String> labels;
    private long maxCount = 0L;

    public LabelsSource() {
    }

    public LabelsSource(@NonNull String template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        this.template = template;
        if (this.template.contains("%d")) {
            this.useFormatter = true;
        }
    }

    public LabelsSource(@NonNull List<String> labels) {
        if (labels == null) {
            throw new NullPointerException("labels");
        }
        this.labels = new ArrayList<String>(labels);
    }

    public synchronized String nextLabel() {
        if (this.labels != null) {
            return this.labels.get(Long.valueOf(this.counter.getAndIncrement()).intValue());
        }
        this.maxCount = this.counter.getAndIncrement();
        return this.formatLabel(this.maxCount);
    }

    private String formatLabel(long value) {
        if (this.useFormatter) {
            return String.format(this.template, value);
        }
        return this.template + value;
    }

    public List<String> getLabels() {
        if (this.labels != null && !this.labels.isEmpty()) {
            return this.labels;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (long x = 0L; x < this.counter.get(); ++x) {
            result.add(this.formatLabel(x));
        }
        return result;
    }

    public synchronized void storeLabel(String label) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        if (!this.labels.contains(label)) {
            this.labels.add(label);
        }
    }

    public void reset() {
        this.counter.set(0L);
    }

    public int getNumberOfLabelsUsed() {
        if (this.labels != null && !this.labels.isEmpty()) {
            return this.labels.size();
        }
        return Long.valueOf(this.maxCount + 1L).intValue();
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

