/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.SequenceLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.SkipGram;
import org.deeplearning4j.models.embeddings.learning.impl.sequence.DBOW;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectorsImpl;
import org.deeplearning4j.models.sequencevectors.enums.ListenerEvent;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.interfaces.VectorsListener;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.VocabConstructor;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceVectors<T extends SequenceElement>
extends WordVectorsImpl<T>
implements WordVectors {
    protected transient SequenceIterator<T> iterator;
    protected transient ElementsLearningAlgorithm<T> elementsLearningAlgorithm;
    protected transient SequenceLearningAlgorithm<T> sequenceLearningAlgorithm;
    protected VectorsConfiguration configuration;
    protected static final Logger log = LoggerFactory.getLogger(SequenceVectors.class);
    protected transient WordVectors existingModel;
    protected transient T unknownElement;
    protected transient AtomicDouble scoreElements = new AtomicDouble(0.0);
    protected transient AtomicDouble scoreSequences = new AtomicDouble(0.0);
    protected transient Set<VectorsListener<T>> eventListeners;

    public double getElementsScore() {
        return this.scoreElements.get();
    }

    public double getSequencesScore() {
        return this.scoreSequences.get();
    }

    public void buildVocab() {
        VocabConstructor constructor = new VocabConstructor.Builder<T>().addSource(this.iterator, this.minWordFrequency).setTargetVocabCache(this.vocab).fetchLabels(this.trainSequenceVectors).setStopWords(this.stopWords).build();
        if (this.existingModel != null && this.lookupTable instanceof InMemoryLookupTable && this.existingModel.lookupTable() instanceof InMemoryLookupTable) {
            log.info("Merging existing vocabulary into the current one...");
            constructor.buildMergedVocabulary(this.existingModel, true);
            ((InMemoryLookupTable)this.lookupTable).consume((InMemoryLookupTable)this.existingModel.lookupTable());
        } else {
            log.info("Starting vocabulary building...");
            constructor.buildJointVocabulary(false, true);
            if (this.useUnknown && this.unknownElement != null && !this.vocab.containsWord(((SequenceElement)this.unknownElement).getLabel())) {
                log.info("Adding UNK element...");
                ((SequenceElement)this.unknownElement).setSpecial(true);
                ((SequenceElement)this.unknownElement).markAsLabel(false);
                ((SequenceElement)this.unknownElement).setIndex(this.vocab.numWords());
                this.vocab.addToken(this.unknownElement);
            }
            if ((long)this.vocab.numWords() / constructor.getNumberOfSequences() > 1000L) {
                log.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                log.warn("!                                                                                       !");
                log.warn("! Your input looks malformed: number of sentences is too low, model accuracy may suffer !");
                log.warn("!                                                                                       !");
                log.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
        }
    }

    public void fit() {
        if (!this.trainElementsVectors && !this.trainSequenceVectors) {
            throw new IllegalStateException("You should define at least one training goal 'trainElementsRepresentation' or 'trainSequenceRepresentation'");
        }
        if (this.iterator == null) {
            throw new IllegalStateException("You can't fit() data without SequenceIterator defined");
        }
        if (this.resetModel || this.lookupTable != null && this.vocab != null && this.vocab.numWords() == 0) {
            this.buildVocab();
        }
        if (this.vocab == null || this.lookupTable == null || this.vocab.numWords() == 0) {
            throw new IllegalStateException("You can't fit() model with empty Vocabulary or WeightLookupTable");
        }
        if (!this.resetModel || this.existingModel != null) {
            this.lookupTable.resetWeights(false);
        } else {
            this.lookupTable.resetWeights(true);
        }
        log.info("Building learning algorithms:");
        if (this.trainElementsVectors && this.elementsLearningAlgorithm != null) {
            log.info("          building ElementsLearningAlgorithm: [" + this.elementsLearningAlgorithm.getCodeName() + "]");
            this.elementsLearningAlgorithm.configure(this.vocab, this.lookupTable, this.configuration);
            this.elementsLearningAlgorithm.pretrain(this.iterator);
        }
        if (this.trainSequenceVectors && this.sequenceLearningAlgorithm != null) {
            log.info("          building SequenceLearningAlgorithm: [" + this.sequenceLearningAlgorithm.getCodeName() + "]");
            this.sequenceLearningAlgorithm.configure(this.vocab, this.lookupTable, this.configuration);
            this.sequenceLearningAlgorithm.pretrain(this.iterator);
        }
        log.info("Starting learning process...");
        if (this.stopWords == null) {
            this.stopWords = new ArrayList();
        }
        for (int currentEpoch = 1; currentEpoch <= this.numEpochs; ++currentEpoch) {
            int x;
            AtomicLong linesCounter = new AtomicLong(0L);
            AtomicLong wordsCounter = new AtomicLong(0L);
            AsyncSequencer sequencer = new AsyncSequencer(this.iterator, this.stopWords);
            sequencer.start();
            ArrayList<VectorCalculationsThread> threads = new ArrayList<VectorCalculationsThread>();
            for (x = 0; x < this.workers; ++x) {
                threads.add(x, new VectorCalculationsThread(x, currentEpoch, wordsCounter, this.vocab.totalWordOccurrences(), linesCounter, sequencer));
                ((VectorCalculationsThread)threads.get(x)).start();
            }
            try {
                sequencer.join();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (x = 0; x < this.workers; ++x) {
                try {
                    ((VectorCalculationsThread)threads.get(x)).join();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.trainElementsVectors && this.elementsLearningAlgorithm != null && (!this.trainSequenceVectors || this.sequenceLearningAlgorithm == null) && this.elementsLearningAlgorithm.isEarlyTerminationHit() || this.trainSequenceVectors && this.sequenceLearningAlgorithm != null && (!this.trainElementsVectors || this.elementsLearningAlgorithm == null) && this.sequenceLearningAlgorithm.isEarlyTerminationHit()) break;
            log.info("Epoch: [" + currentEpoch + "]; Words vectorized so far: [" + wordsCounter.get() + "];  Lines vectorized so far: [" + linesCounter.get() + "]; learningRate: [" + this.minLearningRate + "]");
            if (this.eventListeners == null || this.eventListeners.isEmpty()) continue;
            for (VectorsListener<T> listener : this.eventListeners) {
                if (!listener.validateEvent(ListenerEvent.EPOCH, currentEpoch)) continue;
                listener.processEvent(ListenerEvent.EPOCH, this, currentEpoch);
            }
        }
    }

    protected void trainSequence(@NonNull Sequence<T> sequence, AtomicLong nextRandom, double alpha) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (sequence.getElements().isEmpty()) {
            return;
        }
        if (this.trainElementsVectors) {
            nextRandom.set(nextRandom.get() * 25214903917L + 11L);
            if (!this.elementsLearningAlgorithm.isEarlyTerminationHit()) {
                this.scoreElements.set(this.elementsLearningAlgorithm.learnSequence(sequence, nextRandom, alpha));
            }
        }
        if (this.trainSequenceVectors) {
            nextRandom.set(nextRandom.get() * 25214903917L + 11L);
            if (!this.sequenceLearningAlgorithm.isEarlyTerminationHit()) {
                this.scoreSequences.set(this.sequenceLearningAlgorithm.learnSequence(sequence, nextRandom, alpha));
            }
        }
    }

    public SequenceIterator<T> getIterator() {
        return this.iterator;
    }

    public VectorsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setEventListeners(Set<VectorsListener<T>> eventListeners) {
        this.eventListeners = eventListeners;
    }

    static /* synthetic */ int[] access$1902(SequenceVectors x0, int[] x1) {
        x0.variableWindows = x1;
        return x1;
    }

    private class VectorCalculationsThread
    extends Thread
    implements Runnable {
        private final int threadId;
        private final int epochNumber;
        private final AtomicLong wordsCounter;
        private final long totalWordsCount;
        private final AtomicLong totalLines;
        private final AsyncSequencer digitizer;
        private final AtomicLong nextRandom;

        public VectorCalculationsThread(int threadId, int epoch, AtomicLong wordsCounter, long totalWordsCount, AtomicLong linesCounter, AsyncSequencer digitizer) {
            this.threadId = threadId;
            this.epochNumber = epoch;
            this.wordsCounter = wordsCounter;
            this.totalWordsCount = totalWordsCount;
            this.totalLines = linesCounter;
            this.digitizer = digitizer;
            this.nextRandom = new AtomicLong(this.threadId);
            this.setName("VectorCalculationsThread " + this.threadId);
        }

        @Override
        public void run() {
            while (this.digitizer.hasMoreLines()) {
                try {
                    ArrayList sequences = new ArrayList();
                    for (int x = 0; x < SequenceVectors.this.batchSize; ++x) {
                        Sequence sequence;
                        if (!this.digitizer.hasMoreLines() || (sequence = this.digitizer.nextSentence()) == null) continue;
                        sequences.add(sequence);
                    }
                    double alpha = 0.025;
                    if (sequences.isEmpty()) continue;
                    for (int i = 0; i < SequenceVectors.this.numIterations; ++i) {
                        for (int x = 0; x < sequences.size(); ++x) {
                            Sequence sequence = (Sequence)sequences.get(x);
                            alpha = Math.max(SequenceVectors.this.minLearningRate, SequenceVectors.this.learningRate.get() * (1.0 - 1.0 * (double)this.wordsCounter.get() / (double)this.totalWordsCount));
                            SequenceVectors.this.trainSequence(sequence, this.nextRandom, alpha);
                            this.totalLines.incrementAndGet();
                            this.wordsCounter.addAndGet(sequence.getElements().size());
                            if (this.totalLines.get() % 100000L == 0L) {
                                log.info("Epoch: [" + this.epochNumber + "]; Words vectorized so far: [" + this.wordsCounter.get() + "];  Lines vectorized so far: [" + this.totalLines.get() + "]; learningRate: [" + alpha + "]");
                            }
                            if (SequenceVectors.this.eventListeners == null || SequenceVectors.this.eventListeners.isEmpty()) continue;
                            for (VectorsListener listener : SequenceVectors.this.eventListeners) {
                                if (!listener.validateEvent(ListenerEvent.LINE, this.totalLines.get())) continue;
                                listener.processEvent(ListenerEvent.LINE, SequenceVectors.this, this.totalLines.get());
                            }
                        }
                        if (SequenceVectors.this.eventListeners == null || SequenceVectors.this.eventListeners.size() <= 0) continue;
                        for (VectorsListener listener : SequenceVectors.this.eventListeners) {
                            if (!listener.validateEvent(ListenerEvent.ITERATION, i)) continue;
                            listener.processEvent(ListenerEvent.ITERATION, SequenceVectors.this, i);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected class AsyncSequencer
    extends Thread
    implements Runnable {
        private final SequenceIterator<T> iterator;
        private final LinkedBlockingQueue<Sequence<T>> buffer;
        private final int limitUpper = 10000;
        private final int limitLower = 5000;
        private AtomicBoolean isRunning = new AtomicBoolean(true);
        private AtomicLong nextRandom;
        private List<String> stopList;

        public AsyncSequencer(@NonNull SequenceIterator<T> iterator, List<String> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList");
            }
            this.iterator = iterator;
            this.buffer = new LinkedBlockingQueue();
            this.setName("AsyncSequencer thread");
            this.nextRandom = new AtomicLong(SequenceVectors.this.workers + 1);
            this.iterator.reset();
            this.stopList = stopList;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.isRunning.set(true);
            while (this.iterator.hasMoreSequences()) {
                if (this.buffer.size() < 5000) {
                    SequenceVectors.this.update();
                    AtomicInteger linesLoaded = new AtomicInteger(0);
                    while (linesLoaded.getAndIncrement() < 10000 && this.iterator.hasMoreSequences()) {
                        Object newLabel;
                        Sequence document = this.iterator.nextSequence();
                        Sequence newSequence = new Sequence();
                        if (document.getSequenceLabel() != null && (newLabel = SequenceVectors.this.vocab.wordFor(((SequenceElement)document.getSequenceLabel()).getLabel())) != null) {
                            newSequence.setSequenceLabel(newLabel);
                        }
                        for (SequenceElement element : document.getElements()) {
                            if (this.stopList.contains(element.getLabel())) continue;
                            Object realElement = SequenceVectors.this.vocab.wordFor(element.getLabel());
                            if (realElement != null) {
                                newSequence.addElement(realElement);
                                continue;
                            }
                            if (!SequenceVectors.this.useUnknown || SequenceVectors.this.unknownElement == null) continue;
                            newSequence.addElement(SequenceVectors.this.unknownElement);
                        }
                        if (!newSequence.getElements().isEmpty()) {
                            this.buffer.add(newSequence);
                        }
                        linesLoaded.incrementAndGet();
                    }
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isRunning.set(false);
        }

        public boolean hasMoreLines() {
            return !this.buffer.isEmpty() || this.isRunning.get();
        }

        public Sequence<T> nextSentence() {
            try {
                return this.buffer.poll(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Builder<T extends SequenceElement> {
        protected VocabCache<T> vocabCache;
        protected WeightLookupTable<T> lookupTable;
        protected SequenceIterator<T> iterator;
        protected ModelUtils<T> modelUtils = new BasicModelUtils();
        protected WordVectors existingVectors;
        protected double sampling = 0.0;
        protected double negative = 0.0;
        protected double learningRate = 0.025;
        protected double minLearningRate = 1.0E-4;
        protected int minWordFrequency = 0;
        protected int iterations = 1;
        protected int numEpochs = 1;
        protected int layerSize = 100;
        protected int window = 5;
        protected boolean hugeModelExpected = false;
        protected int batchSize = 100;
        protected int learningRateDecayWords;
        protected long seed;
        protected boolean useAdaGrad = false;
        protected boolean resetModel = true;
        protected int workers = Runtime.getRuntime().availableProcessors();
        protected boolean useUnknown = false;
        protected int[] variableWindows;
        protected boolean trainSequenceVectors = false;
        protected boolean trainElementsVectors = true;
        protected List<String> stopWords = new ArrayList<String>();
        protected VectorsConfiguration configuration = new VectorsConfiguration();
        protected transient T unknownElement;
        protected String UNK = this.configuration.getUNK();
        protected String STOP = this.configuration.getSTOP();
        protected ElementsLearningAlgorithm<T> elementsLearningAlgorithm = new SkipGram();
        protected SequenceLearningAlgorithm<T> sequenceLearningAlgorithm = new DBOW();
        protected Set<VectorsListener<T>> vectorsListeners = new HashSet<VectorsListener<T>>();

        public Builder() {
        }

        public Builder(@NonNull VectorsConfiguration configuration) {
            if (configuration == null) {
                throw new NullPointerException("configuration");
            }
            this.configuration = configuration;
            this.iterations = configuration.getIterations();
            this.numEpochs = configuration.getEpochs();
            this.minLearningRate = configuration.getMinLearningRate();
            this.learningRate = configuration.getLearningRate();
            this.sampling = configuration.getSampling();
            this.negative = configuration.getNegative();
            this.minWordFrequency = configuration.getMinWordFrequency();
            this.seed = configuration.getSeed();
            this.hugeModelExpected = configuration.isHugeModelExpected();
            this.batchSize = configuration.getBatchSize();
            this.layerSize = configuration.getLayersSize();
            this.learningRateDecayWords = configuration.getLearningRateDecayWords();
            this.useAdaGrad = configuration.isUseAdaGrad();
            this.window = configuration.getWindow();
            this.UNK = configuration.getUNK();
            this.STOP = configuration.getSTOP();
            this.variableWindows = configuration.getVariableWindows();
            if (configuration.getElementsLearningAlgorithm() != null && !configuration.getElementsLearningAlgorithm().isEmpty()) {
                this.elementsLearningAlgorithm(configuration.getElementsLearningAlgorithm());
            }
            if (configuration.getSequenceLearningAlgorithm() != null && !configuration.getSequenceLearningAlgorithm().isEmpty()) {
                this.sequenceLearningAlgorithm(configuration.getSequenceLearningAlgorithm());
            }
            if (configuration.getStopList() != null) {
                this.stopWords.addAll(configuration.getStopList());
            }
        }

        protected Builder<T> useExistingWordVectors(@NonNull WordVectors vec) {
            if (vec == null) {
                throw new NullPointerException("vec");
            }
            this.existingVectors = vec;
            return this;
        }

        public Builder<T> iterate(@NonNull SequenceIterator<T> iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = iterator;
            return this;
        }

        public Builder<T> sequenceLearningAlgorithm(@NonNull String algoName) {
            if (algoName == null) {
                throw new NullPointerException("algoName");
            }
            try {
                Class<?> clazz = Class.forName(algoName);
                this.sequenceLearningAlgorithm = (SequenceLearningAlgorithm)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder<T> sequenceLearningAlgorithm(@NonNull SequenceLearningAlgorithm<T> algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm");
            }
            this.sequenceLearningAlgorithm = algorithm;
            return this;
        }

        public Builder<T> elementsLearningAlgorithm(@NonNull String algoName) {
            if (algoName == null) {
                throw new NullPointerException("algoName");
            }
            try {
                Class<?> clazz = Class.forName(algoName);
                this.elementsLearningAlgorithm = (ElementsLearningAlgorithm)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder<T> elementsLearningAlgorithm(@NonNull ElementsLearningAlgorithm<T> algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm");
            }
            this.elementsLearningAlgorithm = algorithm;
            return this;
        }

        public Builder<T> batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder<T> iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder<T> epochs(int numEpochs) {
            this.numEpochs = numEpochs;
            return this;
        }

        public Builder<T> workers(int numWorkers) {
            this.workers = numWorkers;
            return this;
        }

        public Builder<T> useAdaGrad(boolean reallyUse) {
            this.useAdaGrad = reallyUse;
            return this;
        }

        public Builder<T> layerSize(int layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public Builder<T> learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder<T> minWordFrequency(int minWordFrequency) {
            this.minWordFrequency = minWordFrequency;
            return this;
        }

        public Builder<T> minLearningRate(double minLearningRate) {
            this.minLearningRate = minLearningRate;
            return this;
        }

        public Builder<T> resetModel(boolean reallyReset) {
            this.resetModel = reallyReset;
            return this;
        }

        public Builder<T> vocabCache(@NonNull VocabCache<T> vocabCache) {
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache");
            }
            this.vocabCache = vocabCache;
            return this;
        }

        public Builder<T> lookupTable(@NonNull WeightLookupTable<T> lookupTable) {
            if (lookupTable == null) {
                throw new NullPointerException("lookupTable");
            }
            this.lookupTable = lookupTable;
            return this;
        }

        public Builder<T> sampling(double sampling) {
            this.sampling = sampling;
            return this;
        }

        public Builder<T> negativeSample(double negative) {
            this.negative = negative;
            return this;
        }

        public Builder<T> stopWords(@NonNull List<String> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList");
            }
            this.stopWords.addAll(stopList);
            return this;
        }

        public Builder<T> trainElementsRepresentation(boolean trainElements) {
            this.trainElementsVectors = trainElements;
            return this;
        }

        public Builder<T> trainSequencesRepresentation(boolean trainSequences) {
            this.trainSequenceVectors = trainSequences;
            return this;
        }

        public Builder<T> stopWords(@NonNull Collection<T> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList");
            }
            for (SequenceElement word : stopList) {
                this.stopWords.add(word.getLabel());
            }
            return this;
        }

        public Builder<T> windowSize(int windowSize) {
            this.window = windowSize;
            return this;
        }

        public Builder<T> seed(long randomSeed) {
            return this;
        }

        public Builder<T> modelUtils(@NonNull ModelUtils<T> modelUtils) {
            if (modelUtils == null) {
                throw new NullPointerException("modelUtils");
            }
            this.modelUtils = modelUtils;
            return this;
        }

        public Builder<T> useUnknown(boolean reallyUse) {
            this.useUnknown = reallyUse;
            return this;
        }

        public Builder<T> unknownElement(@NonNull T element) {
            if (element == null) {
                throw new NullPointerException("element");
            }
            this.unknownElement = element;
            this.UNK = ((SequenceElement)element).getLabel();
            return this;
        }

        public Builder<T> useVariableWindow(int ... windows) {
            if (windows == null || windows.length == 0) {
                throw new IllegalStateException("Variable windows can't be empty");
            }
            this.variableWindows = windows;
            return this;
        }

        protected void presetTables() {
            if (this.lookupTable == null) {
                if (this.vocabCache == null) {
                    this.vocabCache = new AbstractCache.Builder().hugeModelExpected(this.hugeModelExpected).scavengerRetentionDelay(this.configuration.getScavengerRetentionDelay()).scavengerThreshold(this.configuration.getScavengerActivationThreshold()).minElementFrequency(this.minWordFrequency).build();
                }
                this.lookupTable = new InMemoryLookupTable.Builder().useAdaGrad(this.useAdaGrad).cache(this.vocabCache).negative(this.negative).vectorLength(this.layerSize).lr(this.learningRate).seed(this.seed).build();
            }
            if (this.trainElementsVectors && this.elementsLearningAlgorithm == null) {
                this.elementsLearningAlgorithm = new SkipGram();
            }
            if (this.trainSequenceVectors && this.sequenceLearningAlgorithm == null) {
                this.sequenceLearningAlgorithm = new DBOW();
            }
            this.modelUtils.init(this.lookupTable);
        }

        public Builder<T> setVectorsListeners(@NonNull Collection<VectorsListener<T>> listeners) {
            if (listeners == null) {
                throw new NullPointerException("listeners");
            }
            this.vectorsListeners.addAll(listeners);
            return this;
        }

        public SequenceVectors<T> build() {
            this.presetTables();
            SequenceVectors vectors = new SequenceVectors();
            if (this.existingVectors != null) {
                this.trainElementsVectors = false;
                this.elementsLearningAlgorithm = null;
            }
            vectors.numEpochs = this.numEpochs;
            vectors.numIterations = this.iterations;
            vectors.vocab = this.vocabCache;
            vectors.minWordFrequency = this.minWordFrequency;
            vectors.learningRate.set(this.learningRate);
            vectors.minLearningRate = this.minLearningRate;
            vectors.sampling = this.sampling;
            vectors.negative = this.negative;
            vectors.layerSize = this.layerSize;
            vectors.batchSize = this.batchSize;
            vectors.learningRateDecayWords = this.learningRateDecayWords;
            vectors.window = this.window;
            vectors.resetModel = this.resetModel;
            vectors.useAdeGrad = this.useAdaGrad;
            vectors.stopWords = this.stopWords;
            vectors.workers = this.workers;
            vectors.iterator = this.iterator;
            vectors.lookupTable = this.lookupTable;
            vectors.modelUtils = this.modelUtils;
            vectors.useUnknown = this.useUnknown;
            vectors.unknownElement = this.unknownElement;
            SequenceVectors.access$1902(vectors, this.variableWindows);
            vectors.trainElementsVectors = this.trainElementsVectors;
            vectors.trainSequenceVectors = this.trainSequenceVectors;
            vectors.elementsLearningAlgorithm = this.elementsLearningAlgorithm;
            vectors.sequenceLearningAlgorithm = this.sequenceLearningAlgorithm;
            vectors.existingModel = this.existingVectors;
            vectors.setUNK(this.UNK);
            this.configuration.setLearningRate(this.learningRate);
            this.configuration.setLayersSize(this.layerSize);
            this.configuration.setHugeModelExpected(this.hugeModelExpected);
            this.configuration.setWindow(this.window);
            this.configuration.setMinWordFrequency(this.minWordFrequency);
            this.configuration.setIterations(this.iterations);
            this.configuration.setSeed(this.seed);
            this.configuration.setBatchSize(this.batchSize);
            this.configuration.setLearningRateDecayWords(this.learningRateDecayWords);
            this.configuration.setMinLearningRate(this.minLearningRate);
            this.configuration.setSampling(this.sampling);
            this.configuration.setUseAdaGrad(this.useAdaGrad);
            this.configuration.setNegative(this.negative);
            this.configuration.setEpochs(this.numEpochs);
            this.configuration.setStopList(this.stopWords);
            this.configuration.setUNK(this.UNK);
            this.configuration.setVariableWindows(this.variableWindows);
            vectors.configuration = this.configuration;
            return vectors;
        }
    }
}

