/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.RandomUtils;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.impl.AggregateCBOW;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.DeviceLocalNDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBOW<T extends SequenceElement>
implements ElementsLearningAlgorithm<T> {
    private VocabCache<T> vocabCache;
    private WeightLookupTable<T> lookupTable;
    private VectorsConfiguration configuration;
    private static final Logger logger = LoggerFactory.getLogger(CBOW.class);
    protected static double MAX_EXP = 6.0;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected double sampling;
    protected int[] variableWindows;
    protected DeviceLocalNDArray syn0;
    protected DeviceLocalNDArray syn1;
    protected DeviceLocalNDArray syn1Neg;
    protected DeviceLocalNDArray expTable;
    protected DeviceLocalNDArray table;
    protected ThreadLocal<List<Aggregate>> batches = new ThreadLocal();

    public List<Aggregate> getBatch() {
        return this.batches.get();
    }

    @Override
    public String getCodeName() {
        return "CBOW";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.configuration = configuration;
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.sampling = configuration.getSampling();
        if (configuration.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getSyn1Neg() == null) {
            logger.info("Initializing syn1Neg...");
            ((InMemoryLookupTable)lookupTable).setUseHS(configuration.isUseHierarchicSoftmax());
            ((InMemoryLookupTable)lookupTable).setNegative(configuration.getNegative());
            ((InMemoryLookupTable)lookupTable).resetWeights(false);
        }
        this.syn0 = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn0());
        this.syn1 = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn1());
        this.syn1Neg = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn1Neg());
        this.expTable = new DeviceLocalNDArray(Nd4j.create((double[])((InMemoryLookupTable)lookupTable).getExpTable()));
        this.table = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getTable());
        this.variableWindows = configuration.getVariableWindows();
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    @Override
    public void finish() {
        if (this.batches != null && this.batches.get() != null && this.batches.get().size() > 0) {
            Nd4j.getExecutioner().exec(this.batches.get());
            this.batches.get().clear();
        }
    }

    @Override
    public double learnSequence(Sequence<T> sequence, AtomicLong nextRandom, double learningRate) {
        Sequence<T> tempSequence = sequence;
        if (this.sampling > 0.0) {
            tempSequence = this.applySubsampling(sequence, nextRandom);
        }
        int currentWindow = this.window;
        if (this.variableWindows != null && this.variableWindows.length != 0) {
            currentWindow = this.variableWindows[RandomUtils.nextInt(this.variableWindows.length)];
        }
        for (int i = 0; i < tempSequence.getElements().size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            this.cbow(i, tempSequence.getElements(), (int)nextRandom.get() % currentWindow, nextRandom, learningRate, currentWindow);
        }
        return 0.0;
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    public void iterateSample(T currentWord, int[] windowWords, AtomicLong nextRandom, double alpha, boolean isInference, int numLabels, boolean trainWords, INDArray inferenceVector) {
        int[] idxSyn1 = null;
        int[] codes = null;
        if (this.configuration.isUseHierarchicSoftmax()) {
            idxSyn1 = new int[((SequenceElement)currentWord).getCodeLength()];
            codes = new int[((SequenceElement)currentWord).getCodeLength()];
            for (int p = 0; p < ((SequenceElement)currentWord).getCodeLength(); ++p) {
                if (((SequenceElement)currentWord).getPoints().get(p) < 0) continue;
                codes[p] = ((SequenceElement)currentWord).getCodes().get(p);
                idxSyn1[p] = ((SequenceElement)currentWord).getPoints().get(p);
            }
        } else {
            idxSyn1 = new int[]{};
            codes = new int[]{};
        }
        if (this.negative > 0.0 && this.syn1Neg == null) {
            ((InMemoryLookupTable)this.lookupTable).initNegative();
            this.syn1Neg = new DeviceLocalNDArray(((InMemoryLookupTable)this.lookupTable).getSyn1Neg());
        }
        if (this.batches.get() == null) {
            this.batches.set(new ArrayList());
        }
        AggregateCBOW cbow = new AggregateCBOW((INDArray)this.syn0.get(), (INDArray)this.syn1.get(), (INDArray)this.syn1Neg.get(), (INDArray)this.expTable.get(), (INDArray)this.table.get(), ((SequenceElement)currentWord).getIndex(), windowWords, idxSyn1, codes, (int)this.negative, ((SequenceElement)currentWord).getIndex(), this.lookupTable.layerSize(), alpha, nextRandom.get(), this.vocabCache.numWords(), numLabels, trainWords, inferenceVector);
        nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
        if (!isInference) {
            this.batches.get().add((Aggregate)cbow);
        } else {
            Nd4j.getExecutioner().exec((Aggregate)cbow);
        }
    }

    public void cbow(int i, List<T> sentence, int b, AtomicLong nextRandom, double alpha, int currentWindow) {
        int end = this.window * 2 + 1 - b;
        SequenceElement currentWord = (SequenceElement)sentence.get(i);
        ArrayList<Integer> intsList = new ArrayList<Integer>();
        for (int a = b; a < end; ++a) {
            int c;
            if (a == currentWindow || (c = i - currentWindow + a) < 0 || c >= sentence.size()) continue;
            SequenceElement lastWord = (SequenceElement)sentence.get(c);
            intsList.add(lastWord.getIndex());
        }
        int[] windowWords = new int[intsList.size()];
        for (int x = 0; x < windowWords.length; ++x) {
            windowWords[x] = (Integer)intsList.get(x);
        }
        this.iterateSample(currentWord, windowWords, nextRandom, alpha, false, 0, true, null);
        if (this.batches != null && this.batches.get() != null && this.batches.get().size() >= this.configuration.getBatchSize()) {
            Nd4j.getExecutioner().exec(this.batches.get());
            this.batches.get().clear();
        }
    }

    public Sequence<T> applySubsampling(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        Sequence<T> result = new Sequence<T>();
        if (this.sampling > 0.0) {
            result.setSequenceId(sequence.getSequenceId());
            if (sequence.getSequenceLabels() != null) {
                result.setSequenceLabels(sequence.getSequenceLabels());
            }
            if (sequence.getSequenceLabel() != null) {
                result.setSequenceLabel(sequence.getSequenceLabel());
            }
            for (SequenceElement element : sequence.getElements()) {
                double numWords = this.vocabCache.totalWordOccurrences();
                double ran = (Math.sqrt(element.getElementFrequency() / (this.sampling * numWords)) + 1.0) * (this.sampling * numWords) / element.getElementFrequency();
                nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
                if (ran < (double)(nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                result.addElement(element);
            }
            return result;
        }
        return sequence;
    }

    public DeviceLocalNDArray getSyn0() {
        return this.syn0;
    }

    public DeviceLocalNDArray getSyn1() {
        return this.syn1;
    }

    public DeviceLocalNDArray getSyn1Neg() {
        return this.syn1Neg;
    }

    public DeviceLocalNDArray getExpTable() {
        return this.expTable;
    }

    public DeviceLocalNDArray getTable() {
        return this.table;
    }

    public void setSyn0(DeviceLocalNDArray syn0) {
        this.syn0 = syn0;
    }

    public void setSyn1(DeviceLocalNDArray syn1) {
        this.syn1 = syn1;
    }

    public void setSyn1Neg(DeviceLocalNDArray syn1Neg) {
        this.syn1Neg = syn1Neg;
    }

    public void setExpTable(DeviceLocalNDArray expTable) {
        this.expTable = expTable;
    }

    public void setTable(DeviceLocalNDArray table) {
        this.table = table;
    }
}

