/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.deeplearning4j.common.util.DL4JFileUtils;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.SkipGram;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectorsImpl;
import org.deeplearning4j.models.fasttext.FastText;
import org.deeplearning4j.models.paragraphvectors.ParagraphVectors;
import org.deeplearning4j.models.sequencevectors.SequenceVectors;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceElementFactory;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.sequencevectors.serialization.VocabWordFactory;
import org.deeplearning4j.models.word2vec.StaticWord2Vec;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.VocabularyHolder;
import org.deeplearning4j.models.word2vec.wordstore.VocabularyWord;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.sentenceiterator.BasicLineIterator;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.OneTimeLogger;
import org.nd4j.compression.impl.NoOp;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.AbstractStorage;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.storage.CompressedRamStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordVectorSerializer {
    private static final Logger log = LoggerFactory.getLogger(WordVectorSerializer.class);
    private static final int MAX_SIZE = 50;
    private static final String WHITESPACE_REPLACEMENT = "_Az92_";
    private static final String CONFIG_ENTRY = "config.json";
    private static final String VOCAB_ENTRY = "vocabulary.json";
    private static final String SYN0_ENTRY = "syn0.bin";
    private static final String SYN1_ENTRY = "syn1.bin";
    private static final String SYN1_NEG_ENTRY = "syn1neg.bin";

    private WordVectorSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Word2Vec readBinaryModel(InputStream inputStream, boolean linebreaks, boolean normalize) throws NumberFormatException, IOException {
        InMemoryLookupTable lookupTable;
        AbstractCache<VocabWord> cache;
        INDArray syn0;
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(false);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
        try (DataInputStream dis = new DataInputStream(inputStream);){
            int words = Integer.parseInt(ReadHelper.readString(dis));
            int size = Integer.parseInt(ReadHelper.readString(dis));
            syn0 = Nd4j.create((int[])new int[]{words, size});
            cache = new AbstractCache<VocabWord>();
            WordVectorSerializer.printOutProjectedMemoryUse(words, size, 1);
            lookupTable = new InMemoryLookupTable.Builder<VocabWord>().cache(cache).useHierarchicSoftmax(false).vectorLength(size).build();
            float[] vector = new float[size];
            for (int i = 0; i < words; ++i) {
                String word = ReadHelper.readString(dis);
                log.trace("Loading {} with word {}", (Object)word, (Object)i);
                for (int j = 0; j < size; ++j) {
                    vector[j] = ReadHelper.readFloat(dis);
                }
                if (cache.containsWord(word)) {
                    throw new ND4JIllegalStateException("Tried to add existing word. Probably time to switch linebreaks mode?");
                }
                syn0.putRow((long)i, normalize ? Transforms.unitVec((INDArray)Nd4j.create((float[])vector)) : Nd4j.create((float[])vector));
                VocabWord vw = new VocabWord(1.0, word);
                vw.setIndex(cache.numWords());
                cache.addToken(vw);
                cache.addWordToIndex(vw.getIndex(), vw.getLabel());
                cache.putVocabWord(word);
                if (linebreaks) {
                    dis.readByte();
                }
                Nd4j.getMemoryManager().invokeGcOccasionally();
            }
        }
        finally {
            if (originalPeriodic) {
                Nd4j.getMemoryManager().togglePeriodicGc(true);
            }
            Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
        }
        lookupTable.setSyn0(syn0);
        Word2Vec ret = ((Word2Vec.Builder)new Word2Vec.Builder().useHierarchicSoftmax(false).resetModel(false).layerSize(syn0.columns()).allowParallelTokenization(true).elementsLearningAlgorithm((ElementsLearningAlgorithm)new SkipGram())).learningRate(0.025).windowSize(5).workers(1).build();
        ret.setVocab(cache);
        ret.setLookupTable(lookupTable);
        return ret;
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, String path) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));){
            WordVectorSerializer.writeWordVectors(lookupTable, (OutputStream)bos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, File file) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            WordVectorSerializer.writeWordVectors(lookupTable, (OutputStream)bos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, OutputStream stream) throws IOException {
        VocabCache<T> vocabCache = lookupTable.getVocabCache();
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
            String str = vocabCache.numWords() + " " + lookupTable.layerSize() + " " + vocabCache.totalNumberOfDocs();
            log.debug("Saving header: {}", (Object)str);
            writer.println(str);
            int num = vocabCache.numWords();
            for (int x = 0; x < num; ++x) {
                T element = vocabCache.elementAtIndex(x);
                StringBuilder builder = new StringBuilder();
                String l = ((SequenceElement)element).getLabel();
                builder.append(ReadHelper.encodeB64(l)).append(" ");
                INDArray vec = lookupTable.vector(((SequenceElement)element).getLabel());
                int i = 0;
                while ((long)i < vec.length()) {
                    builder.append(vec.getDouble((long)i));
                    if ((long)i < vec.length() - 1L) {
                        builder.append(" ");
                    }
                    ++i;
                }
                writer.println(builder.toString());
            }
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull ParagraphVectors vectors, @NonNull File path) {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull ParagraphVectors vectors, @NonNull String path) {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream stream = new BufferedOutputStream(fos);){
            WordVectorSerializer.writeParagraphVectors(vectors, stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, String path) {
        WordVectorSerializer.writeParagraphVectors(vectors, new File(path));
    }

    public static void writeWord2VecModel(Word2Vec vectors, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream stream = new BufferedOutputStream(fos);){
            WordVectorSerializer.writeWord2VecModel(vectors, stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWord2VecModel(Word2Vec vectors, String path) {
        WordVectorSerializer.writeWord2VecModel(vectors, new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWord2VecModel(Word2Vec vectors, OutputStream stream) throws IOException {
        ZipOutputStream zipfile = new ZipOutputStream(new BufferedOutputStream((OutputStream)new CloseShieldOutputStream(stream)));
        ZipEntry syn0 = new ZipEntry("syn0.txt");
        zipfile.putNextEntry(syn0);
        File tempFileSyn0 = DL4JFileUtils.createTempFile((String)"word2vec", (String)"0");
        File tempFileSyn1 = DL4JFileUtils.createTempFile((String)"word2vec", (String)"1");
        File tempFileSyn1Neg = DL4JFileUtils.createTempFile((String)"word2vec", (String)"n");
        File tempFileCodes = DL4JFileUtils.createTempFile((String)"word2vec", (String)"h");
        File tempFileHuffman = DL4JFileUtils.createTempFile((String)"word2vec", (String)"h");
        File tempFileFreqs = DL4JFileUtils.createTempFile((String)"word2vec", (String)"f");
        tempFileSyn0.deleteOnExit();
        tempFileSyn1.deleteOnExit();
        tempFileSyn1Neg.deleteOnExit();
        tempFileFreqs.deleteOnExit();
        tempFileCodes.deleteOnExit();
        tempFileHuffman.deleteOnExit();
        try {
            Object row;
            WordVectorSerializer.writeWordVectors(vectors.lookupTable(), tempFileSyn0);
            FileUtils.copyFile((File)tempFileSyn0, (OutputStream)zipfile);
            INDArray syn1 = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1();
            if (syn1 != null) {
                try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1));){
                    for (int x = 0; x < syn1.rows(); ++x) {
                        row = syn1.getRow((long)x);
                        StringBuilder builder = new StringBuilder();
                        int i = 0;
                        while ((long)i < row.length()) {
                            builder.append(row.getDouble((long)i)).append(" ");
                            ++i;
                        }
                        writer.println(builder.toString().trim());
                    }
                }
            }
            ZipEntry zSyn1 = new ZipEntry("syn1.txt");
            zipfile.putNextEntry(zSyn1);
            FileUtils.copyFile((File)tempFileSyn1, (OutputStream)zipfile);
            INDArray syn1Neg = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1Neg();
            if (syn1Neg != null) {
                PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1Neg));
                row = null;
                try {
                    for (int x = 0; x < syn1Neg.rows(); ++x) {
                        INDArray row2 = syn1Neg.getRow((long)x);
                        StringBuilder builder = new StringBuilder();
                        int i = 0;
                        while ((long)i < row2.length()) {
                            builder.append(row2.getDouble((long)i)).append(" ");
                            ++i;
                        }
                        writer.println(builder.toString().trim());
                    }
                }
                catch (Throwable x) {
                    row = x;
                    throw x;
                }
                finally {
                    if (writer != null) {
                        if (row != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x) {
                                ((Throwable)row).addSuppressed(x);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            ZipEntry zSyn1Neg = new ZipEntry("syn1Neg.txt");
            zipfile.putNextEntry(zSyn1Neg);
            FileUtils.copyFile((File)tempFileSyn1Neg, (OutputStream)zipfile);
            ZipEntry hC = new ZipEntry("codes.txt");
            zipfile.putNextEntry(hC);
            try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileCodes));){
                for (int i = 0; i < vectors.getVocab().numWords(); ++i) {
                    VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                    StringBuilder builder = new StringBuilder(ReadHelper.encodeB64(word.getLabel())).append(" ");
                    for (byte code : word.getCodes()) {
                        builder.append(code).append(" ");
                    }
                    writer.println(builder.toString().trim());
                }
            }
            FileUtils.copyFile((File)tempFileCodes, (OutputStream)zipfile);
            ZipEntry hP = new ZipEntry("huffman.txt");
            zipfile.putNextEntry(hP);
            try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileHuffman));){
                for (int i = 0; i < vectors.getVocab().numWords(); ++i) {
                    VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                    StringBuilder builder = new StringBuilder(ReadHelper.encodeB64(word.getLabel())).append(" ");
                    for (int point : word.getPoints()) {
                        builder.append(point).append(" ");
                    }
                    writer.println(builder.toString().trim());
                }
            }
            FileUtils.copyFile((File)tempFileHuffman, (OutputStream)zipfile);
            ZipEntry hF = new ZipEntry("frequencies.txt");
            zipfile.putNextEntry(hF);
            try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileFreqs));){
                for (int i = 0; i < vectors.getVocab().numWords(); ++i) {
                    VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                    StringBuilder builder = new StringBuilder(ReadHelper.encodeB64(word.getLabel())).append(" ").append(word.getElementFrequency()).append(" ").append(vectors.getVocab().docAppearedIn(word.getLabel()));
                    writer.println(builder.toString().trim());
                }
            }
            FileUtils.copyFile((File)tempFileFreqs, (OutputStream)zipfile);
            ZipEntry config = new ZipEntry(CONFIG_ENTRY);
            zipfile.putNextEntry(config);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(vectors.getConfiguration().toJson().getBytes(StandardCharsets.UTF_8));){
                IOUtils.copy((InputStream)bais, (OutputStream)zipfile);
            }
            zipfile.flush();
            zipfile.close();
        }
        catch (Throwable throwable) {
            for (File f : new File[]{tempFileSyn0, tempFileSyn1, tempFileSyn1Neg, tempFileCodes, tempFileHuffman, tempFileFreqs}) {
                try {
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        for (File f : new File[]{tempFileSyn0, tempFileSyn1, tempFileSyn1Neg, tempFileCodes, tempFileHuffman, tempFileFreqs}) {
            try {
                f.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeParagraphVectors(ParagraphVectors vectors, OutputStream stream) throws IOException {
        ZipOutputStream zipfile = new ZipOutputStream(new BufferedOutputStream((OutputStream)new CloseShieldOutputStream(stream)));
        ZipEntry syn0 = new ZipEntry("syn0.txt");
        zipfile.putNextEntry(syn0);
        File tempFileSyn0 = DL4JFileUtils.createTempFile((String)"paravec", (String)"0");
        File tempFileSyn1 = DL4JFileUtils.createTempFile((String)"paravec", (String)"1");
        File tempFileCodes = DL4JFileUtils.createTempFile((String)"paravec", (String)"h");
        File tempFileHuffman = DL4JFileUtils.createTempFile((String)"paravec", (String)"h");
        File tempFileFreqs = DL4JFileUtils.createTempFile((String)"paravec", (String)"h");
        tempFileSyn0.deleteOnExit();
        tempFileSyn1.deleteOnExit();
        tempFileCodes.deleteOnExit();
        tempFileHuffman.deleteOnExit();
        tempFileFreqs.deleteOnExit();
        try {
            Object row;
            WordVectorSerializer.writeWordVectors(vectors.lookupTable(), tempFileSyn0);
            FileUtils.copyFile((File)tempFileSyn0, (OutputStream)zipfile);
            INDArray syn1 = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1();
            if (syn1 != null) {
                try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1));){
                    for (int x = 0; x < syn1.rows(); ++x) {
                        row = syn1.getRow((long)x);
                        StringBuilder builder = new StringBuilder();
                        int i = 0;
                        while ((long)i < row.length()) {
                            builder.append(row.getDouble((long)i)).append(" ");
                            ++i;
                        }
                        writer.println(builder.toString().trim());
                    }
                }
            }
            ZipEntry zSyn1 = new ZipEntry("syn1.txt");
            zipfile.putNextEntry(zSyn1);
            FileUtils.copyFile((File)tempFileSyn1, (OutputStream)zipfile);
            ZipEntry hC = new ZipEntry("codes.txt");
            zipfile.putNextEntry(hC);
            PrintWriter writer = new PrintWriter(new FileWriter(tempFileCodes));
            row = null;
            try {
                for (int i = 0; i < vectors.getVocab().numWords(); ++i) {
                    VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                    StringBuilder builder = new StringBuilder(ReadHelper.encodeB64(word.getLabel())).append(" ");
                    for (byte code : word.getCodes()) {
                        builder.append(code).append(" ");
                    }
                    writer.println(builder.toString().trim());
                }
            }
            catch (Throwable i) {
                row = i;
                throw i;
            }
            finally {
                if (writer != null) {
                    if (row != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)row).addSuppressed(i);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            FileUtils.copyFile((File)tempFileCodes, (OutputStream)zipfile);
            ZipEntry hP = new ZipEntry("huffman.txt");
            zipfile.putNextEntry(hP);
            try (PrintWriter writer2 = new PrintWriter(new FileWriter(tempFileHuffman));){
                for (int i = 0; i < vectors.getVocab().numWords(); ++i) {
                    VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                    StringBuilder builder = new StringBuilder(ReadHelper.encodeB64(word.getLabel())).append(" ");
                    for (int point : word.getPoints()) {
                        builder.append(point).append(" ");
                    }
                    writer2.println(builder.toString().trim());
                }
            }
            FileUtils.copyFile((File)tempFileHuffman, (OutputStream)zipfile);
            ZipEntry config = new ZipEntry(CONFIG_ENTRY);
            zipfile.putNextEntry(config);
            IOUtils.write((String)vectors.getConfiguration().toJson(), (OutputStream)zipfile, (Charset)StandardCharsets.UTF_8);
            ZipEntry labels = new ZipEntry("labels.txt");
            zipfile.putNextEntry(labels);
            StringBuilder builder = new StringBuilder();
            for (VocabWord word : vectors.getVocab().tokens()) {
                if (!word.isLabel()) continue;
                builder.append(ReadHelper.encodeB64(word.getLabel())).append("\n");
            }
            IOUtils.write((String)builder.toString().trim(), (OutputStream)zipfile, (Charset)StandardCharsets.UTF_8);
            ZipEntry hF = new ZipEntry("frequencies.txt");
            zipfile.putNextEntry(hF);
            try (PrintWriter writer3 = new PrintWriter(new FileWriter(tempFileFreqs));){
                for (int i = 0; i < vectors.getVocab().numWords(); ++i) {
                    VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                    builder = new StringBuilder(ReadHelper.encodeB64(word.getLabel())).append(" ").append(word.getElementFrequency()).append(" ").append(vectors.getVocab().docAppearedIn(word.getLabel()));
                    writer3.println(builder.toString().trim());
                }
            }
            FileUtils.copyFile((File)tempFileFreqs, (OutputStream)zipfile);
            zipfile.flush();
            zipfile.close();
        }
        catch (Throwable throwable) {
            for (File f : new File[]{tempFileSyn0, tempFileSyn1, tempFileCodes, tempFileHuffman, tempFileFreqs}) {
                try {
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        for (File f : new File[]{tempFileSyn0, tempFileSyn1, tempFileCodes, tempFileHuffman, tempFileFreqs}) {
            try {
                f.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ParagraphVectors readParagraphVectors(String path) throws IOException {
        return WordVectorSerializer.readParagraphVectors(new File(path));
    }

    public static ParagraphVectors readParagraphVectors(File file) throws IOException {
        ParagraphVectors vectors;
        block25: {
            Word2Vec w2v = WordVectorSerializer.readWord2Vec(file);
            vectors = ((ParagraphVectors.Builder)((ParagraphVectors.Builder)new ParagraphVectors.Builder(w2v.getConfiguration()).vocabCache(w2v.getVocab())).lookupTable(w2v.getLookupTable())).resetModel(false).build();
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry labels = zipFile.getEntry("labels.txt");
                if (labels == null) break block25;
                InputStream stream = zipFile.getInputStream(labels);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        VocabWord word = (VocabWord)vectors.getVocab().tokenFor(ReadHelper.decodeB64(line.trim()));
                        if (word == null) continue;
                        word.markAsLabel(true);
                    }
                }
            }
        }
        vectors.extractLabels();
        return vectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Word2Vec readWord2Vec(File file) throws IOException {
        Serializable serializable;
        int originalFreq;
        File tmpFileF;
        File tmpFileH;
        File tmpFileC;
        File tmpFileSyn1;
        File tmpFileSyn0;
        block68: {
            tmpFileSyn0 = DL4JFileUtils.createTempFile((String)"word2vec", (String)"0");
            tmpFileSyn1 = DL4JFileUtils.createTempFile((String)"word2vec", (String)"1");
            tmpFileC = DL4JFileUtils.createTempFile((String)"word2vec", (String)"c");
            tmpFileH = DL4JFileUtils.createTempFile((String)"word2vec", (String)"h");
            tmpFileF = DL4JFileUtils.createTempFile((String)"word2vec", (String)"f");
            tmpFileSyn0.deleteOnExit();
            tmpFileSyn1.deleteOnExit();
            tmpFileH.deleteOnExit();
            tmpFileC.deleteOnExit();
            tmpFileF.deleteOnExit();
            originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
            boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
            if (originalPeriodic) {
                Nd4j.getMemoryManager().togglePeriodicGc(false);
            }
            Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
            try {
                ZipEntry zsyn1Neg;
                ZipFile zipFile = new ZipFile(file);
                ZipEntry syn0 = zipFile.getEntry("syn0.txt");
                InputStream stream = zipFile.getInputStream(syn0);
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn0);
                ZipEntry syn1 = zipFile.getEntry("syn1.txt");
                stream = zipFile.getInputStream(syn1);
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn1);
                ZipEntry codes = zipFile.getEntry("codes.txt");
                stream = zipFile.getInputStream(codes);
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileC);
                ZipEntry huffman = zipFile.getEntry("huffman.txt");
                stream = zipFile.getInputStream(huffman);
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileH);
                ZipEntry config = zipFile.getEntry(CONFIG_ENTRY);
                stream = zipFile.getInputStream(config);
                StringBuilder builder = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        builder.append(line);
                    }
                }
                VectorsConfiguration configuration = VectorsConfiguration.fromJson(builder.toString().trim());
                Word2Vec w2v = WordVectorSerializer.readWord2VecFromText(tmpFileSyn0, tmpFileSyn1, tmpFileC, tmpFileH, configuration);
                ZipEntry frequencies = zipFile.getEntry("frequencies.txt");
                if (frequencies != null) {
                    stream = zipFile.getInputStream(frequencies);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    serializable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String[] split = line.split(" ");
                            VocabWord word = (VocabWord)w2v.getVocab().tokenFor(ReadHelper.decodeB64(split[0]));
                            word.setElementFrequency((long)Double.parseDouble(split[1]));
                            word.setSequencesCount((long)Double.parseDouble(split[2]));
                        }
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (serializable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                if ((zsyn1Neg = zipFile.getEntry("syn1Neg.txt")) != null) {
                    stream = zipFile.getInputStream(zsyn1Neg);
                    File[] fileArray = null;
                    try (InputStreamReader isr = new InputStreamReader(stream);
                         BufferedReader reader = new BufferedReader(isr);){
                        String line = null;
                        ArrayList<INDArray> rows = new ArrayList<INDArray>();
                        while ((line = reader.readLine()) != null) {
                            String[] split = line.split(" ");
                            double[] array = new double[split.length];
                            for (int i = 0; i < split.length; ++i) {
                                array[i] = Double.parseDouble(split[i]);
                            }
                            rows.add(Nd4j.create((double[])array, (long[])new long[]{array.length}, (DataType)((InMemoryLookupTable)w2v.getLookupTable()).getSyn0().dataType()));
                        }
                        if (!rows.isEmpty()) {
                            INDArray syn1Neg = Nd4j.vstack(rows);
                            ((InMemoryLookupTable)w2v.getLookupTable()).setSyn1Neg(syn1Neg);
                        }
                    }
                    catch (Throwable object) {
                        fileArray = object;
                        throw object;
                    }
                }
                serializable = w2v;
                if (!originalPeriodic) break block68;
            }
            catch (Throwable throwable) {
                if (originalPeriodic) {
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                for (File f : new File[]{tmpFileSyn0, tmpFileSyn1, tmpFileC, tmpFileH, tmpFileF}) {
                    try {
                        f.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Nd4j.getMemoryManager().togglePeriodicGc(true);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
        for (File f : new File[]{tmpFileSyn0, tmpFileSyn1, tmpFileC, tmpFileH, tmpFileF}) {
            try {
                f.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return serializable;
    }

    public static ParagraphVectors readParagraphVectors(InputStream stream) throws IOException {
        File tmpFile = DL4JFileUtils.createTempFile((String)"restore", (String)"paravec");
        try {
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
            ParagraphVectors paragraphVectors = WordVectorSerializer.readParagraphVectors(tmpFile);
            return paragraphVectors;
        }
        finally {
            tmpFile.delete();
        }
    }

    public static Word2Vec readWord2VecFromText(@NonNull File vectors, @NonNull File hs, @NonNull File h_codes, @NonNull File h_points, @NonNull VectorsConfiguration configuration) throws IOException {
        int i;
        VocabWord word;
        String[] split;
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (hs == null) {
            throw new NullPointerException("hs is marked non-null but is null");
        }
        if (h_codes == null) {
            throw new NullPointerException("h_codes is marked non-null but is null");
        }
        if (h_points == null) {
            throw new NullPointerException("h_points is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(new FileInputStream(vectors));
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)pair.getFirst();
        lookupTable.setNegative(configuration.getNegative());
        if (configuration.getNegative() > 0.0) {
            lookupTable.initNegative();
        }
        VocabCache vocab = (VocabCache)pair.getSecond();
        BufferedReader reader = new BufferedReader(new FileReader(hs));
        String line = null;
        ArrayList<INDArray> rows = new ArrayList<INDArray>();
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            double[] array = new double[split.length];
            for (int i2 = 0; i2 < split.length; ++i2) {
                array[i2] = Double.parseDouble(split[i2]);
            }
            rows.add(Nd4j.create((double[])array, (long[])new long[]{array.length}, (DataType)lookupTable.getSyn0().dataType()));
        }
        reader.close();
        if (!rows.isEmpty()) {
            INDArray syn1 = Nd4j.vstack(rows);
            lookupTable.setSyn1(syn1);
        }
        reader = new BufferedReader(new FileReader(h_points));
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            word = (VocabWord)vocab.wordFor(ReadHelper.decodeB64(split[0]));
            ArrayList<Integer> points = new ArrayList<Integer>();
            for (i = 1; i < split.length; ++i) {
                points.add(Integer.parseInt(split[i]));
            }
            word.setPoints(points);
        }
        reader.close();
        reader = new BufferedReader(new FileReader(h_codes));
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            word = (VocabWord)vocab.wordFor(ReadHelper.decodeB64(split[0]));
            ArrayList<Byte> codes = new ArrayList<Byte>();
            for (i = 1; i < split.length; ++i) {
                codes.add(Byte.parseByte(split[i]));
            }
            word.setCodes(codes);
            word.setCodeLength((short)codes.size());
        }
        reader.close();
        Word2Vec.Builder builder = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).vocabCache(vocab)).lookupTable((WeightLookupTable)lookupTable)).resetModel(false);
        TokenizerFactory factory = WordVectorSerializer.getTokenizerFactory(configuration);
        if (factory != null) {
            builder.tokenizerFactory(factory);
        }
        Word2Vec w2v = builder.build();
        return w2v;
    }

    @Deprecated
    public static ParagraphVectors readParagraphVectorsFromText(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return WordVectorSerializer.readParagraphVectorsFromText(new File(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static ParagraphVectors readParagraphVectorsFromText(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ParagraphVectors paragraphVectors = WordVectorSerializer.readParagraphVectorsFromText(fis);
            return paragraphVectors;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static ParagraphVectors readParagraphVectorsFromText(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<INDArray> arrays = new ArrayList<INDArray>();
            AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                split[1] = split[1].replaceAll(WHITESPACE_REPLACEMENT, " ");
                VocabWord word = new VocabWord(1.0, split[1]);
                if (split[0].equals("L")) {
                    word.setSpecial(true);
                    word.markAsLabel(true);
                    labels.add(word.getLabel());
                } else if (split[0].equals("E")) {
                    word.setSpecial(false);
                    word.markAsLabel(false);
                } else {
                    throw new IllegalStateException("Source stream doesn't looks like ParagraphVectors serialized model");
                }
                word.setIndex(vocabCache.numWords());
                vocabCache.addToken(word);
                vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                vocabCache.putVocabWord(word.getLabel());
                float[] vector = new float[split.length - 2];
                for (int i = 2; i < split.length; ++i) {
                    vector[i - 2] = Float.parseFloat(split[i]);
                }
                INDArray row = Nd4j.create((float[])vector);
                arrays.add(row);
            }
            INDArray syn = Nd4j.vstack(arrays);
            InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).useAdaGrad(false).cache(vocabCache).build();
            Nd4j.clearNans((INDArray)syn);
            lookupTable.setSyn0(syn);
            LabelsSource source = new LabelsSource(labels);
            ParagraphVectors vectors = ((ParagraphVectors.Builder)((ParagraphVectors.Builder)((ParagraphVectors.Builder)new ParagraphVectors.Builder().labelsSource(source).vocabCache((VocabCache)vocabCache)).lookupTable((WeightLookupTable)lookupTable)).modelUtils((ModelUtils)new BasicModelUtils())).build();
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            vectors.extractLabels();
            return vectors;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(ParagraphVectors vectors, OutputStream stream) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
            VocabCache vocabCache = vectors.getVocab();
            for (VocabWord word : vocabCache.vocabWords()) {
                StringBuilder builder = new StringBuilder();
                builder.append(word.isLabel() ? "L" : "E").append(" ");
                builder.append(word.getLabel().replaceAll(" ", WHITESPACE_REPLACEMENT)).append(" ");
                INDArray vector = vectors.getWordVectorMatrix(word.getLabel());
                int j = 0;
                while ((long)j < vector.length()) {
                    builder.append(vector.getDouble((long)j));
                    if ((long)j < vector.length() - 1L) {
                        builder.append(" ");
                    }
                    ++j;
                }
                writer.write(builder.append("\n").toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(InMemoryLookupTable lookupTable, InMemoryLookupCache cache, String path) throws IOException {
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, false), StandardCharsets.UTF_8));){
            for (int i = 0; i < lookupTable.getSyn0().rows(); ++i) {
                String word = cache.wordAtIndex(i);
                if (word == null) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(word.replaceAll(" ", WHITESPACE_REPLACEMENT));
                sb.append(" ");
                INDArray wordVector = lookupTable.vector(word);
                int j = 0;
                while ((long)j < wordVector.length()) {
                    sb.append(wordVector.getDouble((long)j));
                    if ((long)j < wordVector.length() - 1L) {
                        sb.append(" ");
                    }
                    ++j;
                }
                sb.append("\n");
                write.write(sb.toString());
            }
        }
    }

    private static ObjectMapper getModelMapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    @Deprecated
    public static void writeFullModel(@NonNull Word2Vec vec, @NonNull String path) {
        int x;
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        WeightLookupTable lookupTable = vec.getLookupTable();
        VocabCache vocabCache = vec.getVocab();
        if (!(lookupTable instanceof InMemoryLookupTable)) {
            throw new IllegalStateException("At this moment only InMemoryLookupTable is supported.");
        }
        VectorsConfiguration conf = vec.getConfiguration();
        conf.setVocabSize(vocabCache.numWords());
        printWriter.println(conf.toJson());
        StringBuilder builder = new StringBuilder();
        for (x = 0; x < ((InMemoryLookupTable)lookupTable).getExpTable().length; ++x) {
            builder.append(((InMemoryLookupTable)lookupTable).getExpTable()[x]).append(" ");
        }
        printWriter.println(builder.toString().trim());
        if (conf.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getTable() != null) {
            builder = new StringBuilder();
            for (x = 0; x < ((InMemoryLookupTable)lookupTable).getTable().columns(); ++x) {
                builder.append(((InMemoryLookupTable)lookupTable).getTable().getDouble((long)x)).append(" ");
            }
            printWriter.println(builder.toString().trim());
        } else {
            printWriter.println("");
        }
        ArrayList words = new ArrayList(vocabCache.vocabWords());
        for (SequenceElement word : words) {
            int x2;
            VocabularyWord vw = new VocabularyWord(word.getLabel());
            vw.setCount(vocabCache.wordFrequency(word.getLabel()));
            vw.setHuffmanNode(VocabularyHolder.buildNode(word.getCodes(), word.getPoints(), word.getCodeLength(), word.getIndex()));
            INDArray syn0 = ((InMemoryLookupTable)lookupTable).getSyn0().getRow((long)vocabCache.indexOf(word.getLabel()));
            double[] dsyn0 = new double[syn0.columns()];
            for (int x3 = 0; x3 < conf.getLayersSize(); ++x3) {
                dsyn0[x3] = syn0.getDouble((long)x3);
            }
            vw.setSyn0(dsyn0);
            INDArray syn1 = ((InMemoryLookupTable)lookupTable).getSyn1().getRow((long)vocabCache.indexOf(word.getLabel()));
            double[] dsyn1 = new double[syn1.columns()];
            for (int x4 = 0; x4 < syn1.columns(); ++x4) {
                dsyn1[x4] = syn1.getDouble((long)x4);
            }
            vw.setSyn1(dsyn1);
            if (conf.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getSyn1Neg() != null) {
                INDArray syn1Neg = ((InMemoryLookupTable)lookupTable).getSyn1Neg().getRow((long)vocabCache.indexOf(word.getLabel()));
                double[] dsyn1Neg = new double[syn1Neg.columns()];
                for (x2 = 0; x2 < syn1Neg.columns(); ++x2) {
                    dsyn1Neg[x2] = syn1Neg.getDouble((long)x2);
                }
                vw.setSyn1Neg(dsyn1Neg);
            }
            if (conf.isUseAdaGrad() && ((InMemoryLookupTable)lookupTable).isUseAdaGrad()) {
                INDArray gradient = word.getHistoricalGradient();
                if (gradient == null) {
                    gradient = Nd4j.zeros((int[])new int[]{word.getCodes().size()});
                }
                double[] ada = new double[gradient.columns()];
                for (x2 = 0; x2 < gradient.columns(); ++x2) {
                    ada[x2] = gradient.getDouble((long)x2);
                }
                vw.setHistoricalGradient(ada);
            }
            printWriter.println(vw.toJson());
        }
        printWriter.flush();
        printWriter.close();
    }

    @Deprecated
    public static Word2Vec loadFullModel(@NonNull String path) throws FileNotFoundException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        BasicLineIterator iterator = new BasicLineIterator(new File(path));
        String confJson = iterator.nextSentence();
        log.info("Word2Vec conf. JSON: " + confJson);
        VectorsConfiguration configuration = VectorsConfiguration.fromJson(confJson);
        String eTable = iterator.nextSentence();
        String nTable = iterator.nextSentence();
        if (configuration.getNegative() > 0.0) {
            // empty if block
        }
        VocabularyHolder holder = new VocabularyHolder.Builder().minWordFrequency(configuration.getMinWordFrequency()).hugeModelExpected(configuration.isHugeModelExpected()).scavengerActivationThreshold(configuration.getScavengerActivationThreshold()).scavengerRetentionDelay(configuration.getScavengerRetentionDelay()).build();
        AtomicInteger counter = new AtomicInteger(0);
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        while (iterator.hasNext()) {
            String wordJson = iterator.nextSentence();
            VocabularyWord word = VocabularyWord.fromJson(wordJson);
            word.setSpecial(true);
            VocabWord vw = new VocabWord(word.getCount(), word.getWord());
            vw.setIndex(counter.getAndIncrement());
            vw.setIndex(word.getHuffmanNode().getIdx());
            vw.setCodeLength(word.getHuffmanNode().getLength());
            vw.setPoints(WordVectorSerializer.arrayToList(word.getHuffmanNode().getPoint(), (int)word.getHuffmanNode().getLength()));
            vw.setCodes(WordVectorSerializer.arrayToList(word.getHuffmanNode().getCode(), (int)word.getHuffmanNode().getLength()));
            vocabCache.addToken(vw);
            vocabCache.addWordToIndex(vw.getIndex(), vw.getLabel());
            vocabCache.putVocabWord(vw.getWord());
        }
        InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().negative(configuration.getNegative()).useAdaGrad(configuration.isUseAdaGrad()).lr(configuration.getLearningRate()).cache(vocabCache).vectorLength(configuration.getLayersSize()).build();
        lookupTable.resetWeights(true);
        iterator.reset();
        iterator.nextSentence();
        iterator.nextSentence();
        iterator.nextSentence();
        while (iterator.hasNext()) {
            String wordJson = iterator.nextSentence();
            VocabularyWord word = VocabularyWord.fromJson(wordJson);
            INDArray syn0 = lookupTable.getSyn0().getRow((long)vocabCache.indexOf(word.getWord()));
            syn0.assign(Nd4j.create((double[])word.getSyn0()));
            INDArray syn1 = lookupTable.getSyn1().getRow((long)vocabCache.indexOf(word.getWord()));
            syn1.assign(Nd4j.create((double[])word.getSyn1()));
            if (!(configuration.getNegative() > 0.0)) continue;
            INDArray syn1Neg = lookupTable.getSyn1Neg().getRow((long)vocabCache.indexOf(word.getWord()));
            syn1Neg.assign(Nd4j.create((double[])word.getSyn1Neg()));
        }
        Word2Vec vec = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).vocabCache((VocabCache)vocabCache)).lookupTable((WeightLookupTable)lookupTable)).resetModel(false).build();
        vec.setModelUtils(new BasicModelUtils());
        return vec;
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull String path) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path), false), "UTF-8"));
        WordVectorSerializer.writeWordVectors(vec, write);
        write.flush();
        write.close();
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull File file) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            WordVectorSerializer.writeWordVectors(vec, write);
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull OutputStream outputStream) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            WordVectorSerializer.writeWordVectors(vec, writer);
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull BufferedWriter writer) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        int words = 0;
        String str = vec.getVocab().numWords() + " " + vec.getLayerSize() + " " + vec.getVocab().totalNumberOfDocs();
        log.debug("Saving header: {}", (Object)str);
        writer.write(str + "\n");
        for (String word : vec.vocab().words()) {
            if (word == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(word.replaceAll(" ", WHITESPACE_REPLACEMENT));
            sb.append(" ");
            INDArray wordVector = vec.getWordVectorMatrix(word);
            int j = 0;
            while ((long)j < wordVector.length()) {
                sb.append(wordVector.getDouble((long)j));
                if ((long)j < wordVector.length() - 1L) {
                    sb.append(" ");
                }
                ++j;
            }
            sb.append("\n");
            writer.write(sb.toString());
            ++words;
        }
        try {
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
    }

    public static WordVectors fromTableAndVocab(WeightLookupTable table, VocabCache vocab) {
        WordVectorsImpl vectors = new WordVectorsImpl();
        vectors.setLookupTable(table);
        vectors.setVocab(vocab);
        vectors.setModelUtils(new BasicModelUtils());
        return vectors;
    }

    public static Word2Vec fromPair(Pair<InMemoryLookupTable, VocabCache> pair) {
        Word2Vec vectors = new Word2Vec();
        vectors.setLookupTable((WeightLookupTable)pair.getFirst());
        vectors.setVocab((VocabCache)pair.getSecond());
        vectors.setModelUtils(new BasicModelUtils());
        return vectors;
    }

    @Deprecated
    public static WordVectors loadTxtVectors(File vectorsFile) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(vectorsFile);
        Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(fileInputStream);
        return WordVectorSerializer.fromPair(pair);
    }

    static InputStream fileStream(@NonNull File file) throws IOException {
        InputStream inputStream;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        boolean isZip = file.getName().endsWith(".zip");
        boolean isGzip = GzipUtils.isCompressedFilename((String)file.getName());
        if (isZip) {
            inputStream = WordVectorSerializer.decompressZip(file);
        } else if (isGzip) {
            FileInputStream fis = new FileInputStream(file);
            inputStream = new GZIPInputStream(fis);
        } else {
            inputStream = new FileInputStream(file);
        }
        return new BufferedInputStream(inputStream);
    }

    private static InputStream decompressZip(File modelFile) throws IOException {
        ZipFile zipFile = new ZipFile(modelFile);
        InputStream inputStream = null;
        try (FileInputStream fis = new FileInputStream(modelFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zipStream = new ZipInputStream(bis);){
            ZipEntry entry = zipStream.getNextEntry();
            if (entry != null) {
                inputStream = zipFile.getInputStream(entry);
            }
            if (zipStream.getNextEntry() != null) {
                throw new RuntimeException("Zip archive " + modelFile + " contains more than 1 file");
            }
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<InMemoryLookupTable, VocabCache> loadTxt(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (InputStream inputStream = WordVectorSerializer.fileStream(file);){
            Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(inputStream);
            return pair;
        }
        catch (IOException readTestException) {
            throw new RuntimeException(readTestException);
        }
    }

    /*
     * Exception decompiling
     */
    public static Pair<InMemoryLookupTable, VocabCache> loadTxt(@NonNull InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean isHeader(String line, AbstractCache cache) {
        if (!line.contains(" ")) {
            return true;
        }
        String[] headers = line.split(" ");
        try {
            long[] header = new long[headers.length];
            for (int x = 0; x < headers.length; ++x) {
                header[x] = Long.parseLong(headers[x]);
            }
            if (headers.length == 3) {
                long numberOfDocuments = header[2];
                cache.incrementTotalDocCount(numberOfDocuments);
            }
            long numWords = header[0];
            int vectorLength = (int)header[1];
            WordVectorSerializer.printOutProjectedMemoryUse(numWords, vectorLength, 1);
            return true;
        }
        catch (Exception notHeaderException) {
            return false;
        }
    }

    @Deprecated
    public static WordVectors loadTxtVectors(@NonNull InputStream stream, boolean skipFirstLine) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        AbstractCache<VocabWord> cache = new AbstractCache.Builder().build();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = "";
        ArrayList<INDArray> arrays = new ArrayList<INDArray>();
        if (skipFirstLine) {
            reader.readLine();
        }
        while ((line = reader.readLine()) != null) {
            String[] split = line.split(" ");
            String word = split[0].replaceAll(WHITESPACE_REPLACEMENT, " ");
            VocabWord word1 = new VocabWord(1.0, word);
            word1.setIndex(cache.numWords());
            cache.addToken(word1);
            cache.addWordToIndex(word1.getIndex(), word);
            cache.putVocabWord(word);
            float[] vector = new float[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            INDArray row = Nd4j.create((float[])vector);
            arrays.add(row);
        }
        InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).cache(cache).build();
        INDArray syn = Nd4j.vstack(arrays);
        Nd4j.clearNans((INDArray)syn);
        lookupTable.setSyn0(syn);
        return WordVectorSerializer.fromPair((Pair<InMemoryLookupTable, VocabCache>)Pair.makePair(lookupTable, cache));
    }

    public static void writeTsneFormat(Word2Vec vec, INDArray tsne, File csv) throws Exception {
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csv), StandardCharsets.UTF_8));){
            int words = 0;
            InMemoryLookupCache l = (InMemoryLookupCache)vec.vocab();
            for (String word : vec.vocab().words()) {
                if (word == null) continue;
                StringBuilder sb = new StringBuilder();
                INDArray wordVector = tsne.getRow((long)l.wordFor(word).getIndex());
                int j = 0;
                while ((long)j < wordVector.length()) {
                    sb.append(wordVector.getDouble((long)j));
                    if ((long)j < wordVector.length() - 1L) {
                        sb.append(",");
                    }
                    ++j;
                }
                sb.append(",");
                sb.append(word.replaceAll(" ", WHITESPACE_REPLACEMENT));
                sb.append(" ");
                sb.append("\n");
                write.write(sb.toString());
            }
            log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
        }
    }

    private static List<Byte> arrayToList(byte[] array, int codeLen) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int x = 0; x < codeLen; ++x) {
            result.add(array[x]);
        }
        return result;
    }

    private static byte[] listToArray(List<Byte> code) {
        byte[] array = new byte[40];
        for (int x = 0; x < code.size(); ++x) {
            array[x] = code.get(x);
        }
        return array;
    }

    private static int[] listToArray(List<Integer> points, int codeLen) {
        int[] array = new int[points.size()];
        for (int x = 0; x < points.size(); ++x) {
            array[x] = points.get(x);
        }
        return array;
    }

    private static List<Integer> arrayToList(int[] array, int codeLen) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int x = 0; x < codeLen; ++x) {
            result.add(array[x]);
        }
        return result;
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull String path) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeSequenceVectors(vectors, factory, fos);
        }
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull File file) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            WordVectorSerializer.writeSequenceVectors(vectors, factory, fos);
        }
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull OutputStream stream) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        WeightLookupTable lookupTable = vectors.getLookupTable();
        VocabCache vocabCache = vectors.getVocab();
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8)));){
            writer.write(vectors.getConfiguration().toEncodedJson());
            for (int x = 0; x < vocabCache.numWords(); ++x) {
                Object element = vocabCache.elementAtIndex(x);
                String json = factory.serialize(element);
                INDArray d = Nd4j.create((int)1);
                double[] vector = lookupTable.vector(((SequenceElement)element).getLabel()).dup().data().asDouble();
                ElementPair pair = new ElementPair(json, vector);
                writer.println(pair.toEncodedJson());
                writer.flush();
            }
        }
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull OutputStream stream) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)vectors.getLookupTable();
        AbstractCache vocabCache = (AbstractCache)vectors.getVocab();
        try (ZipOutputStream zipfile = new ZipOutputStream(new BufferedOutputStream((OutputStream)new CloseShieldOutputStream(stream)));
             DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zipfile));){
            INDArray syn1NegData;
            ZipEntry config = new ZipEntry(CONFIG_ENTRY);
            zipfile.putNextEntry(config);
            VectorsConfiguration configuration = vectors.getConfiguration();
            String json = configuration.toJson().trim();
            zipfile.write(json.getBytes("UTF-8"));
            ZipEntry vocab = new ZipEntry(VOCAB_ENTRY);
            zipfile.putNextEntry(vocab);
            zipfile.write(vocabCache.toJson().getBytes("UTF-8"));
            INDArray syn0Data = lookupTable.getSyn0();
            ZipEntry syn0 = new ZipEntry(SYN0_ENTRY);
            zipfile.putNextEntry(syn0);
            Nd4j.write((INDArray)syn0Data, (DataOutputStream)dos);
            dos.flush();
            INDArray syn1Data = lookupTable.getSyn1();
            if (syn1Data != null) {
                ZipEntry syn1 = new ZipEntry(SYN1_ENTRY);
                zipfile.putNextEntry(syn1);
                Nd4j.write((INDArray)syn1Data, (DataOutputStream)dos);
                dos.flush();
            }
            if ((syn1NegData = lookupTable.getSyn1Neg()) != null) {
                ZipEntry syn1neg = new ZipEntry(SYN1_NEG_ENTRY);
                zipfile.putNextEntry(syn1neg);
                Nd4j.write((INDArray)syn1NegData, (DataOutputStream)dos);
                dos.flush();
            }
        }
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull String path, boolean readExtendedTables) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        File file = new File(path);
        SequenceVectors<T> vectors = WordVectorSerializer.readSequenceVectors(file, readExtendedTables);
        return vectors;
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull File file, boolean readExtendedTables) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        SequenceVectors<T> vectors = WordVectorSerializer.readSequenceVectors(new FileInputStream(file), readExtendedTables);
        return vectors;
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull InputStream stream, boolean readExtendedTables) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        SequenceVectors vectors = null;
        AbstractCache vocabCache = null;
        VectorsConfiguration configuration = null;
        INDArray syn0 = null;
        INDArray syn1 = null;
        INDArray syn1neg = null;
        try (ZipInputStream zipfile = new ZipInputStream(new BufferedInputStream(stream));){
            ZipEntry entry = null;
            while ((entry = zipfile.getNextEntry()) != null) {
                String content;
                String name = entry.getName();
                byte[] bytes = IOUtils.toByteArray((InputStream)zipfile);
                if (name.equals(CONFIG_ENTRY)) {
                    content = new String(bytes, "UTF-8");
                    configuration = VectorsConfiguration.fromJson(content);
                    continue;
                }
                if (name.equals(VOCAB_ENTRY)) {
                    content = new String(bytes, "UTF-8");
                    vocabCache = AbstractCache.fromJson(content);
                    continue;
                }
                if (!readExtendedTables) continue;
                if (name.equals(SYN0_ENTRY)) {
                    syn0 = Nd4j.read((InputStream)new ByteArrayInputStream(bytes));
                    continue;
                }
                if (name.equals(SYN1_ENTRY)) {
                    syn1 = Nd4j.read((InputStream)new ByteArrayInputStream(bytes));
                    continue;
                }
                if (!name.equals(SYN1_NEG_ENTRY)) continue;
                syn1neg = Nd4j.read((InputStream)new ByteArrayInputStream(bytes));
            }
        }
        InMemoryLookupTable lookupTable = new InMemoryLookupTable();
        lookupTable.setSyn0(syn0);
        lookupTable.setSyn1(syn1);
        lookupTable.setSyn1Neg(syn1neg);
        vectors = new SequenceVectors.Builder(configuration).lookupTable(lookupTable).vocabCache(vocabCache).build();
        return vectors;
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull SequenceElementFactory<T> factory, @NonNull File file) throws IOException {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return WordVectorSerializer.readSequenceVectors(factory, new FileInputStream(file));
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull SequenceElementFactory<T> factory, @NonNull InputStream stream) throws IOException {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = reader.readLine();
        VectorsConfiguration configuration = VectorsConfiguration.fromJson(new String(Base64.decodeBase64((String)line), "UTF-8"));
        AbstractCache<T> vocabCache = new AbstractCache.Builder().build();
        ArrayList<INDArray> rows = new ArrayList<INDArray>();
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) continue;
            ElementPair pair = ElementPair.fromEncodedJson(line);
            T element = factory.deserialize(pair.getObject());
            rows.add(Nd4j.create((double[])pair.getVector()));
            vocabCache.addToken(element);
            vocabCache.addWordToIndex(((SequenceElement)element).getIndex(), ((SequenceElement)element).getLabel());
        }
        reader.close();
        InMemoryLookupTable lookupTable = new InMemoryLookupTable.Builder().vectorLength(((INDArray)rows.get(0)).columns()).cache(vocabCache).build();
        INDArray syn0 = Nd4j.vstack(rows);
        lookupTable.setSyn0(syn0);
        SequenceVectors vectors = new SequenceVectors.Builder<T>(configuration).vocabCache(vocabCache).lookupTable(lookupTable).resetModel(false).build();
        return vectors;
    }

    public static void writeVocabCache(@NonNull VocabCache<VocabWord> vocabCache, @NonNull File file) throws IOException {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            WordVectorSerializer.writeVocabCache(vocabCache, fos);
        }
    }

    public static void writeVocabCache(@NonNull VocabCache<VocabWord> vocabCache, @NonNull OutputStream stream) throws IOException {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8)));){
            writer.println("" + vocabCache.numWords() + " " + vocabCache.totalNumberOfDocs() + " " + vocabCache.totalWordOccurrences());
            for (int x = 0; x < vocabCache.numWords(); ++x) {
                VocabWord word = vocabCache.elementAtIndex(x);
                writer.println(word.toJSON());
            }
        }
    }

    public static VocabCache<VocabWord> readVocabCache(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            VocabCache<VocabWord> vocabCache = WordVectorSerializer.readVocabCache(fis);
            return vocabCache;
        }
    }

    public static VocabCache<VocabWord> readVocabCache(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        VocabWordFactory factory = new VocabWordFactory();
        boolean firstLine = true;
        long totalWordOcc = -1L;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                    String[] split = line.split("\\ ");
                    if (split.length != 3) continue;
                    try {
                        vocabCache.setTotalDocCount(Long.valueOf(split[1]));
                        totalWordOcc = Long.valueOf(split[2]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                VocabWord word = factory.deserialize(line);
                vocabCache.addToken(word);
                vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
            }
        }
        if (totalWordOcc >= 0L) {
            vocabCache.setTotalWordOccurences(totalWordOcc);
        }
        return vocabCache;
    }

    public static Word2Vec readWord2VecModel(String path) {
        return WordVectorSerializer.readWord2VecModel(new File(path));
    }

    public static Word2Vec readWord2VecModel(String path, boolean extendedModel) {
        return WordVectorSerializer.readWord2VecModel(new File(path), extendedModel);
    }

    public static Word2Vec readWord2VecModel(File file) {
        return WordVectorSerializer.readWord2VecModel(file, false);
    }

    public static Word2Vec readWord2VecModel(File file, boolean extendedModel) {
        if (!file.exists() || !file.isFile()) {
            throw new ND4JIllegalStateException("File [" + file.getAbsolutePath() + "] doesn't exist");
        }
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(false);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
        try {
            return WordVectorSerializer.readWord2Vec(file, extendedModel);
        }
        catch (Exception readSequenceVectors) {
            try {
                return extendedModel ? WordVectorSerializer.readAsExtendedModel(file) : WordVectorSerializer.readAsSimplifiedModel(file);
            }
            catch (Exception loadFromFileException) {
                try {
                    return WordVectorSerializer.readAsCsv(file);
                }
                catch (Exception readCsvException) {
                    try {
                        return WordVectorSerializer.readAsBinary(file);
                    }
                    catch (Exception readBinaryException) {
                        try {
                            return WordVectorSerializer.readAsBinaryNoLineBreaks(file);
                        }
                        catch (Exception readModelException) {
                            log.error("Unable to guess input file format", (Throwable)readModelException);
                            throw new RuntimeException("Unable to guess input file format. Please use corresponding loader directly");
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Word2Vec readAsBinaryNoLineBreaks(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (InputStream inputStream = WordVectorSerializer.fileStream(file);){
            Word2Vec word2Vec = WordVectorSerializer.readAsBinaryNoLineBreaks(inputStream);
            return word2Vec;
        }
        catch (IOException readCsvException) {
            throw new RuntimeException(readCsvException);
        }
    }

    public static Word2Vec readAsBinaryNoLineBreaks(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        try {
            if (originalPeriodic) {
                Nd4j.getMemoryManager().togglePeriodicGc(true);
            }
            Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            return WordVectorSerializer.readBinaryModel(inputStream, false, false);
        }
        catch (Exception readModelException) {
            log.error("Cannot read binary model", (Throwable)readModelException);
            throw new RuntimeException("Unable to guess input file format. Please use corresponding loader directly");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Word2Vec readAsBinary(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (InputStream inputStream = WordVectorSerializer.fileStream(file);){
            Word2Vec word2Vec = WordVectorSerializer.readAsBinary(inputStream);
            return word2Vec;
        }
        catch (IOException readCsvException) {
            throw new RuntimeException(readCsvException);
        }
    }

    public static Word2Vec readAsBinary(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        try {
            log.debug("Trying binary model restoration...");
            if (originalPeriodic) {
                Nd4j.getMemoryManager().togglePeriodicGc(true);
            }
            Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            return WordVectorSerializer.readBinaryModel(inputStream, true, false);
        }
        catch (Exception readModelException) {
            throw new RuntimeException(readModelException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Word2Vec readAsCsv(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (InputStream inputStream = WordVectorSerializer.fileStream(file);){
            Word2Vec word2Vec = WordVectorSerializer.readAsCsv(inputStream);
            return word2Vec;
        }
        catch (IOException readCsvException) {
            throw new RuntimeException(readCsvException);
        }
    }

    public static Word2Vec readAsCsv(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        VectorsConfiguration configuration = new VectorsConfiguration();
        try {
            log.debug("Trying CSV model restoration...");
            Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(inputStream);
            Word2Vec.Builder builder = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder().lookupTable((WeightLookupTable)pair.getFirst())).useAdaGrad(false).vocabCache((VocabCache)pair.getSecond())).layerSize(((InMemoryLookupTable)pair.getFirst()).layerSize()).useHierarchicSoftmax(false).resetModel(false);
            TokenizerFactory factory = WordVectorSerializer.getTokenizerFactory(configuration);
            if (factory != null) {
                builder.tokenizerFactory(factory);
            }
            return builder.build();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load model in CSV format");
        }
    }

    private static Word2Vec readAsExtendedModel(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        log.debug("Trying full model restoration...");
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(true);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
        return WordVectorSerializer.readWord2Vec(file);
    }

    private static Word2Vec readAsSimplifiedModel(@NonNull File file) throws IOException {
        VocabWord word;
        AutoCloseable reader;
        ZipEntry ve;
        Object line;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        InMemoryLookupTable lookupTable = new InMemoryLookupTable();
        AbstractCache<VocabWord> vocabCache = new AbstractCache<VocabWord>();
        INDArray syn0 = null;
        VectorsConfiguration configuration = new VectorsConfiguration();
        log.debug("Trying simplified model restoration...");
        File tmpFileSyn0 = DL4JFileUtils.createTempFile((String)"word2vec", (String)"syn");
        tmpFileSyn0.deleteOnExit();
        File tmpFileConfig = DL4JFileUtils.createTempFile((String)"word2vec", (String)"config");
        tmpFileConfig.deleteOnExit();
        ZipFile zipFile = new ZipFile(file);
        ZipEntry syn = zipFile.getEntry("syn0.txt");
        InputStream stream = zipFile.getInputStream(syn);
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn0);
        ZipEntry config = zipFile.getEntry(CONFIG_ENTRY);
        if (config != null) {
            stream = zipFile.getInputStream(config);
            StringBuilder builder = new StringBuilder();
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(stream));){
                while ((line = reader2.readLine()) != null) {
                    builder.append((String)line);
                }
            }
            configuration = VectorsConfiguration.fromJson(builder.toString().trim());
        }
        if ((ve = zipFile.getEntry("frequencies.txt")) != null) {
            stream = zipFile.getInputStream(ve);
            AtomicInteger cnt = new AtomicInteger(0);
            reader = new BufferedReader(new InputStreamReader(stream));
            line = null;
            try {
                String line2;
                while ((line2 = ((BufferedReader)reader).readLine()) != null) {
                    String[] split = line2.split(" ");
                    word = new VocabWord(Double.valueOf(split[1]), ReadHelper.decodeB64(split[0]));
                    word.setIndex(cnt.getAndIncrement());
                    word.incrementSequencesCount(Long.valueOf(split[2]));
                    vocabCache.addToken(word);
                    vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                    Nd4j.getMemoryManager().invokeGcOccasionally();
                }
            }
            catch (Throwable line2) {
                line = line2;
                throw line2;
            }
            finally {
                if (reader != null) {
                    if (line != null) {
                        try {
                            ((BufferedReader)reader).close();
                        }
                        catch (Throwable line2) {
                            ((Throwable)line).addSuppressed(line2);
                        }
                    } else {
                        ((BufferedReader)reader).close();
                    }
                }
            }
        }
        ArrayList<INDArray> rows = new ArrayList<INDArray>();
        try {
            reader = new CSVReader(tmpFileSyn0);
            line = null;
            try {
                AtomicInteger cnt = new AtomicInteger(0);
                while (reader.hasNext()) {
                    Pair<VocabWord, float[]> pair = reader.next();
                    word = (VocabWord)pair.getFirst();
                    INDArray vector = Nd4j.create((float[])((float[])pair.getSecond()));
                    if (ve != null) {
                        if (syn0 == null) {
                            syn0 = Nd4j.create((long[])new long[]{vocabCache.numWords(), vector.length()});
                        }
                        syn0.getRow((long)cnt.getAndIncrement()).assign(vector);
                    } else {
                        rows.add(vector);
                        vocabCache.addToken(word);
                        vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                    }
                    Nd4j.getMemoryManager().invokeGcOccasionally();
                }
            }
            catch (Throwable throwable) {
                line = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (line != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)line).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (originalPeriodic) {
                Nd4j.getMemoryManager().togglePeriodicGc(true);
            }
            Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            try {
                if (tmpFileSyn0 != null) {
                    tmpFileSyn0.delete();
                }
                if (tmpFileConfig != null) {
                    tmpFileConfig.delete();
                }
            }
            catch (Exception exception) {}
        }
        if (syn0 == null && vocabCache.numWords() > 0) {
            syn0 = Nd4j.vstack(rows);
        }
        if (syn0 == null) {
            log.error("Can't build syn0 table");
            throw new DL4JInvalidInputException("Can't build syn0 table");
        }
        lookupTable = new InMemoryLookupTable.Builder<VocabWord>().cache(vocabCache).vectorLength(syn0.columns()).useHierarchicSoftmax(false).useAdaGrad(false).build();
        lookupTable.setSyn0(syn0);
        Word2Vec.Builder builder = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).lookupTable((WeightLookupTable)lookupTable)).useAdaGrad(false).vocabCache((VocabCache)vocabCache)).layerSize(lookupTable.layerSize()).useHierarchicSoftmax(false).resetModel(false);
        TokenizerFactory factory = WordVectorSerializer.getTokenizerFactory(configuration);
        if (factory != null) {
            builder.tokenizerFactory(factory);
        }
        Word2Vec vec = builder.build();
        return vec;
    }

    protected static TokenizerFactory getTokenizerFactory(VectorsConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        if (configuration.getTokenizerFactory() != null && !configuration.getTokenizerFactory().isEmpty()) {
            try {
                TokenizerFactory factory = (TokenizerFactory)Class.forName(configuration.getTokenizerFactory()).newInstance();
                if (configuration.getTokenPreProcessor() != null && !configuration.getTokenPreProcessor().isEmpty()) {
                    TokenPreProcess preProcessor = (TokenPreProcess)Class.forName(configuration.getTokenPreProcessor()).newInstance();
                    factory.setTokenPreProcessor(preProcessor);
                }
                return factory;
            }
            catch (Exception e) {
                log.error("Can't instantiate saved TokenizerFactory: {}", (Object)configuration.getTokenizerFactory());
            }
        }
        return null;
    }

    public static WordVectors loadStaticModel(InputStream inputStream) throws IOException {
        File tmpFile = DL4JFileUtils.createTempFile((String)("word2vec" + System.currentTimeMillis()), (String)".tmp");
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpFile);
        try {
            WordVectors wordVectors = WordVectorSerializer.loadStaticModel(tmpFile);
            return wordVectors;
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WordVectors loadStaticModel(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new RuntimeException(new FileNotFoundException("File [" + file.getAbsolutePath() + "] was not found"));
        }
        int originalFreq = Nd4j.getMemoryManager().getOccasionalGcFrequency();
        boolean originalPeriodic = Nd4j.getMemoryManager().isPeriodicGcActive();
        if (originalPeriodic) {
            Nd4j.getMemoryManager().togglePeriodicGc(false);
        }
        Nd4j.getMemoryManager().setOccasionalGcFrequency(50000);
        CompressedRamStorage storage = new CompressedRamStorage.Builder().useInplaceCompression(false).setCompressor((NDArrayCompressor)new NoOp()).emulateIsAbsent(false).build();
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        try {
            log.debug("Trying DL4j format...");
            File tmpFileSyn0 = DL4JFileUtils.createTempFile((String)"word2vec", (String)"syn");
            tmpFileSyn0.deleteOnExit();
            ZipFile zipFile = new ZipFile(file);
            ZipEntry syn0 = zipFile.getEntry("syn0.txt");
            InputStream stream = zipFile.getInputStream(syn0);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFileSyn0);
            storage.clear();
            try (CSVReader reader = new CSVReader(tmpFileSyn0);){
                while (reader.hasNext()) {
                    Pair<VocabWord, float[]> pair = reader.next();
                    VocabWord word = (VocabWord)pair.getFirst();
                    storage.store((Object)word.getIndex(), (float[])pair.getSecond());
                    vocabCache.addToken(word);
                    vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                    Nd4j.getMemoryManager().invokeGcOccasionally();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (originalPeriodic) {
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                try {
                    tmpFileSyn0.delete();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            try {
                vocabCache = new AbstractCache.Builder().build();
                storage.clear();
                log.debug("Trying CSVReader...");
                try (CSVReader reader = new CSVReader(file);){
                    while (reader.hasNext()) {
                        Pair<VocabWord, float[]> pair = reader.next();
                        VocabWord word = (VocabWord)pair.getFirst();
                        storage.store((Object)word.getIndex(), (float[])pair.getSecond());
                        vocabCache.addToken(word);
                        vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                        Nd4j.getMemoryManager().invokeGcOccasionally();
                    }
                }
                catch (Exception ef) {
                    throw new RuntimeException(ef);
                }
                finally {
                    if (originalPeriodic) {
                        Nd4j.getMemoryManager().togglePeriodicGc(true);
                    }
                    Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
                }
            }
            catch (Exception ex) {
                block72: {
                    log.debug("Trying BinaryReader...");
                    vocabCache = new AbstractCache.Builder().build();
                    storage.clear();
                    try {
                        try (BinaryReader reader = new BinaryReader(file);){
                            while (reader.hasNext()) {
                                Pair<VocabWord, float[]> pair = reader.next();
                                VocabWord word = (VocabWord)pair.getFirst();
                                storage.store((Object)word.getIndex(), (float[])pair.getSecond());
                                vocabCache.addToken(word);
                                vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                                Nd4j.getMemoryManager().invokeGcOccasionally();
                            }
                        }
                        if (!originalPeriodic) break block72;
                    }
                    catch (Exception ez) {
                        throw new RuntimeException("Unable to guess input file format");
                    }
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            }
            finally {
                if (originalPeriodic) {
                    Nd4j.getMemoryManager().togglePeriodicGc(true);
                }
                Nd4j.getMemoryManager().setOccasionalGcFrequency(originalFreq);
            }
        }
        StaticWord2Vec word2Vec = new StaticWord2Vec.Builder((AbstractStorage<Integer>)storage, vocabCache).build();
        return word2Vec;
    }

    public static void writeWord2Vec(@NonNull Word2Vec word2Vec, @NonNull OutputStream stream) throws IOException {
        if (word2Vec == null) {
            throw new NullPointerException("word2Vec is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        SequenceVectors vectors = new SequenceVectors.Builder(word2Vec.getConfiguration()).layerSize(word2Vec.getLayerSize()).build();
        vectors.setVocab(word2Vec.getVocab());
        vectors.setLookupTable(word2Vec.getLookupTable());
        vectors.setModelUtils(word2Vec.getModelUtils());
        WordVectorSerializer.writeSequenceVectors(vectors, stream);
    }

    public static Word2Vec readWord2Vec(@NonNull String path, boolean readExtendedTables) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        File file = new File(path);
        return WordVectorSerializer.readWord2Vec(file, readExtendedTables);
    }

    public static <T extends SequenceElement> void writeLookupTable(WeightLookupTable<T> weightLookupTable, @NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            int numWords = weightLookupTable.getVocabCache().numWords();
            int layersSize = weightLookupTable.layerSize();
            long totalNumberOfDocs = weightLookupTable.getVocabCache().totalNumberOfDocs();
            String format = "%d %d %d\n";
            String header = String.format(format, numWords, layersSize, totalNumberOfDocs);
            writer.write(header);
            String row = "";
            for (int j = 0; j < weightLookupTable.getVocabCache().words().size(); ++j) {
                String label = weightLookupTable.getVocabCache().wordAtIndex(j);
                row = row + label + " ";
                int freq = weightLookupTable.getVocabCache().wordFrequency(label);
                int rows = ((InMemoryLookupTable)weightLookupTable).getSyn0().rows();
                int cols = ((InMemoryLookupTable)weightLookupTable).getSyn0().columns();
                row = row + freq + " " + rows + " " + cols + " ";
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        row = row + ((InMemoryLookupTable)weightLookupTable).getSyn0().getDouble((long)r, (long)c) + " ";
                    }
                }
                row = row + "\n";
            }
            writer.write(row);
        }
    }

    public static <T extends SequenceElement> WeightLookupTable<T> readLookupTable(File file) throws IOException {
        return WordVectorSerializer.readLookupTable(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SequenceElement> WeightLookupTable<T> readLookupTable(InputStream stream) throws IOException {
        InMemoryLookupTable weightLookupTable = null;
        AbstractCache vocabCache = new AbstractCache();
        int startSyn0 = 4;
        boolean headerRead = false;
        int numWords = -1;
        int layerSize = -1;
        int totalNumberOfDocs = -1;
        try {
            INDArray syn0 = null;
            int index = 0;
            for (String line : IOUtils.readLines((InputStream)stream)) {
                String[] tokens = line.split(" ");
                if (!headerRead) {
                    numWords = Integer.parseInt(tokens[0]);
                    layerSize = Integer.parseInt(tokens[1]);
                    totalNumberOfDocs = Integer.parseInt(tokens[2]);
                    log.debug("Reading header - words: {}, layerSize: {}, totalNumberOfDocs: {}", new Object[]{numWords, layerSize, totalNumberOfDocs});
                    headerRead = true;
                    weightLookupTable = new InMemoryLookupTable.Builder().cache(vocabCache).vectorLength(layerSize).build();
                    continue;
                }
                String label = ReadHelper.decodeB64(tokens[0]);
                int freq = Integer.parseInt(tokens[1]);
                int rows = Integer.parseInt(tokens[2]);
                int cols = Integer.parseInt(tokens[3]);
                if (syn0 == null) {
                    syn0 = Nd4j.createUninitialized((int[])new int[]{rows, cols});
                }
                int i = 4;
                for (int r = 0; r < rows; ++r) {
                    double[] vector = new double[cols];
                    for (int c = 0; c < cols; ++c) {
                        vector[c] = Double.parseDouble(tokens[i]);
                        ++i;
                    }
                    syn0.putRow((long)r, Nd4j.create((double[])vector));
                }
                VocabWord vw = new VocabWord(freq, label);
                vw.setIndex(index);
                weightLookupTable.getVocabCache().addToken(vw);
                weightLookupTable.getVocabCache().addWordToIndex(index, label);
                ++index;
            }
            ((InMemoryLookupTable)weightLookupTable).setSyn0(syn0);
        }
        finally {
            stream.close();
        }
        return weightLookupTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Word2Vec readWord2Vec(@NonNull File file, boolean readExtendedTables) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (InputStream inputStream = WordVectorSerializer.fileStream(file);){
            Word2Vec word2Vec = WordVectorSerializer.readWord2Vec(inputStream, readExtendedTables);
            return word2Vec;
        }
        catch (Exception readSequenceVectors) {
            throw new RuntimeException(readSequenceVectors);
        }
    }

    public static Word2Vec readWord2Vec(@NonNull InputStream stream, boolean readExtendedTable) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        SequenceVectors vectors = WordVectorSerializer.readSequenceVectors(stream, readExtendedTable);
        Word2Vec word2Vec = new Word2Vec.Builder(vectors.getConfiguration()).layerSize(vectors.getLayerSize()).build();
        word2Vec.setVocab(vectors.getVocab());
        word2Vec.setLookupTable(vectors.lookupTable());
        word2Vec.setModelUtils(vectors.getModelUtils());
        return word2Vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWordVectors(@NonNull FastText vectors, @NonNull File path) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(path));
            outputStream.writeObject(vectors);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static FastText readWordVectors(File path) {
        FastText result = null;
        try {
            FileInputStream fileIn = new FileInputStream(path);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            try {
                result = (FastText)in.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void printOutProjectedMemoryUse(long numWords, int vectorLength, int numTables) {
        double value;
        String sfx;
        double memSize = numWords * (long)vectorLength * (long)Nd4j.sizeOfDataType() * (long)numTables;
        if (memSize < 1048576.0) {
            sfx = "KB";
            double d = memSize / 1024.0;
        }
        if (memSize < 1.073741824E9) {
            sfx = "MB";
            value = memSize / 1024.0 / 1024.0;
        } else {
            sfx = "GB";
            value = memSize / 1024.0 / 1024.0 / 1024.0;
        }
        OneTimeLogger.info((Logger)log, (String)"Projected memory use for model: [{} {}]", (Object[])new Object[]{String.format("%.2f", value), sfx});
    }

    public static class ReadHelper {
        private static final String B64 = "B64:";

        private static float readFloat(InputStream is) throws IOException {
            byte[] bytes = new byte[4];
            is.read(bytes);
            return ReadHelper.getFloat(bytes);
        }

        private static float getFloat(byte[] b) {
            int accum = 0;
            accum |= (b[0] & 0xFF) << 0;
            accum |= (b[1] & 0xFF) << 8;
            accum |= (b[2] & 0xFF) << 16;
            return Float.intBitsToFloat(accum |= (b[3] & 0xFF) << 24);
        }

        private static String readString(DataInputStream dis) throws IOException {
            byte[] bytes = new byte[50];
            byte b = dis.readByte();
            int i = -1;
            StringBuilder sb = new StringBuilder();
            while (b != 32 && b != 10) {
                bytes[++i] = b;
                b = dis.readByte();
                if (i != 49) continue;
                sb.append(new String(bytes, "UTF-8"));
                i = -1;
                bytes = new byte[50];
            }
            sb.append(new String(bytes, 0, i + 1, "UTF-8"));
            return sb.toString();
        }

        public static String encodeB64(String word) {
            try {
                return B64 + Base64.encodeBase64String((byte[])word.getBytes("UTF-8")).replaceAll("(\r|\n)", "");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static String decodeB64(String word) {
            if (word.startsWith(B64)) {
                String arp = word.replaceFirst(B64, "");
                try {
                    return new String(Base64.decodeBase64((String)arp), "UTF-8");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return word;
        }
    }

    protected static class CSVReader
    implements Reader {
        private BufferedReader reader;
        private AtomicInteger idxCounter = new AtomicInteger(0);
        private String nextLine;

        protected CSVReader(@NonNull File file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            try {
                this.reader = new BufferedReader(new FileReader(file));
                this.nextLine = this.reader.readLine();
                String[] split = this.nextLine.split(" ");
                try {
                    if (Integer.parseInt(split[0]) > 0 && split.length <= 5) {
                        this.nextLine = this.reader.readLine();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public Pair<VocabWord, float[]> next() {
            String[] split = this.nextLine.split(" ");
            VocabWord word = new VocabWord(1.0, ReadHelper.decodeB64(split[0]));
            word.setIndex(this.idxCounter.getAndIncrement());
            float[] vector = new float[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            try {
                this.nextLine = this.reader.readLine();
            }
            catch (Exception e) {
                this.nextLine = null;
            }
            return Pair.makePair((Object)word, (Object)vector);
        }

        @Override
        public void close() throws Exception {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    protected static class BinaryReader
    implements Reader {
        protected DataInputStream stream;
        protected String nextWord;
        protected int numWords;
        protected int vectorLength;
        protected AtomicInteger idxCounter = new AtomicInteger(0);

        protected BinaryReader(@NonNull File file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            try {
                this.stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            }
            catch (IOException e) {
                try {
                    this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                this.numWords = Integer.parseInt(ReadHelper.readString(this.stream));
                this.vectorLength = Integer.parseInt(ReadHelper.readString(this.stream));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.idxCounter.get() < this.numWords;
        }

        @Override
        public Pair<VocabWord, float[]> next() {
            try {
                String word = ReadHelper.readString(this.stream);
                VocabWord element = new VocabWord(1.0, word);
                element.setIndex(this.idxCounter.getAndIncrement());
                float[] vector = new float[this.vectorLength];
                for (int i = 0; i < this.vectorLength; ++i) {
                    vector[i] = ReadHelper.readFloat(this.stream);
                }
                return Pair.makePair((Object)element, (Object)vector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    protected static interface Reader
    extends AutoCloseable {
        public boolean hasNext();

        public Pair<VocabWord, float[]> next();
    }

    private static class ElementPair {
        private String object;
        private double[] vector;

        protected String toEncodedJson() {
            ObjectMapper mapper = SequenceElement.mapper();
            Base64 base64 = new Base64(Integer.MAX_VALUE);
            try {
                String json = mapper.writeValueAsString((Object)this);
                String output = base64.encodeAsString(json.getBytes("UTF-8"));
                return output;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected static ElementPair fromEncodedJson(String encoded) {
            ObjectMapper mapper = SequenceElement.mapper();
            try {
                String decoded = new String(Base64.decodeBase64((String)encoded), "UTF-8");
                return (ElementPair)mapper.readValue(decoded, ElementPair.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getObject() {
            return this.object;
        }

        public double[] getVector() {
            return this.vector;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public void setVector(double[] vector) {
            this.vector = vector;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementPair)) {
                return false;
            }
            ElementPair other = (ElementPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$object = this.getObject();
            String other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            return Arrays.equals(this.getVector(), other.getVector());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElementPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            result = result * 59 + Arrays.hashCode(this.getVector());
            return result;
        }

        public String toString() {
            return "WordVectorSerializer.ElementPair(object=" + this.getObject() + ", vector=" + Arrays.toString(this.getVector()) + ")";
        }

        public ElementPair() {
        }

        public ElementPair(String object, double[] vector) {
            this.object = object;
            this.vector = vector;
        }
    }
}

