/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.util.List;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;

public class LabelAwareIteratorWrapper
implements LabelAwareIterator {
    private final LabelAwareIterator delegate;
    private final LabelsSource sink;

    public LabelAwareIteratorWrapper(LabelAwareIterator delegate, LabelsSource sink) {
        this.delegate = delegate;
        this.sink = sink;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public boolean hasNextDocument() {
        return this.delegate.hasNextDocument();
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.sink;
    }

    @Override
    public LabelledDocument next() {
        return this.nextDocument();
    }

    @Override
    public LabelledDocument nextDocument() {
        LabelledDocument doc = this.delegate.nextDocument();
        List<String> labels = doc.getLabels();
        if (labels != null) {
            for (String label : labels) {
                this.sink.storeLabel(label);
            }
        }
        return doc;
    }

    @Override
    public void reset() {
        this.delegate.reset();
        this.sink.reset();
    }

    @Override
    public void shutdown() {
    }
}

