/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.LayerVertex;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.serde.BaseNetConfigDeserializer;
import org.deeplearning4j.nn.conf.weightnoise.DropConnect;
import org.nd4j.shade.jackson.core.JsonLocation;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.node.ObjectNode;

public class ComputationGraphConfigurationDeserializer
extends BaseNetConfigDeserializer<ComputationGraphConfiguration> {
    public ComputationGraphConfigurationDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer, ComputationGraphConfiguration.class);
    }

    @Override
    public ComputationGraphConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        long charOffsetStart = jp.getCurrentLocation().getCharOffset();
        ComputationGraphConfiguration conf = (ComputationGraphConfiguration)this.defaultDeserializer.deserialize(jp, ctxt);
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        Map<String, GraphVertex> vertices = conf.getVertices();
        for (Map.Entry<String, GraphVertex> entry : vertices.entrySet()) {
            if (!(entry.getValue() instanceof LayerVertex)) continue;
            LayerVertex lv = (LayerVertex)entry.getValue();
            layerList.add(lv.getLayerConf().getLayer());
        }
        Layer[] layers = layerList.toArray(new Layer[layerList.size()]);
        boolean attemptIUpdaterFromLegacy = this.requiresIUpdaterFromLegacy(layers);
        boolean requireLegacyRegularizationHandling = this.requiresRegularizationFromLegacy(layers);
        boolean requiresLegacyWeightInitHandling = this.requiresWeightInitFromLegacy(layers);
        boolean requiresLegacyActivationHandling = this.requiresActivationFromLegacy(layers);
        boolean requiresLegacyLossHandling = this.requiresLegacyLossHandling(layers);
        Long charOffsetEnd = null;
        JsonLocation endLocation = null;
        String jsonSubString = null;
        if (attemptIUpdaterFromLegacy || requireLegacyRegularizationHandling || requiresLegacyWeightInitHandling) {
            String s;
            endLocation = jp.getCurrentLocation();
            charOffsetEnd = endLocation.getCharOffset();
            Object sourceRef = endLocation.getSourceRef();
            if (sourceRef instanceof StringReader) {
                ((StringReader)sourceRef).reset();
                s = IOUtils.toString((Reader)((StringReader)sourceRef));
            } else {
                s = sourceRef.toString();
            }
            jsonSubString = s.substring((int)charOffsetStart - 1, charOffsetEnd.intValue());
            ObjectMapper om = NeuralNetConfiguration.mapper();
            JsonNode rootNode = om.readTree(jsonSubString);
            ObjectNode verticesNode = (ObjectNode)rootNode.get("vertices");
            Iterator iter = verticesNode.elements();
            int layerIdx = 0;
            while (iter.hasNext()) {
                String cls;
                JsonNode next = (JsonNode)iter.next();
                ObjectNode confNode = null;
                String string = cls = next.has("@class") ? next.get("@class").asText() : null;
                if (next.has("LayerVertex")) {
                    double d;
                    if (!(next = next.get("LayerVertex")).has("layerConf")) continue;
                    confNode = (ObjectNode)next.get("layerConf");
                    next = (JsonNode)confNode.get("layer").elements().next();
                    if (attemptIUpdaterFromLegacy && layers[layerIdx] instanceof BaseLayer && ((BaseLayer)layers[layerIdx]).getIUpdater() == null) {
                        this.handleUpdaterBackwardCompatibility((BaseLayer)layers[layerIdx], (ObjectNode)next);
                    }
                    if (requireLegacyRegularizationHandling && layers[layerIdx] instanceof BaseLayer && ((BaseLayer)layers[layerIdx]).getRegularization() == null) {
                        this.handleL1L2BackwardCompatibility((BaseLayer)layers[layerIdx], (ObjectNode)next);
                    }
                    if (requiresLegacyWeightInitHandling && layers[layerIdx] instanceof BaseLayer && ((BaseLayer)layers[layerIdx]).getWeightInitFn() == null) {
                        this.handleWeightInitBackwardCompatibility((BaseLayer)layers[layerIdx], (ObjectNode)next);
                    }
                    if (requiresLegacyActivationHandling && layers[layerIdx] instanceof BaseLayer && ((BaseLayer)layers[layerIdx]).getActivationFn() == null) {
                        this.handleActivationBackwardCompatibility((BaseLayer)layers[layerIdx], (ObjectNode)next);
                    }
                    if (requiresLegacyLossHandling && layers[layerIdx] instanceof BaseOutputLayer && ((BaseOutputLayer)layers[layerIdx]).getLossFn() == null) {
                        this.handleLossBackwardCompatibility((BaseOutputLayer)layers[layerIdx], (ObjectNode)next);
                    }
                    if (layers[layerIdx].getIDropout() == null && next.has("dropOut") && !Double.isNaN(d = next.get("dropOut").asDouble())) {
                        if (layers[layerIdx] instanceof BaseLayer && confNode.has("useDropConnect") && confNode.get("useDropConnect").asBoolean(false)) {
                            ((BaseLayer)layers[layerIdx]).setWeightNoise(new DropConnect(d));
                        } else {
                            layers[layerIdx].setIDropout(new Dropout(d));
                        }
                    }
                    ++layerIdx;
                    continue;
                }
                if (!"org.deeplearning4j.nn.conf.graph.LayerVertex".equals(cls)) continue;
                if (requiresLegacyWeightInitHandling && layers[layerIdx] instanceof BaseLayer && ((BaseLayer)layers[layerIdx]).getWeightInitFn() == null) {
                    confNode = (ObjectNode)next.get("layerConf");
                    next = confNode.get("layer");
                    this.handleWeightInitBackwardCompatibility((BaseLayer)layers[layerIdx], (ObjectNode)next);
                }
                ++layerIdx;
            }
        }
        for (GraphVertex gv : conf.getVertices().values()) {
            if (!(gv instanceof LayerVertex) || !(((LayerVertex)gv).getLayerConf().getLayer() instanceof BatchNormalization)) continue;
            BatchNormalization bn = (BatchNormalization)((LayerVertex)gv).getLayerConf().getLayer();
            List<String> vars = ((LayerVertex)gv).getLayerConf().getVariables();
            boolean isVariance = vars.contains("var");
            bn.setUseLogStd(!isVariance);
        }
        return conf;
    }
}

