/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.module.flow;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.ui.api.FunctionType;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.flow.data.FlowStaticPersistable;
import org.deeplearning4j.ui.flow.data.FlowUpdatePersistable;
import org.deeplearning4j.ui.views.html.flow.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Json;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;

public class FlowListenerModule
implements UIModule {
    private static final Logger log = LoggerFactory.getLogger(FlowListenerModule.class);
    private static final String TYPE_ID = "FlowListener";
    private Map<String, StatsStorage> knownSessionIDs = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public List<String> getCallbackTypeIDs() {
        return Collections.singletonList(TYPE_ID);
    }

    @Override
    public List<Route> getRoutes() {
        Route r1 = new Route("/flow", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)Flow.apply()));
        Route r2 = new Route("/flow/info/:id", HttpMethod.GET, FunctionType.Function, this::getStaticInfo);
        Route r3 = new Route("/flow/state/:id", HttpMethod.GET, FunctionType.Function, this::getUpdate);
        Route r4 = new Route("/flow/listSessions", HttpMethod.GET, FunctionType.Supplier, this::listSessions);
        return Arrays.asList(r1, r2, r3, r4);
    }

    @Override
    public void reportStorageEvents(Collection<StatsStorageEvent> events) {
        for (StatsStorageEvent sse : events) {
            if (this.knownSessionIDs.containsKey(sse.getSessionID())) continue;
            this.knownSessionIDs.put(sse.getSessionID(), sse.getStatsStorage());
        }
    }

    @Override
    public void onAttach(StatsStorage statsStorage) {
        for (String sessionID : statsStorage.listSessionIDs()) {
            for (String typeID : statsStorage.listTypeIDsForSession(sessionID)) {
                if (!TYPE_ID.equals(typeID)) continue;
                this.knownSessionIDs.put(sessionID, statsStorage);
            }
        }
    }

    @Override
    public void onDetach(StatsStorage statsStorage) {
        for (String s : this.knownSessionIDs.keySet()) {
            if (statsStorage != this.knownSessionIDs.get(s)) continue;
            this.knownSessionIDs.remove(s);
        }
    }

    private Result listSessions() {
        return Results.ok((JsonNode)Json.toJson(this.knownSessionIDs.keySet()));
    }

    private Result getStaticInfo(String sessionID) {
        if (!this.knownSessionIDs.containsKey(sessionID)) {
            return Results.ok((String)"Unknown session ID");
        }
        StatsStorage ss = this.knownSessionIDs.get(sessionID);
        List list = ss.getAllStaticInfos(sessionID, TYPE_ID);
        if (list == null || list.size() == 0) {
            return Results.ok();
        }
        Persistable p = (Persistable)list.get(0);
        if (!(p instanceof FlowStaticPersistable)) {
            return Results.ok();
        }
        FlowStaticPersistable f2 = (FlowStaticPersistable)p;
        return Results.ok((JsonNode)Json.toJson((Object)f2.getModelInfo()));
    }

    private Result getUpdate(String sessionID) {
        if (!this.knownSessionIDs.containsKey(sessionID)) {
            return Results.ok((String)"Unknown session ID");
        }
        StatsStorage ss = this.knownSessionIDs.get(sessionID);
        List list = ss.getLatestUpdateAllWorkers(sessionID, TYPE_ID);
        if (list == null || list.size() == 0) {
            return Results.ok();
        }
        Persistable p = (Persistable)list.get(0);
        if (!(p instanceof FlowUpdatePersistable)) {
            return Results.ok();
        }
        FlowUpdatePersistable f2 = (FlowUpdatePersistable)p;
        return Results.ok((JsonNode)Json.toJson((Object)f2.getModelState()));
    }
}

