/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.play;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.api.UIServer;
import org.deeplearning4j.ui.i18n.I18NProvider;
import org.deeplearning4j.ui.module.convolutional.ConvolutionalListenerModule;
import org.deeplearning4j.ui.module.defaultModule.DefaultModule;
import org.deeplearning4j.ui.module.flow.FlowListenerModule;
import org.deeplearning4j.ui.module.histogram.HistogramModule;
import org.deeplearning4j.ui.module.remote.RemoteReceiverModule;
import org.deeplearning4j.ui.module.train.TrainModule;
import org.deeplearning4j.ui.module.tsne.TsneModule;
import org.deeplearning4j.ui.play.misc.FunctionUtil;
import org.deeplearning4j.ui.play.staticroutes.Assets;
import org.deeplearning4j.ui.play.staticroutes.I18NRoute;
import org.deeplearning4j.ui.storage.InMemoryStatsStorage;
import org.deeplearning4j.ui.storage.impl.QueueStatsStorageListener;
import org.nd4j.linalg.primitives.Pair;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Mode;
import play.api.routing.Router;
import play.mvc.Results;
import play.routing.RoutingDsl;
import play.server.Server;

public class PlayUIServer
extends UIServer {
    private static final Logger log = LoggerFactory.getLogger(PlayUIServer.class);
    public static final String UI_SERVER_PORT_PROPERTY = "org.deeplearning4j.ui.port";
    public static final int DEFAULT_UI_PORT = 9000;
    public static final String UI_CUSTOM_MODULE_PROPERTY = "org.deeplearning4j.ui.custommodule.enable";
    public static final String ASSETS_ROOT_DIRECTORY = "deeplearning4jUiAssets/";
    private Server server;
    private final BlockingQueue<StatsStorageEvent> eventQueue = new LinkedBlockingQueue<StatsStorageEvent>();
    private List<Pair<StatsStorage, StatsStorageListener>> listeners = new CopyOnWriteArrayList<Pair<StatsStorage, StatsStorageListener>>();
    private List<StatsStorage> statsStorageInstances = new CopyOnWriteArrayList<StatsStorage>();
    private List<UIModule> uiModules = new CopyOnWriteArrayList<UIModule>();
    private RemoteReceiverModule remoteReceiverModule;
    private Map<String, List<UIModule>> typeIDModuleMap = new ConcurrentHashMap<String, List<UIModule>>();
    private long uiProcessingDelay = 500L;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Thread uiEventRoutingThread;
    @Parameter(names={"-r", "-enableRemote"}, description="Whether to enable remote or not", arity=1)
    private boolean enableRemote;
    @Parameter(names={"--uiPort"}, description="Whether to enable remote or not", arity=1)
    private int port = 9000;

    public PlayUIServer() {
        this(9000);
    }

    public PlayUIServer(int port) {
        this.port = port;
    }

    public void runMain(String[] args) {
        JCommander jcmdr = new JCommander((Object)this);
        try {
            jcmdr.parse(args);
        }
        catch (ParameterException e) {
            jcmdr.usage();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
        RoutingDsl routingDsl = new RoutingDsl();
        routingDsl.GET("/setlang/:to").routeTo(FunctionUtil.function(new I18NRoute()));
        routingDsl.GET("/lang/getCurrent").routeTo(() -> Results.ok((String)I18NProvider.getInstance().getDefaultLanguage()));
        routingDsl.GET("/assets/*file").routeTo(FunctionUtil.function(new Assets(ASSETS_ROOT_DIRECTORY)));
        this.uiModules.add(new DefaultModule());
        this.uiModules.add(new HistogramModule());
        this.uiModules.add(new TrainModule());
        this.uiModules.add(new ConvolutionalListenerModule());
        this.uiModules.add(new FlowListenerModule());
        this.uiModules.add(new TsneModule());
        this.remoteReceiverModule = new RemoteReceiverModule();
        this.uiModules.add(this.remoteReceiverModule);
        this.uiModules.addAll(this.modulesViaServiceLoader());
        String customModulePropertyStr = System.getProperty(UI_CUSTOM_MODULE_PROPERTY);
        boolean useCustomModules = false;
        if (customModulePropertyStr != null) {
            useCustomModules = Boolean.parseBoolean(customModulePropertyStr);
        }
        if (useCustomModules) {
            ArrayList excludeClasses = new ArrayList();
            for (UIModule u : this.uiModules) {
                excludeClasses.add(u.getClass());
            }
            List<UIModule> list = this.getCustomUIModules(excludeClasses);
            this.uiModules.addAll(list);
        }
        for (UIModule m : this.uiModules) {
            List<Route> routes = m.getRoutes();
            block12: for (Route r : routes) {
                RoutingDsl.PathPatternMatcher ppm = routingDsl.match(r.getHttpMethod().name(), r.getRoute());
                switch (r.getFunctionType()) {
                    case Supplier: {
                        ppm.routeTo(FunctionUtil.function0(r.getSupplier()));
                        continue block12;
                    }
                    case Function: {
                        ppm.routeTo(FunctionUtil.function(r.getFunction()));
                        continue block12;
                    }
                }
                throw new RuntimeException("Not yet implemented");
            }
            List<String> typeIDs = m.getCallbackTypeIDs();
            for (String typeID : typeIDs) {
                List<UIModule> list = this.typeIDModuleMap.get(typeID);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList());
                    this.typeIDModuleMap.put(typeID, list);
                }
                list.add(m);
            }
        }
        String portProperty = System.getProperty(UI_SERVER_PORT_PROPERTY);
        if (portProperty != null) {
            try {
                this.port = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse UI port property \"{}\" with value \"{}\"", new Object[]{UI_SERVER_PORT_PROPERTY, portProperty, e});
            }
        }
        Router router = routingDsl.build();
        this.server = Server.forRouter((Router)router, (Mode)Mode.DEV, (int)this.port);
        this.port = this.port;
        log.info("DL4J UI Server started at {}", (Object)this.getAddress());
        this.uiEventRoutingThread = new Thread(new StatsEventRouterRunnable());
        this.uiEventRoutingThread.setDaemon(true);
        this.uiEventRoutingThread.start();
        if (this.enableRemote) {
            this.enableRemoteListener();
        }
    }

    @Override
    public String getAddress() {
        int last;
        String addr = this.server.mainAddress().toString();
        if (addr.startsWith("/0:0:0:0:0:0:0:0") && (last = addr.lastIndexOf(58)) > 0) {
            addr = "http://localhost:" + addr.substring(last + 1);
        }
        return addr;
    }

    private List<UIModule> modulesViaServiceLoader() {
        ServiceLoader<UIModule> sl = ServiceLoader.load(UIModule.class);
        Iterator<UIModule> iter = sl.iterator();
        if (!iter.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<UIModule> l = new ArrayList<UIModule>();
        while (iter.hasNext()) {
            UIModule m = iter.next();
            log.debug("Loaded UI module via service loader: {}", m.getClass());
            l.add(m);
        }
        return l;
    }

    public static void main(String[] args) {
        new PlayUIServer().runMain(args);
    }

    private List<UIModule> getCustomUIModules(List<Class<?>> excludeClasses) {
        List<String> classNames = Collections.singletonList(UIModule.class.getName());
        Reflections reflections = new Reflections(new Object[0]);
        Store store = reflections.getStore();
        Iterable subtypesByName = store.getAll(SubTypesScanner.class.getSimpleName(), classNames);
        HashSet subtypeClasses = Sets.newHashSet((Iterable)ReflectionUtils.forNames((Iterable)subtypesByName, (ClassLoader[])new ClassLoader[0]));
        ArrayList<Class> toCreate = new ArrayList<Class>();
        for (Class c : subtypeClasses) {
            if (excludeClasses.contains(c)) continue;
            toCreate.add(c);
        }
        ArrayList<UIModule> ret = new ArrayList<UIModule>(toCreate.size());
        for (Class c : toCreate) {
            UIModule m;
            try {
                m = (UIModule)c.newInstance();
            }
            catch (Exception e) {
                log.warn("Could not create instance of custom UIModule of type {}; skipping", (Object)c, (Object)e);
                continue;
            }
            log.debug("Created instance of custom UI module: {}", (Object)c);
            ret.add(m);
        }
        return ret;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public synchronized void attach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        QueueStatsStorageListener listener = new QueueStatsStorageListener(this.eventQueue);
        this.listeners.add((Pair<StatsStorage, StatsStorageListener>)new Pair((Object)statsStorage, (Object)listener));
        statsStorage.registerStatsStorageListener((StatsStorageListener)listener);
        this.statsStorageInstances.add(statsStorage);
        for (UIModule uiModule : this.uiModules) {
            uiModule.onAttach(statsStorage);
        }
        log.info("StatsStorage instance attached to UI: {}", (Object)statsStorage);
    }

    @Override
    public synchronized void detach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (!this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        boolean found = false;
        Iterator<Pair<StatsStorage, StatsStorageListener>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Pair<StatsStorage, StatsStorageListener> p = iterator.next();
            if (p.getFirst() != statsStorage) continue;
            statsStorage.deregisterStatsStorageListener((StatsStorageListener)p.getSecond());
            iterator.remove();
            found = true;
        }
        for (UIModule uiModule : this.uiModules) {
            uiModule.onDetach(statsStorage);
        }
        if (found) {
            log.info("StatsStorage instance detached from UI: {}", (Object)statsStorage);
        }
    }

    @Override
    public boolean isAttached(StatsStorage statsStorage) {
        return this.statsStorageInstances.contains(statsStorage);
    }

    @Override
    public List<StatsStorage> getStatsStorageInstances() {
        return new ArrayList<StatsStorage>(this.statsStorageInstances);
    }

    @Override
    public void enableRemoteListener() {
        if (this.remoteReceiverModule == null) {
            this.remoteReceiverModule = new RemoteReceiverModule();
        }
        if (this.remoteReceiverModule.isEnabled()) {
            return;
        }
        this.enableRemoteListener((StatsStorageRouter)new InMemoryStatsStorage(), true);
    }

    @Override
    public void enableRemoteListener(StatsStorageRouter statsStorage, boolean attach) {
        this.remoteReceiverModule.setEnabled(true);
        this.remoteReceiverModule.setStatsStorage(statsStorage);
        if (attach && statsStorage instanceof StatsStorage) {
            this.attach((StatsStorage)statsStorage);
        }
    }

    @Override
    public void disableRemoteListener() {
        this.remoteReceiverModule.setEnabled(false);
    }

    @Override
    public boolean isRemoteListenerEnabled() {
        return this.remoteReceiverModule.isEnabled();
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public Server getServer() {
        return this.server;
    }

    public BlockingQueue<StatsStorageEvent> getEventQueue() {
        return this.eventQueue;
    }

    public List<Pair<StatsStorage, StatsStorageListener>> getListeners() {
        return this.listeners;
    }

    public List<UIModule> getUiModules() {
        return this.uiModules;
    }

    public RemoteReceiverModule getRemoteReceiverModule() {
        return this.remoteReceiverModule;
    }

    public Map<String, List<UIModule>> getTypeIDModuleMap() {
        return this.typeIDModuleMap;
    }

    public long getUiProcessingDelay() {
        return this.uiProcessingDelay;
    }

    public AtomicBoolean getShutdown() {
        return this.shutdown;
    }

    public Thread getUiEventRoutingThread() {
        return this.uiEventRoutingThread;
    }

    public boolean isEnableRemote() {
        return this.enableRemote;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setListeners(List<Pair<StatsStorage, StatsStorageListener>> listeners) {
        this.listeners = listeners;
    }

    public void setStatsStorageInstances(List<StatsStorage> statsStorageInstances) {
        this.statsStorageInstances = statsStorageInstances;
    }

    public void setUiModules(List<UIModule> uiModules) {
        this.uiModules = uiModules;
    }

    public void setRemoteReceiverModule(RemoteReceiverModule remoteReceiverModule) {
        this.remoteReceiverModule = remoteReceiverModule;
    }

    public void setTypeIDModuleMap(Map<String, List<UIModule>> typeIDModuleMap) {
        this.typeIDModuleMap = typeIDModuleMap;
    }

    public void setUiProcessingDelay(long uiProcessingDelay) {
        this.uiProcessingDelay = uiProcessingDelay;
    }

    public void setUiEventRoutingThread(Thread uiEventRoutingThread) {
        this.uiEventRoutingThread = uiEventRoutingThread;
    }

    public void setEnableRemote(boolean enableRemote) {
        this.enableRemote = enableRemote;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayUIServer)) {
            return false;
        }
        PlayUIServer other = (PlayUIServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Server this$server = this.getServer();
        Server other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        BlockingQueue<StatsStorageEvent> this$eventQueue = this.getEventQueue();
        BlockingQueue<StatsStorageEvent> other$eventQueue = other.getEventQueue();
        if (this$eventQueue == null ? other$eventQueue != null : !this$eventQueue.equals(other$eventQueue)) {
            return false;
        }
        List<Pair<StatsStorage, StatsStorageListener>> this$listeners = this.getListeners();
        List<Pair<StatsStorage, StatsStorageListener>> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<StatsStorage> this$statsStorageInstances = this.getStatsStorageInstances();
        List<StatsStorage> other$statsStorageInstances = other.getStatsStorageInstances();
        if (this$statsStorageInstances == null ? other$statsStorageInstances != null : !((Object)this$statsStorageInstances).equals(other$statsStorageInstances)) {
            return false;
        }
        List<UIModule> this$uiModules = this.getUiModules();
        List<UIModule> other$uiModules = other.getUiModules();
        if (this$uiModules == null ? other$uiModules != null : !((Object)this$uiModules).equals(other$uiModules)) {
            return false;
        }
        RemoteReceiverModule this$remoteReceiverModule = this.getRemoteReceiverModule();
        RemoteReceiverModule other$remoteReceiverModule = other.getRemoteReceiverModule();
        if (this$remoteReceiverModule == null ? other$remoteReceiverModule != null : !this$remoteReceiverModule.equals(other$remoteReceiverModule)) {
            return false;
        }
        Map<String, List<UIModule>> this$typeIDModuleMap = this.getTypeIDModuleMap();
        Map<String, List<UIModule>> other$typeIDModuleMap = other.getTypeIDModuleMap();
        if (this$typeIDModuleMap == null ? other$typeIDModuleMap != null : !((Object)this$typeIDModuleMap).equals(other$typeIDModuleMap)) {
            return false;
        }
        if (this.getUiProcessingDelay() != other.getUiProcessingDelay()) {
            return false;
        }
        AtomicBoolean this$shutdown = this.getShutdown();
        AtomicBoolean other$shutdown = other.getShutdown();
        if (this$shutdown == null ? other$shutdown != null : !this$shutdown.equals(other$shutdown)) {
            return false;
        }
        Thread this$uiEventRoutingThread = this.getUiEventRoutingThread();
        Thread other$uiEventRoutingThread = other.getUiEventRoutingThread();
        if (this$uiEventRoutingThread == null ? other$uiEventRoutingThread != null : !this$uiEventRoutingThread.equals(other$uiEventRoutingThread)) {
            return false;
        }
        if (this.isEnableRemote() != other.isEnableRemote()) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayUIServer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Server $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        BlockingQueue<StatsStorageEvent> $eventQueue = this.getEventQueue();
        result = result * 59 + ($eventQueue == null ? 43 : $eventQueue.hashCode());
        List<Pair<StatsStorage, StatsStorageListener>> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<StatsStorage> $statsStorageInstances = this.getStatsStorageInstances();
        result = result * 59 + ($statsStorageInstances == null ? 43 : ((Object)$statsStorageInstances).hashCode());
        List<UIModule> $uiModules = this.getUiModules();
        result = result * 59 + ($uiModules == null ? 43 : ((Object)$uiModules).hashCode());
        RemoteReceiverModule $remoteReceiverModule = this.getRemoteReceiverModule();
        result = result * 59 + ($remoteReceiverModule == null ? 43 : $remoteReceiverModule.hashCode());
        Map<String, List<UIModule>> $typeIDModuleMap = this.getTypeIDModuleMap();
        result = result * 59 + ($typeIDModuleMap == null ? 43 : ((Object)$typeIDModuleMap).hashCode());
        long $uiProcessingDelay = this.getUiProcessingDelay();
        result = result * 59 + (int)($uiProcessingDelay >>> 32 ^ $uiProcessingDelay);
        AtomicBoolean $shutdown = this.getShutdown();
        result = result * 59 + ($shutdown == null ? 43 : $shutdown.hashCode());
        Thread $uiEventRoutingThread = this.getUiEventRoutingThread();
        result = result * 59 + ($uiEventRoutingThread == null ? 43 : $uiEventRoutingThread.hashCode());
        result = result * 59 + (this.isEnableRemote() ? 79 : 97);
        result = result * 59 + this.getPort();
        return result;
    }

    public String toString() {
        return "PlayUIServer(server=" + this.getServer() + ", eventQueue=" + this.getEventQueue() + ", listeners=" + this.getListeners() + ", statsStorageInstances=" + this.getStatsStorageInstances() + ", uiModules=" + this.getUiModules() + ", remoteReceiverModule=" + this.getRemoteReceiverModule() + ", typeIDModuleMap=" + this.getTypeIDModuleMap() + ", uiProcessingDelay=" + this.getUiProcessingDelay() + ", shutdown=" + this.getShutdown() + ", uiEventRoutingThread=" + this.getUiEventRoutingThread() + ", enableRemote=" + this.isEnableRemote() + ", port=" + this.getPort() + ")";
    }

    private class StatsEventRouterRunnable
    implements Runnable {
        private StatsEventRouterRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runHelper();
            }
            catch (Exception e) {
                log.error("Unexpected exception from Event routing runnable", (Throwable)e);
            }
        }

        private void runHelper() throws Exception {
            log.debug("PlayUIServer.StatsEventRouterRunnable started");
            while (!PlayUIServer.this.shutdown.get()) {
                ArrayList<StatsStorageEvent> events = new ArrayList<StatsStorageEvent>();
                StatsStorageEvent sse = (StatsStorageEvent)PlayUIServer.this.eventQueue.take();
                events.add(sse);
                PlayUIServer.this.eventQueue.drainTo(events);
                for (UIModule m : PlayUIServer.this.uiModules) {
                    List<String> callbackTypes = m.getCallbackTypeIDs();
                    ArrayList<StatsStorageEvent> out = new ArrayList<StatsStorageEvent>();
                    for (StatsStorageEvent e : events) {
                        if (!callbackTypes.contains(e.getTypeID())) continue;
                        out.add(e);
                    }
                    m.reportStorageEvents(out);
                }
                try {
                    Thread.sleep(PlayUIServer.this.uiProcessingDelay);
                }
                catch (InterruptedException e) {
                    if (PlayUIServer.this.shutdown.get()) continue;
                    throw new RuntimeException("Unexpected interrupted exception", e);
                }
            }
        }
    }
}

