/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.parallel;

import akka.actor.ActorSystem;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class Parallelization {
    private static Logger log = LoggerFactory.getLogger(Parallelization.class);

    public static void runInParallel(Collection<Runnable> runnables) {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                executor.submit(r);
            }
        });
        Parallelization.runInParallel(exec, runnables);
    }

    public static void runInParallel(ExecutorService exec, Collection<Runnable> runnables) {
        for (Runnable runnable : runnables) {
            exec.submit(runnable);
        }
        exec.shutdown();
        try {
            exec.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void runInParallel(int numWorkers, Runnable runnable, boolean block) {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                executor.submit(r);
            }
        });
        Parallelization.runInParallel(exec, numWorkers, runnable, block);
    }

    public static void runInParallel(ExecutorService exec, int numWorkers, Runnable runnable, boolean block) {
        for (int i = 0; i < numWorkers; ++i) {
            exec.execute(runnable);
        }
        if (block) {
            exec.shutdown();
            try {
                exec.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void runInParallel(int numWorkers, Runnable runnable) {
        Parallelization.runInParallel(numWorkers, runnable, true);
    }

    public static void runInParallel(ExecutorService exec, int numWorkers, Runnable runnable) {
        Parallelization.runInParallel(exec, numWorkers, runnable, true);
    }

    public static <E> void iterateInParallel(Collection<E> iterate, RunnableWithParams<E> loop, ActorSystem actorSystem) {
        Parallelization.iterateInParallel(iterate, loop, null, actorSystem, null);
    }

    public static <E> void iterateInParallel(Collection<E> iterate, RunnableWithParams<E> loop, ActorSystem actorSystem, Object[] otherArgs) {
        Parallelization.iterateInParallel(iterate, loop, null, actorSystem, otherArgs);
    }

    public static <E> void iterateInParallel(Collection<E> iterate, final RunnableWithParams<E> loop, final RunnableWithParams<E> postDone, ActorSystem actorSystem, final Object[] otherArgs) {
        final CountDownLatch c = new CountDownLatch(iterate.size());
        for (final E e : iterate) {
            Future f = Futures.future((Callable)new Callable<E>(){

                @Override
                public E call() throws Exception {
                    loop.run(e, otherArgs);
                    return e;
                }
            }, (ExecutionContext)actorSystem.dispatcher());
            f.onComplete((Function1)new OnComplete<E>(){

                public void onComplete(Throwable throwable, E e) throws Throwable {
                    if (throwable != null) {
                        log.warn("Error occurred processing data", throwable);
                    }
                    if (postDone != null) {
                        postDone.run(e, otherArgs);
                    }
                    c.countDown();
                }
            }, (ExecutionContext)actorSystem.dispatcher());
        }
        try {
            c.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static interface RunnableWithParams<E> {
        public void run(E var1, Object[] var2);
    }
}

