/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.actor.util;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.cluster.Cluster;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.nn.conf.DeepLearningConfigurable;
import org.deeplearning4j.scaleout.actor.util.PortTaken;
import org.deeplearning4j.scaleout.zookeeper.ZooKeeperConfigurationRegister;
import org.deeplearning4j.scaleout.zookeeper.ZooKeeperRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class ActorRefUtils
implements DeepLearningConfigurable {
    private static Logger log = LoggerFactory.getLogger(ActorRefUtils.class);

    public static void addShutDownForSystem(final ActorSystem system) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Cluster cluster = Cluster.get((ActorSystem)system);
                cluster.leave(cluster.selfAddress());
                system.shutdown();
            }
        }));
    }

    public static void startEmbeddedZooKeeper(ActorSystem system) {
        System.setProperty("jute.maxbuffer", "5048583");
        Future f = Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ZooKeeperRunner runner = new ZooKeeperRunner();
                runner.run();
                return null;
            }
        }, (ExecutionContext)system.dispatcher());
        ActorRefUtils.throwExceptionIfExists(f, (ExecutionContext)system.dispatcher());
    }

    public static void registerConfWithZooKeeper(final Configuration conf, final ActorSystem system) {
        log.info("Stored master path of " + conf.get("org.deeplearning4j.scaleout.masterpath"));
        Future f = Futures.future((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                log.info("Registering with zookeeper; if the logging stops here, ensure zookeeper is started");
                if (!PortTaken.portTaken(2181)) {
                    log.info("No zookeeper found; starting an embedded zookeeper");
                    ActorRefUtils.startEmbeddedZooKeeper(system);
                }
                ZooKeeperConfigurationRegister reg = new ZooKeeperConfigurationRegister(conf, "master", "localhost", 2181);
                reg.register();
                reg.close();
                return null;
            }
        }, (ExecutionContext)system.dispatcher());
        f.onComplete((Function1)new OnComplete<Void>(){

            public void onComplete(Throwable arg0, Void arg1) throws Throwable {
                if (arg0 != null) {
                    throw arg0;
                }
                log.info("Registered conf with zookeeper");
            }
        }, (ExecutionContext)system.dispatcher());
    }

    public static String absPath(ActorRef self, ActorSystem system) {
        String address = Cluster.get((ActorSystem)system).selfAddress().toString();
        ArrayList<Object> path2 = new ArrayList<Object>();
        Iterable elements = self.path().elements();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            path2.add(iter.next());
        }
        String absPath = "/" + StringUtils.join(path2, (String)"/");
        return address + absPath + "/";
    }

    public static <T> void throwExceptionIfExists(Future<T> f, ExecutionContext context) {
        f.onComplete((Function1)new OnComplete<T>(){

            public void onComplete(Throwable arg0, T arg1) throws Throwable {
                if (arg0 != null) {
                    throw arg0;
                }
            }
        }, context);
    }

    public void setup(Configuration conf) {
    }
}

