/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.perform;

import java.io.Serializable;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.scaleout.job.Job;
import org.deeplearning4j.scaleout.perform.WorkerPerformer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;

public class NeuralNetWorkPerformer
implements WorkerPerformer {
    protected Layer neuralNetwork;

    public void perform(Job job) {
        Serializable work = job.getWork();
        if (work instanceof DataSet) {
            DataSet data = (DataSet)work;
            this.neuralNetwork.fit(data.getFeatureMatrix());
        } else if (work instanceof INDArray) {
            this.neuralNetwork.fit((INDArray)work);
        }
        job.setResult((Serializable)this.neuralNetwork.params());
    }

    public void update(Object ... o) {
        INDArray arr = (INDArray)o[0];
        this.neuralNetwork.setParams(arr);
    }

    public void setup(Configuration conf) {
        NeuralNetConfiguration conf2 = NeuralNetConfiguration.fromJson((String)conf.get("org.deeplearning4j.scaleout.neuralnetconf"));
        this.neuralNetwork = conf2.getLayerFactory().create(conf2);
    }
}

