/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.statetracker.workretriever;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.scaleout.api.statetracker.WorkRetriever;
import org.deeplearning4j.scaleout.job.Job;
import org.deeplearning4j.util.SerializationUtils;

public class LocalWorkRetriever
implements WorkRetriever {
    private Map<String, String> workerData = new ConcurrentHashMap<String, String>();
    private IMap<String, Job> distributedData;
    public static final String WORK_RETRIEVER = "workretriever";

    public LocalWorkRetriever() {
    }

    public LocalWorkRetriever(HazelcastInstance instance) {
        this.distributedData = instance.getMap(WORK_RETRIEVER);
        this.distributedData.addEntryListener((EntryListener)new EntryListener<String, Job>(){

            public void entryAdded(EntryEvent<String, Job> event) {
                String worker = (String)event.getKey();
                File f = new File(worker + "-work");
                SerializationUtils.saveObject((Object)event.getValue(), (File)f);
                LocalWorkRetriever.this.workerData.put(worker, f.getAbsolutePath());
                LocalWorkRetriever.this.distributedData.remove((Object)worker);
            }

            public void entryRemoved(EntryEvent<String, Job> event) {
            }

            public void entryUpdated(EntryEvent<String, Job> event) {
            }

            public void entryEvicted(EntryEvent<String, Job> event) {
            }

            public void mapEvicted(MapEvent mapEvent) {
            }

            public void mapCleared(MapEvent mapEvent) {
            }
        }, true);
    }

    public void clear(String worker) {
        this.workerData.remove(worker);
    }

    public Collection<String> workers() {
        return new HashSet<String>(this.workerData.keySet());
    }

    public Job load(String worker) {
        File f;
        File file = f = this.workerData.get(worker) != null ? new File(this.workerData.get(worker)) : null;
        if (f == null || !f.exists()) {
            return null;
        }
        Job d = (Job)SerializationUtils.readObject((File)f);
        this.workerData.remove(f);
        f.delete();
        return d;
    }

    public void save(String worker, Job data) {
        if (this.distributedData != null) {
            this.distributedData.put((Object)worker, (Object)data);
        } else {
            File f = new File(worker + "-work");
            SerializationUtils.saveObject((Object)data, (File)f);
            this.workerData.put(worker, f.getAbsolutePath());
        }
    }
}

