/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.aggregator;

import java.io.Serializable;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.scaleout.aggregator.WorkAccumulator;
import org.deeplearning4j.scaleout.job.Job;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDArrayAggregator
extends WorkAccumulator {
    private INDArray averaged;
    private static final Logger log = LoggerFactory.getLogger(INDArrayAggregator.class);

    public void accumulate(Job toAccumulate) {
        if (toAccumulate.getResult() == null || !(toAccumulate.getResult() instanceof INDArray)) {
            log.warn("Not accumulating result: must be of type INDArray and not null");
            return;
        }
        INDArray arr = (INDArray)toAccumulate.getResult();
        this.seenSoFar += 1.0;
        if (this.averaged == null) {
            this.averaged = arr;
        } else {
            this.averaged.addi(arr);
        }
    }

    public Job aggregate() {
        if (this.averaged == null) {
            return this.empty();
        }
        Job ret = new Job((Serializable)this.averaged.div((Number)this.seenSoFar), "");
        this.seenSoFar = 0.0;
        return ret;
    }

    public void init(Configuration conf) {
    }
}

