/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.statetracker.hazelcast;

import io.dropwizard.Application;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.deeplearning4j.scaleout.api.statetracker.StateTracker;
import org.deeplearning4j.scaleout.statetracker.hazelcast.HazelCastConf;
import org.deeplearning4j.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/statetracker")
@Produces(value={"application/json"})
public class StateTrackerDropWizardResource
extends Application<HazelCastConf>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(StateTrackerDropWizardResource.class);
    private StateTracker stateTracker;
    private Environment env;

    public StateTrackerDropWizardResource(StateTracker stateTracker) {
        this.stateTracker = stateTracker;
    }

    public void initialize(Bootstrap<HazelCastConf> hazelCastConfBootstrap) {
    }

    public void run(HazelCastConf hazelCastConf, Environment environment) throws Exception {
        environment.jersey().register((Object)this);
        this.env = environment;
    }

    @GET
    @Path(value="/minibatch")
    public Response currMiniBatchSize() {
        return Response.ok(Collections.singletonMap("minibatch", this.stateTracker.miniBatchSize())).build();
    }

    @GET
    @Path(value="/numbatchessofar")
    public Response numBatches() {
        return Response.ok(Collections.singletonMap("numbatches", this.stateTracker.numBatchesRan())).build();
    }

    @POST
    @Path(value="/minibatch/{num}")
    public Response setMiniBatchSizeRest(@PathParam(value="num") int num) {
        this.stateTracker.setMiniBatchSize(num);
        return Response.ok(Collections.singletonMap("status", "mini batch to " + num)).build();
    }

    @GET
    @Path(value="/jobs")
    public Response jobs() {
        return Response.ok((Object)this.stateTracker.jobIds()).build();
    }

    @GET
    @Path(value="/phase")
    public Response currentState() {
        return Response.ok(Collections.singletonMap("phase", "finetune")).build();
    }

    @GET
    @Path(value="/workers")
    public Response listWorkers() {
        return Response.ok(new ArrayList(this.stateTracker.workers())).build();
    }

    @GET
    @Path(value="/printmodel")
    public Response printModel() throws Exception {
        return Response.ok(Collections.singletonMap("model", this.stateTracker.getCurrent().toString())).build();
    }

    @GET
    @Path(value="/workers/num")
    public Response listWorkersSize() {
        return Response.ok((Object)new ArrayList(this.stateTracker.workers()).size()).build();
    }

    @GET
    @Path(value="/updates/num")
    public Response listUpdatesSize() {
        return Response.ok((Object)this.stateTracker.workerUpdates().size()).build();
    }

    @GET
    @Path(value="/model.ser")
    @Produces(value={"application/octet-stream"})
    public Response getFile() throws Exception {
        Serializable u = this.stateTracker.getCurrent();
        File file = new File("savedmodel.ser");
        SerializationUtils.saveObject((Object)u, (File)file);
        return Response.ok((Object)file, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).build();
    }

    @PUT
    @Path(value="/save")
    public Response saveModel() {
        log.info("Saving model...");
        try {
            Serializable u = this.stateTracker.getCurrent();
            SerializationUtils.saveObject((Object)u, (File)new File("savedmodel.ser"));
        }
        catch (Exception e) {
            return Response.ok(Collections.singletonMap("status", e.getMessage())).build();
        }
        return Response.ok(Collections.singletonMap("status", "saved")).build();
    }

    public void shutdown() {
        if (this.env != null && this.env.getAdminContext() != null) {
            this.env.getAdminContext().shutdown();
        }
    }
}

