/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.api.workrouter;

import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.scaleout.api.statetracker.IterateAndUpdate;
import org.deeplearning4j.scaleout.api.statetracker.StateTracker;
import org.deeplearning4j.scaleout.api.workrouter.WorkRouter;
import org.deeplearning4j.scaleout.job.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWorkRouter
implements WorkRouter {
    protected StateTracker stateTracker;
    protected boolean waitForWorkers = true;
    protected static Logger log = LoggerFactory.getLogger(WorkRouter.class);

    public BaseWorkRouter() {
    }

    public BaseWorkRouter(StateTracker stateTracker) {
        this.stateTracker = stateTracker;
    }

    @Override
    public void update() {
        Job masterResults = this.compute();
        log.info("Updating next batch");
        try {
            this.stateTracker.setCurrent(masterResults);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String s : this.stateTracker.workers()) {
            log.info("Replicating new work to " + s);
            this.stateTracker.addReplicate(s);
            this.stateTracker.enableWorker(s);
        }
        this.stateTracker.workerUpdates().clear();
    }

    public Job compute() {
        IterateAndUpdate update = this.stateTracker.updates();
        if (this.stateTracker.workerUpdates().isEmpty()) {
            return null;
        }
        try {
            update.accumulate();
        }
        catch (Exception e) {
            log.debug("Unable to accumulate results", (Throwable)e);
            return null;
        }
        Job masterResults = null;
        try {
            masterResults = (Job)this.stateTracker.getCurrent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (masterResults == null) {
            masterResults = update.accumulated();
        }
        try {
            this.stateTracker.setCurrent(masterResults);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return masterResults;
    }

    @Override
    public StateTracker stateTracker() {
        return this.stateTracker;
    }

    public void setup(Configuration conf) {
        if (this.stateTracker == null) {
            try {
                this.stateTracker = this.createStateTracker(conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.waitForWorkers = conf.getBoolean("org.deeplearning4j.scaleout.api.workrouter.wait", true);
    }

    @Override
    public boolean isWaitForWorkers() {
        return this.waitForWorkers;
    }

    @Override
    public void routeJob(Job job) {
        try {
            this.stateTracker.addJobToCurrent(job);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract StateTracker createStateTracker(Configuration var1) throws Exception;
}

