/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.zookeeper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.scaleout.zookeeper.ZookeeperBuilder;
import org.deeplearning4j.scaleout.zookeeper.ZookeeperPathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConfigurationRegister
implements Watcher {
    private Configuration configuration;
    private ZooKeeper zk;
    private String id;
    private String host;
    private int port;
    private static Logger log = LoggerFactory.getLogger(ZooKeeperConfigurationRegister.class);

    public ZooKeeperConfigurationRegister(Configuration configuration, String id, String host, int port) {
        this.configuration = configuration;
        this.id = id;
        this.host = host;
        this.port = port;
        if (this.zk == null) {
            this.zk = new ZookeeperBuilder().setHost(host).setPort(port).build();
        }
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(obj);
        return b.toByteArray();
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        ObjectInputStream o = new ObjectInputStream(b);
        return o.readObject();
    }

    public void register() {
        byte[] data;
        try {
            data = ZooKeeperConfigurationRegister.serialize(this.configuration);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        try {
            this.zk.multi(Arrays.asList(Op.create((String)new ZookeeperPathBuilder().setHost(this.host).setPort(this.port).build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)new ZookeeperPathBuilder().setHost(this.host).setPort(this.port).addPath("tmp").build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
            log.info("Register at " + this.host);
            this.zk.multi(Arrays.asList(Op.create((String)new ZookeeperPathBuilder().setHost("127.0.0.1").setPort(this.port).build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)new ZookeeperPathBuilder().setHost("127.0.0.1").setPort(this.port).addPath("tmp").build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
            log.info("Registered at 127.0.0.1");
            this.zk.multi(Arrays.asList(Op.create((String)new ZookeeperPathBuilder().setHost("localhost").setPort(this.port).build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)new ZookeeperPathBuilder().setHost("localhost").setPort(this.port).addPath("tmp").build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
            String localhost = InetAddress.getLocalHost().getHostName();
            if (!localhost.equals(this.host)) {
                this.zk.multi(Arrays.asList(Op.create((String)new ZookeeperPathBuilder().setHost(localhost).setPort(this.port).build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)new ZookeeperPathBuilder().setHost(localhost).setPort(this.port).addPath("tmp").build(), (byte[])data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
                log.info("Registered at " + localhost);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            log.warn("Already exists..");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (KeeperException e) {
            log.error("Error with node creation", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error("Error with node creation", (Throwable)e);
        }
        try {
            String path = new ZookeeperPathBuilder().setHost(this.host).setPort(this.port).addPaths(Arrays.asList("tmp", this.id)).build();
            Stat stat = this.zk.exists(path, true);
            if (stat != null) {
                log.info("Path found " + path + " ...deleting");
                this.zk.delete(path, -1);
            }
            this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Interrupted registering of zookeeper data for id " + this.id, (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("Error registering zookeeper data ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.zk.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            this.zk = new ZookeeperBuilder().setHost(this.host).setPort(this.port).setWatcher(this).build();
        }
    }
}

