/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.zookeeper;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.scaleout.zookeeper.ZooKeeperConfigurationRegister;
import org.deeplearning4j.scaleout.zookeeper.ZookeeperBuilder;
import org.deeplearning4j.scaleout.zookeeper.ZookeeperPathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfigurationRetriever
implements Watcher {
    private ZooKeeper keeper;
    private String host;
    private int port;
    private String id;
    private static Logger log = LoggerFactory.getLogger(ZookeeperConfigurationRetriever.class);

    public ZookeeperConfigurationRetriever(String host, int port, String id) {
        this.keeper = new ZookeeperBuilder().setHost(host).setPort(port).build();
        this.host = host;
        this.port = port;
        this.id = id;
    }

    public Configuration retrieve(String host) throws Exception {
        String path = new ZookeeperPathBuilder().addPaths(Arrays.asList("tmp", this.id)).setHost(host).setPort(this.port).build();
        Stat stat = this.keeper.exists(path, false);
        if (stat == null) {
            List list = this.keeper.getChildren(new ZookeeperPathBuilder().setHost(host).setPort(this.port).addPath("tmp").build(), false);
            throw new IllegalStateException("Nothing found for " + path + " possible children include " + list);
        }
        byte[] data = this.keeper.getData(path, false, stat);
        Configuration conf = (Configuration)ZooKeeperConfigurationRegister.deserialize(data);
        return conf;
    }

    public Configuration retrieve() throws Exception {
        Configuration c = null;
        String localhost = InetAddress.getLocalHost().getHostName();
        String[] hosts = new String[]{this.host, "127.0.0.1", "localhost", localhost};
        for (int i = 0; i < hosts.length; ++i) {
            try {
                log.info("Attempting to retrieve conf from " + hosts[i]);
                c = this.retrieve(hosts[i]);
                if (c == null) continue;
                log.info("Found from host " + hosts[i]);
                break;
            }
            catch (Exception e) {
                log.warn("Trying next host " + hosts[i] + " failed");
            }
        }
        log.info("Returning conf from host" + this.host);
        return c;
    }

    public void close() {
        try {
            this.keeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            this.keeper = new ZookeeperBuilder().setHost(this.host).setPort(this.port).setWatcher(this).build();
        }
    }
}

