/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.weights;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistogramBin
implements Serializable {
    private transient INDArray sourceArray;
    private int numberOfBins;
    private int rounds;
    private transient INDArray bins;
    private double max;
    private double min;
    private Map<BigDecimal, AtomicInteger> data = new LinkedHashMap<BigDecimal, AtomicInteger>();
    private static final Logger log = LoggerFactory.getLogger(HistogramBin.class);

    public HistogramBin() {
    }

    public HistogramBin(INDArray array) {
    }

    @JsonIgnore
    private synchronized void calcHistogram() {
        int x;
        this.max = this.sourceArray.maxNumber().doubleValue();
        this.min = this.sourceArray.minNumber().doubleValue();
        if (Double.isInfinite(this.max)) {
            this.max = 3.4028234663852886E38;
        }
        if (Double.isNaN(this.max)) {
            this.max = 1.4E-45f;
        }
        if (Double.isInfinite(this.min)) {
            this.min = 3.4028234663852886E38;
        }
        if (Double.isNaN(this.min)) {
            this.min = 1.4E-45f;
        }
        this.bins = Nd4j.create((int)this.numberOfBins);
        double binSize = (this.max - this.min) / (double)(this.numberOfBins - 1);
        this.data = new LinkedHashMap<BigDecimal, AtomicInteger>();
        BigDecimal[] keys = new BigDecimal[this.numberOfBins];
        for (x = 0; x < this.numberOfBins; ++x) {
            BigDecimal pos = new BigDecimal(this.min + (double)x * binSize).setScale(this.rounds, 2);
            this.data.put(pos, new AtomicInteger(0));
            keys[x] = pos;
        }
        for (x = 0; x < this.sourceArray.length(); ++x) {
            double d = this.sourceArray.getDouble(x);
            int bin = (int)((d - this.min) / binSize);
            if (bin < 0) {
                this.bins.putScalar(0, this.bins.getDouble(0) + 1.0);
                this.data.get(keys[0]).incrementAndGet();
                continue;
            }
            if (bin >= this.numberOfBins) {
                this.bins.putScalar(this.numberOfBins - 1, this.bins.getDouble(this.numberOfBins - 1) + 1.0);
                this.data.get(keys[this.numberOfBins - 1]).incrementAndGet();
                continue;
            }
            this.bins.putScalar(bin, this.bins.getDouble(bin) + 1.0);
            this.data.get(keys[bin]).incrementAndGet();
        }
    }

    public INDArray getSourceArray() {
        return this.sourceArray;
    }

    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    public int getRounds() {
        return this.rounds;
    }

    public INDArray getBins() {
        return this.bins;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public Map<BigDecimal, AtomicInteger> getData() {
        return this.data;
    }

    public void setSourceArray(INDArray sourceArray) {
        this.sourceArray = sourceArray;
    }

    public void setNumberOfBins(int numberOfBins) {
        this.numberOfBins = numberOfBins;
    }

    public void setRounds(int rounds) {
        this.rounds = rounds;
    }

    public void setBins(INDArray bins) {
        this.bins = bins;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setData(Map<BigDecimal, AtomicInteger> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistogramBin)) {
            return false;
        }
        HistogramBin other = (HistogramBin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfBins() != other.getNumberOfBins()) {
            return false;
        }
        if (this.getRounds() != other.getRounds()) {
            return false;
        }
        if (Double.compare(this.getMax(), other.getMax()) != 0) {
            return false;
        }
        if (Double.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        Map<BigDecimal, AtomicInteger> this$data = this.getData();
        Map<BigDecimal, AtomicInteger> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistogramBin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberOfBins();
        result = result * 59 + this.getRounds();
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        Map<BigDecimal, AtomicInteger> $data = this.getData();
        result = result * 59 + ($data == null ? 0 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "HistogramBin(sourceArray=" + this.getSourceArray() + ", numberOfBins=" + this.getNumberOfBins() + ", rounds=" + this.getRounds() + ", bins=" + this.getBins() + ", max=" + this.getMax() + ", min=" + this.getMin() + ", data=" + this.getData() + ")";
    }

    public static class Builder {
        private INDArray source;
        private int binCount;
        private int rounds = 2;

        public Builder(INDArray array) {
            this.source = array;
        }

        public Builder setRounding(int rounds) {
            this.rounds = rounds;
            return this;
        }

        public Builder setBinCount(int bins) {
            this.binCount = bins;
            return this;
        }

        public HistogramBin build() {
            HistogramBin histogram = new HistogramBin();
            histogram.sourceArray = this.source;
            histogram.numberOfBins = this.binCount;
            histogram.rounds = this.rounds;
            histogram.calcHistogram();
            return histogram;
        }
    }
}

