/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.common;

import org.apache.spark.api.java.function.VoidFunction;
import org.deeplearning4j.spark.impl.common.SumAccum;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Adder
implements VoidFunction<INDArray> {
    private SumAccum accumulator;
    private static Logger log = LoggerFactory.getLogger(Adder.class);

    public Adder(int length) {
        this.accumulator = new SumAccum(length);
    }

    public void call(INDArray indArrayIterator) throws Exception {
        log.info("Invoking add operation ");
        this.accumulator.add(indArrayIterator);
        log.info("Invoked add operation ");
    }

    public SumAccum getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(SumAccum accumulator) {
        this.accumulator = accumulator;
    }
}

