/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer.gradientaccum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradientAccumFlatMap
implements FlatMapFunction<Iterator<org.nd4j.linalg.dataset.DataSet>, Gradient> {
    private String json;
    private Broadcast<INDArray> params;
    private static Logger log = LoggerFactory.getLogger(GradientAccumFlatMap.class);

    public GradientAccumFlatMap(String json, Broadcast<INDArray> params) {
        this.json = json;
        this.params = params;
    }

    public Iterable<Gradient> call(Iterator<org.nd4j.linalg.dataset.DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.singletonList(new DefaultGradient());
        }
        ArrayList<org.nd4j.linalg.dataset.DataSet> collect = new ArrayList<org.nd4j.linalg.dataset.DataSet>();
        while (dataSetIterator.hasNext()) {
            collect.add(dataSetIterator.next());
        }
        org.nd4j.linalg.dataset.DataSet data = org.nd4j.linalg.dataset.DataSet.merge(collect, (boolean)false);
        log.debug("Training on " + data.labelCounts());
        MultiLayerNetwork network = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)this.json));
        network.init();
        INDArray val = (INDArray)this.params.value();
        if (val.length() != network.numParams()) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcasted set parameters");
        }
        network.setParameters(val);
        network.fit((DataSet)data);
        return Collections.singletonList(network.gradient());
    }
}

