/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.models.embeddings.common;

import java.io.Serializable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class BaseWord2VecFunction
implements Serializable {
    protected int fromIndex = 0;
    protected int toIndex = 0;
    protected String from;
    protected String to;
    public static final String SYN1 = "syn1";
    public static final String SYN0 = "syn0";
    public static final String SYN1_NEGATIVE = "syn1negative";

    public BaseWord2VecFunction(int fromIndex, int toIndex, String from, String to) {
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.from = from;
        this.to = to;
    }

    protected INDArray getFrom(InMemoryLookupTable inMemoryLookupTable) {
        switch (this.from) {
            case "syn0": {
                return inMemoryLookupTable.getSyn0().slice(this.fromIndex).ravel();
            }
            case "syn1": {
                return inMemoryLookupTable.getSyn1().slice(this.fromIndex).ravel();
            }
            case "syn1negative": {
                return inMemoryLookupTable.getSyn1Neg().slice(this.fromIndex).ravel();
            }
        }
        throw new IllegalStateException("Illegal from type " + this.from);
    }

    protected INDArray getTo(InMemoryLookupTable inMemoryLookupTable) {
        switch (this.to) {
            case "syn0": {
                return inMemoryLookupTable.getSyn0().slice(this.toIndex).ravel();
            }
            case "syn1": {
                return inMemoryLookupTable.getSyn1().slice(this.toIndex).ravel();
            }
            case "syn1negative": {
                return inMemoryLookupTable.getSyn1Neg().slice(this.toIndex).ravel();
            }
        }
        throw new IllegalStateException("Illegal to type " + this.to);
    }
}

