/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.models.embeddings.common;

import com.hazelcast.core.IFunction;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.spark.models.embeddings.common.BaseWord2VecFunction;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.factory.Nd4j;

public class SaxpyMap
extends BaseWord2VecFunction
implements IFunction<InMemoryLookupTable, InMemoryLookupTable> {
    private Number alpha;

    public SaxpyMap(Number alpha, int fromIndex, int toIndex, String from, String to) {
        super(fromIndex, toIndex, from, to);
        this.alpha = alpha;
    }

    public InMemoryLookupTable apply(InMemoryLookupTable inMemoryLookupTable) {
        if (inMemoryLookupTable.getSyn0().data().dataType() == DataBuffer.Type.DOUBLE) {
            Nd4j.getBlasWrapper().axpy(this.alpha.doubleValue(), this.getFrom(inMemoryLookupTable), this.getTo(inMemoryLookupTable));
        } else {
            Nd4j.getBlasWrapper().axpy(this.alpha.floatValue(), this.getFrom(inMemoryLookupTable), this.getTo(inMemoryLookupTable));
        }
        return inMemoryLookupTable;
    }
}

