/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.models.embeddings.glove;

import java.io.Serializable;
import org.deeplearning4j.models.glove.GloveWeightLookupTable;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.nd4j.linalg.api.ndarray.INDArray;

public class GloveChange
implements Serializable {
    private VocabWord w1;
    private VocabWord w2;
    private INDArray w1Update;
    private INDArray w2Update;
    private double w1BiasUpdate;
    private double w2BiasUpdate;
    private double error;
    private INDArray w1History;
    private INDArray w2History;
    private double w1BiasHistory;
    private double w2BiasHistory;

    public GloveChange(VocabWord w1, VocabWord w2, INDArray w1Update, INDArray w2Update, double w1BiasUpdate, double w2BiasUpdate, double error, INDArray w1History, INDArray w2History, double w1BiasHistory, double w2BiasHistory) {
        this.w1 = w1;
        this.w2 = w2;
        this.w1Update = w1Update;
        this.w2Update = w2Update;
        this.w1BiasUpdate = w1BiasUpdate;
        this.w2BiasUpdate = w2BiasUpdate;
        this.error = error;
        this.w1History = w1History;
        this.w2History = w2History;
        this.w1BiasHistory = w1BiasHistory;
        this.w2BiasHistory = w2BiasHistory;
    }

    public void apply(GloveWeightLookupTable table) {
        table.getBias().putScalar(this.w1.getIndex(), table.getBias().getDouble(this.w1.getIndex()) - this.w1BiasUpdate);
        table.getBias().putScalar(this.w2.getIndex(), table.getBias().getDouble(this.w2.getIndex()) - this.w2BiasUpdate);
        table.getSyn0().slice(this.w1.getIndex()).subi(this.w1Update);
        table.getSyn0().slice(this.w2.getIndex()).subi(this.w2Update);
        table.getWeightAdaGrad().getHistoricalGradient().slice(this.w1.getIndex()).addi(this.w1History);
        table.getWeightAdaGrad().getHistoricalGradient().slice(this.w2.getIndex()).addi(this.w2History);
        table.getBiasAdaGrad().getHistoricalGradient().putScalar(this.w1.getIndex(), table.getBiasAdaGrad().getHistoricalGradient().getDouble(this.w1.getIndex()) + this.w1BiasHistory);
        table.getBiasAdaGrad().getHistoricalGradient().putScalar(this.w2.getIndex(), table.getBiasAdaGrad().getHistoricalGradient().getDouble(this.w2.getIndex()) + this.w1BiasHistory);
    }

    public INDArray getW1History() {
        return this.w1History;
    }

    public void setW1History(INDArray w1History) {
        this.w1History = w1History;
    }

    public INDArray getW2History() {
        return this.w2History;
    }

    public void setW2History(INDArray w2History) {
        this.w2History = w2History;
    }

    public double getW1BiasHistory() {
        return this.w1BiasHistory;
    }

    public void setW1BiasHistory(double w1BiasHistory) {
        this.w1BiasHistory = w1BiasHistory;
    }

    public double getW2BiasHistory() {
        return this.w2BiasHistory;
    }

    public void setW2BiasHistory(double w2BiasHistory) {
        this.w2BiasHistory = w2BiasHistory;
    }

    public VocabWord getW1() {
        return this.w1;
    }

    public void setW1(VocabWord w1) {
        this.w1 = w1;
    }

    public VocabWord getW2() {
        return this.w2;
    }

    public void setW2(VocabWord w2) {
        this.w2 = w2;
    }

    public INDArray getW1Update() {
        return this.w1Update;
    }

    public void setW1Update(INDArray w1Update) {
        this.w1Update = w1Update;
    }

    public INDArray getW2Update() {
        return this.w2Update;
    }

    public void setW2Update(INDArray w2Update) {
        this.w2Update = w2Update;
    }

    public double getW1BiasUpdate() {
        return this.w1BiasUpdate;
    }

    public void setW1BiasUpdate(double w1BiasUpdate) {
        this.w1BiasUpdate = w1BiasUpdate;
    }

    public double getW2BiasUpdate() {
        return this.w2BiasUpdate;
    }

    public void setW2BiasUpdate(double w2BiasUpdate) {
        this.w2BiasUpdate = w2BiasUpdate;
    }

    public double getError() {
        return this.error;
    }

    public void setError(double error) {
        this.error = error;
    }

    public String toString() {
        return this.w1.getIndex() + "," + this.w2.getIndex() + " error " + this.error;
    }
}

