/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.text.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.function.Function2;
import org.deeplearning4j.berkeley.Counter;

public class FoldWithinPartitionFunction
implements Function2<Integer, Iterator<AtomicLong>, Iterator<AtomicLong>> {
    private Accumulator<Counter<Integer>> maxPerPartitionAcc;

    public FoldWithinPartitionFunction(Accumulator<Counter<Integer>> maxPartitionAcc) {
        this.maxPerPartitionAcc = maxPartitionAcc;
    }

    public Iterator<AtomicLong> call(Integer ind, Iterator<AtomicLong> partition) throws Exception {
        ArrayList<AtomicLong> foldedItemList = new ArrayList<AtomicLong>(){
            {
                this.add(new AtomicLong(0L));
            }
        };
        int foldedItemListSize = 1;
        while (partition.hasNext()) {
            long curPartitionItem = partition.next().get();
            int lastFoldedIndex = foldedItemListSize - 1;
            long lastFoldedItem = ((AtomicLong)foldedItemList.get(lastFoldedIndex)).get();
            AtomicLong sumLastCurrent = new AtomicLong(curPartitionItem + lastFoldedItem);
            foldedItemList.set(lastFoldedIndex, sumLastCurrent);
            foldedItemList.add(sumLastCurrent);
            ++foldedItemListSize;
        }
        long maxFoldedItem = ((AtomicLong)foldedItemList.remove(foldedItemListSize - 1)).get();
        Counter partitionIndex2maxItemCounter = new Counter();
        partitionIndex2maxItemCounter.incrementCount((Object)ind, (double)maxFoldedItem);
        this.maxPerPartitionAcc.add((Object)partitionIndex2maxItemCounter);
        return foldedItemList.iterator();
    }
}

