/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.text.functions;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.function.Function;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizerfactory.NGramTokenizerFactory;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;

public class TokenizerFunction
implements Function<String, List<String>> {
    private String tokenizerFactoryClazz;
    private String tokenizerPreprocessorClazz;
    private transient TokenizerFactory tokenizerFactory;
    private int nGrams = 1;

    public TokenizerFunction(String tokenizer, String tokenizerPreprocessor, int nGrams) {
        this.tokenizerFactoryClazz = tokenizer;
        this.tokenizerPreprocessorClazz = tokenizerPreprocessor;
        this.nGrams = nGrams;
    }

    public List<String> call(String v1) throws Exception {
        if (this.tokenizerFactory == null) {
            this.tokenizerFactory = this.getTokenizerFactory();
        }
        if (v1.isEmpty()) {
            return Arrays.asList("");
        }
        return this.tokenizerFactory.create(v1).getTokens();
    }

    private TokenizerFactory getTokenizerFactory() {
        try {
            Class<?> clazz = Class.forName(this.tokenizerPreprocessorClazz);
            TokenPreProcess tokenPreProcessInst = (TokenPreProcess)clazz.newInstance();
            Class<?> clazz2 = Class.forName(this.tokenizerFactoryClazz);
            this.tokenizerFactory = (TokenizerFactory)clazz2.newInstance();
            this.tokenizerFactory.setTokenPreProcessor(tokenPreProcessInst);
            if (this.nGrams > 1) {
                this.tokenizerFactory = new NGramTokenizerFactory(this.tokenizerFactory, Integer.valueOf(this.nGrams), Integer.valueOf(this.nGrams));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.tokenizerFactory;
    }
}

