/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.text.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;

public class WordsListToVocabWordsFunction
implements Function<Pair<List<String>, AtomicLong>, List<VocabWord>> {
    Broadcast<VocabCache> vocabCacheBroadcast;

    public WordsListToVocabWordsFunction(Broadcast<VocabCache> vocabCacheBroadcast) {
        this.vocabCacheBroadcast = vocabCacheBroadcast;
    }

    public List<VocabWord> call(Pair<List<String>, AtomicLong> pair) throws Exception {
        List wordsList = (List)pair.getFirst();
        ArrayList<VocabWord> vocabWordsList = new ArrayList<VocabWord>();
        for (String s : wordsList) {
            vocabWordsList.add(((VocabCache)this.vocabCacheBroadcast.getValue()).wordFor(s));
        }
        return vocabWordsList;
    }
}

