/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.api.worker;

import java.util.ArrayList;
import java.util.Iterator;
import org.datavec.spark.functions.FlatMapFunctionAdapter;
import org.deeplearning4j.spark.api.TrainingResult;
import org.deeplearning4j.spark.api.TrainingWorker;
import org.deeplearning4j.spark.api.WorkerConfiguration;
import org.deeplearning4j.spark.api.worker.ExecuteWorkerMultiDataSetFlatMapAdapter;
import org.deeplearning4j.spark.iterator.PathSparkMultiDataSetIterator;
import org.nd4j.linalg.dataset.api.MultiDataSet;

class ExecuteWorkerPathMDSFlatMapAdapter<R extends TrainingResult>
implements FlatMapFunctionAdapter<Iterator<String>, R> {
    private final FlatMapFunctionAdapter<Iterator<MultiDataSet>, R> workerFlatMap;
    private final int maxDataSetObjects;

    public ExecuteWorkerPathMDSFlatMapAdapter(TrainingWorker<R> worker) {
        this.workerFlatMap = new ExecuteWorkerMultiDataSetFlatMapAdapter<R>(worker);
        WorkerConfiguration conf = worker.getDataConfiguration();
        int dataSetObjectNumExamples = conf.getDataSetObjectSizeExamples();
        int workerMinibatchSize = conf.getBatchSizePerWorker();
        int maxMinibatches = conf.getMaxBatchesPerWorker() > 0 ? conf.getMaxBatchesPerWorker() : Integer.MAX_VALUE;
        this.maxDataSetObjects = maxMinibatches == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.ceil((double)(maxMinibatches * workerMinibatchSize) / (double)dataSetObjectNumExamples);
    }

    public Iterable<R> call(Iterator<String> iter) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        while (iter.hasNext() && count++ < this.maxDataSetObjects) {
            list.add(iter.next());
        }
        return this.workerFlatMap.call((Object)new PathSparkMultiDataSetIterator(list.iterator()));
    }
}

