/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.api.worker;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NetBroadcastTuple
implements Serializable {
    private final MultiLayerConfiguration configuration;
    private final ComputationGraphConfiguration graphConfiguration;
    private final INDArray parameters;
    private final INDArray updaterState;
    private final AtomicInteger counter;

    public NetBroadcastTuple(MultiLayerConfiguration configuration, INDArray parameters, INDArray updaterState) {
        this(configuration, null, parameters, updaterState);
    }

    public NetBroadcastTuple(ComputationGraphConfiguration graphConfiguration, INDArray parameters, INDArray updaterState) {
        this(null, graphConfiguration, parameters, updaterState);
    }

    public NetBroadcastTuple(MultiLayerConfiguration configuration, ComputationGraphConfiguration graphConfiguration, INDArray parameters, INDArray updaterState) {
        this(configuration, graphConfiguration, parameters, updaterState, new AtomicInteger(0));
    }

    public NetBroadcastTuple(MultiLayerConfiguration configuration, ComputationGraphConfiguration graphConfiguration, INDArray parameters, INDArray updaterState, AtomicInteger counter) {
        this.configuration = configuration;
        this.graphConfiguration = graphConfiguration;
        this.parameters = parameters;
        this.updaterState = updaterState;
        this.counter = counter;
    }

    public MultiLayerConfiguration getConfiguration() {
        return this.configuration;
    }

    public ComputationGraphConfiguration getGraphConfiguration() {
        return this.graphConfiguration;
    }

    public INDArray getParameters() {
        return this.parameters;
    }

    public INDArray getUpdaterState() {
        return this.updaterState;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetBroadcastTuple)) {
            return false;
        }
        NetBroadcastTuple other = (NetBroadcastTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MultiLayerConfiguration this$configuration = this.getConfiguration();
        MultiLayerConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        ComputationGraphConfiguration this$graphConfiguration = this.getGraphConfiguration();
        ComputationGraphConfiguration other$graphConfiguration = other.getGraphConfiguration();
        if (this$graphConfiguration == null ? other$graphConfiguration != null : !this$graphConfiguration.equals(other$graphConfiguration)) {
            return false;
        }
        INDArray this$parameters = this.getParameters();
        INDArray other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) {
            return false;
        }
        INDArray this$updaterState = this.getUpdaterState();
        INDArray other$updaterState = other.getUpdaterState();
        if (this$updaterState == null ? other$updaterState != null : !this$updaterState.equals(other$updaterState)) {
            return false;
        }
        AtomicInteger this$counter = this.getCounter();
        AtomicInteger other$counter = other.getCounter();
        return !(this$counter == null ? other$counter != null : !this$counter.equals(other$counter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NetBroadcastTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MultiLayerConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        ComputationGraphConfiguration $graphConfiguration = this.getGraphConfiguration();
        result = result * 59 + ($graphConfiguration == null ? 43 : $graphConfiguration.hashCode());
        INDArray $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        INDArray $updaterState = this.getUpdaterState();
        result = result * 59 + ($updaterState == null ? 43 : $updaterState.hashCode());
        AtomicInteger $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : $counter.hashCode());
        return result;
    }

    public String toString() {
        return "NetBroadcastTuple(configuration=" + this.getConfiguration() + ", graphConfiguration=" + this.getGraphConfiguration() + ", parameters=" + this.getParameters() + ", updaterState=" + this.getUpdaterState() + ", counter=" + this.getCounter() + ")";
    }
}

