/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.data;

import java.util.ArrayList;
import java.util.Iterator;
import org.datavec.spark.functions.FlatMapFunctionAdapter;
import org.nd4j.linalg.dataset.DataSet;

class BatchDataSetsFunctionAdapter
implements FlatMapFunctionAdapter<Iterator<DataSet>, DataSet> {
    private final int minibatchSize;

    public BatchDataSetsFunctionAdapter(int minibatchSize) {
        this.minibatchSize = minibatchSize;
    }

    public Iterable<DataSet> call(Iterator<DataSet> iter) throws Exception {
        ArrayList<DataSet> out = new ArrayList<DataSet>();
        while (iter.hasNext()) {
            DataSet ds;
            ArrayList<DataSet> list = new ArrayList<DataSet>();
            for (int count = 0; count < this.minibatchSize && iter.hasNext(); count += ds.getFeatureMatrix().size(0)) {
                ds = iter.next();
                list.add(ds);
            }
            DataSet next = list.size() == 0 ? (DataSet)list.get(0) : DataSet.merge(list);
            out.add(next);
        }
        return out;
    }
}

