/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.data;

import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.function.VoidFunction;
import org.deeplearning4j.util.UIDProvider;
import org.nd4j.linalg.dataset.DataSet;

public class DataSetExportFunction
implements VoidFunction<Iterator<DataSet>> {
    private static final Configuration conf = new Configuration();
    private final URI outputDir;
    private String uid = null;
    private int outputCount;

    public DataSetExportFunction(URI outputDir) {
        this.outputDir = outputDir;
    }

    public void call(Iterator<DataSet> iter) throws Exception {
        String jvmuid = UIDProvider.getJVMUID();
        this.uid = Thread.currentThread().getId() + jvmuid.substring(0, Math.min(8, jvmuid.length()));
        while (iter.hasNext()) {
            DataSet next = iter.next();
            String filename = "dataset_" + this.uid + "_" + this.outputCount++ + ".bin";
            String path = this.outputDir.getPath();
            URI uri = new URI(path + (path.endsWith("/") || path.endsWith("\\") ? "" : "/") + filename);
            FileSystem file = FileSystem.get((URI)uri, (Configuration)conf);
            FSDataOutputStream out = file.create(new Path(uri));
            Throwable throwable = null;
            try {
                next.save((OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }
}

