/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.datavec.export;

import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.function.VoidFunction;
import org.datavec.api.io.WritableConverter;
import org.datavec.api.io.converters.SelfWritableConverter;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.impl.collection.CollectionRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.StringSplit;
import org.datavec.api.writable.Writable;
import org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator;
import org.deeplearning4j.util.UIDProvider;
import org.nd4j.linalg.dataset.DataSet;

public class StringToDataSetExportFunction
implements VoidFunction<Iterator<String>> {
    private static final Configuration conf = new Configuration();
    private final URI outputDir;
    private final RecordReader recordReader;
    private final int batchSize;
    private final boolean regression;
    private final int labelIndex;
    private final int numPossibleLabels;
    private String uid = null;
    private int outputCount;

    public StringToDataSetExportFunction(URI outputDir, RecordReader recordReader, int batchSize, boolean regression, int labelIndex, int numPossibleLabels) {
        this.outputDir = outputDir;
        this.recordReader = recordReader;
        this.batchSize = batchSize;
        this.regression = regression;
        this.labelIndex = labelIndex;
        this.numPossibleLabels = numPossibleLabels;
    }

    public void call(Iterator<String> stringIterator) throws Exception {
        String jvmuid = UIDProvider.getJVMUID();
        this.uid = Thread.currentThread().getId() + jvmuid.substring(0, Math.min(8, jvmuid.length()));
        ArrayList<List<Writable>> list = new ArrayList<List<Writable>>(this.batchSize);
        while (stringIterator.hasNext()) {
            String next = stringIterator.next();
            this.recordReader.initialize((InputSplit)new StringSplit(next));
            list.add(this.recordReader.next());
            this.processBatchIfRequired(list, !stringIterator.hasNext());
        }
    }

    private void processBatchIfRequired(List<List<Writable>> list, boolean finalRecord) throws Exception {
        if (list.isEmpty()) {
            return;
        }
        if (list.size() < this.batchSize && !finalRecord) {
            return;
        }
        CollectionRecordReader rr = new CollectionRecordReader(list);
        RecordReaderDataSetIterator iter = new RecordReaderDataSetIterator((RecordReader)rr, (WritableConverter)new SelfWritableConverter(), this.batchSize, this.labelIndex, this.numPossibleLabels, this.regression);
        DataSet ds = iter.next();
        String filename = "dataset_" + this.uid + "_" + this.outputCount++ + ".bin";
        URI uri = new URI(this.outputDir.getPath() + "/" + filename);
        FileSystem file = FileSystem.get((URI)uri, (Configuration)conf);
        try (FSDataOutputStream out = file.create(new Path(uri));){
            ds.save((OutputStream)out);
        }
        list.clear();
    }
}

