/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.earlystopping;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.EarlyStoppingResult;
import org.deeplearning4j.earlystopping.listener.EarlyStoppingListener;
import org.deeplearning4j.earlystopping.scorecalc.ScoreCalculator;
import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;
import org.deeplearning4j.earlystopping.trainer.IEarlyStoppingTrainer;
import org.deeplearning4j.nn.api.Model;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSparkEarlyStoppingTrainer<T extends Model>
implements IEarlyStoppingTrainer<T> {
    private static Logger log = LoggerFactory.getLogger(BaseSparkEarlyStoppingTrainer.class);
    private JavaSparkContext sc;
    private final EarlyStoppingConfiguration<T> esConfig;
    private T net;
    private final JavaRDD<DataSet> train;
    private final JavaRDD<MultiDataSet> trainMulti;
    private EarlyStoppingListener<T> listener;
    private double bestModelScore = Double.MAX_VALUE;
    private int bestModelEpoch = -1;

    protected BaseSparkEarlyStoppingTrainer(JavaSparkContext sc, EarlyStoppingConfiguration<T> esConfig, T net, JavaRDD<DataSet> train, JavaRDD<MultiDataSet> trainMulti, EarlyStoppingListener<T> listener) {
        if (!(esConfig.getEpochTerminationConditions() != null && esConfig.getEpochTerminationConditions().size() != 0 || esConfig.getIterationTerminationConditions() != null && esConfig.getIterationTerminationConditions().size() != 0)) {
            throw new IllegalArgumentException("Cannot conduct early stopping without a termination condition (both Iteration and Epoch termination conditions are null/empty)");
        }
        this.sc = sc;
        this.esConfig = esConfig;
        this.net = net;
        this.train = train;
        this.trainMulti = trainMulti;
        this.listener = listener;
    }

    protected abstract void fit(JavaRDD<DataSet> var1);

    protected abstract void fitMulti(JavaRDD<MultiDataSet> var1);

    protected abstract double getScore();

    public EarlyStoppingResult<T> fit() {
        log.info("Starting early stopping training");
        if (this.esConfig.getScoreCalculator() == null) {
            log.warn("No score calculator provided for early stopping. Score will be reported as 0.0 to epoch termination conditions");
        }
        if (this.esConfig.getIterationTerminationConditions() != null) {
            for (IterationTerminationCondition c : this.esConfig.getIterationTerminationConditions()) {
                c.initialize();
            }
        }
        if (this.esConfig.getEpochTerminationConditions() != null) {
            for (IterationTerminationCondition c : this.esConfig.getEpochTerminationConditions()) {
                c.initialize();
            }
        }
        if (this.listener != null) {
            this.listener.onStart(this.esConfig, this.net);
        }
        LinkedHashMap<Integer, Double> scoreVsEpoch = new LinkedHashMap<Integer, Double>();
        int epochCount = 0;
        while (true) {
            boolean terminate = false;
            IterationTerminationCondition terminationReason = null;
            if (this.train != null) {
                this.fit(this.train);
            } else {
                this.fitMulti(this.trainMulti);
            }
            double lastScore = this.getScore();
            for (IterationTerminationCondition c : this.esConfig.getIterationTerminationConditions()) {
                if (!c.terminate(lastScore)) continue;
                terminate = true;
                terminationReason = c;
                break;
            }
            if (terminate) {
                Model bestModel;
                log.info("Hit per iteration epoch termination condition at epoch {}, iteration {}. Reason: {}", new Object[]{epochCount, epochCount, terminationReason});
                if (this.esConfig.isSaveLastModel()) {
                    try {
                        this.esConfig.getModelSaver().saveLatestModel(this.net, 0.0);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error saving most recent model", e);
                    }
                }
                try {
                    bestModel = this.esConfig.getModelSaver().getBestModel();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                EarlyStoppingResult result = new EarlyStoppingResult(EarlyStoppingResult.TerminationReason.IterationTerminationCondition, terminationReason.toString(), scoreVsEpoch, this.bestModelEpoch, this.bestModelScore, epochCount, bestModel);
                if (this.listener != null) {
                    this.listener.onCompletion(result);
                }
                return result;
            }
            log.info("Completed training epoch {}", (Object)epochCount);
            if ((epochCount != 0 || this.esConfig.getEvaluateEveryNEpochs() != 1) && epochCount % this.esConfig.getEvaluateEveryNEpochs() != 0) continue;
            ScoreCalculator sc = this.esConfig.getScoreCalculator();
            double score = sc == null ? 0.0 : this.esConfig.getScoreCalculator().calculateScore(this.net);
            scoreVsEpoch.put(epochCount - 1, score);
            if (sc != null && score < this.bestModelScore) {
                if (this.bestModelEpoch == -1) {
                    log.info("Score at epoch {}: {}", (Object)epochCount, (Object)score);
                } else {
                    log.info("New best model: score = {}, epoch = {} (previous: score = {}, epoch = {})", new Object[]{score, epochCount, this.bestModelScore, this.bestModelEpoch});
                }
                this.bestModelScore = score;
                this.bestModelEpoch = epochCount;
                try {
                    this.esConfig.getModelSaver().saveBestModel(this.net, score);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error saving best model", e);
                }
            }
            if (this.esConfig.isSaveLastModel()) {
                try {
                    this.esConfig.getModelSaver().saveLatestModel(this.net, score);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error saving most recent model", e);
                }
            }
            if (this.listener != null) {
                this.listener.onEpoch(epochCount, score, this.esConfig, this.net);
            }
            boolean epochTerminate = false;
            Object termReason = null;
            for (EpochTerminationCondition c : this.esConfig.getEpochTerminationConditions()) {
                if (!c.terminate(epochCount, score)) continue;
                epochTerminate = true;
                termReason = c;
                break;
            }
            if (epochTerminate) {
                Model bestModel;
                log.info("Hit epoch termination condition at epoch {}. Details: {}", (Object)epochCount, (Object)termReason.toString());
                try {
                    bestModel = this.esConfig.getModelSaver().getBestModel();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                EarlyStoppingResult result = new EarlyStoppingResult(EarlyStoppingResult.TerminationReason.EpochTerminationCondition, termReason.toString(), scoreVsEpoch, this.bestModelEpoch, this.bestModelScore, epochCount + 1, bestModel);
                if (this.listener != null) {
                    this.listener.onCompletion(result);
                }
                return result;
            }
            ++epochCount;
        }
    }

    public void setListener(EarlyStoppingListener<T> listener) {
        this.listener = listener;
    }
}

