/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.api.storage.listener.RoutingIterationListener;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.spark.api.TrainingMaster;
import org.deeplearning4j.spark.impl.listeners.VanillaStatsStorageRouterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkListenable {
    private static final Logger log = LoggerFactory.getLogger(SparkListenable.class);
    protected TrainingMaster trainingMaster;
    private List<IterationListener> listeners = new ArrayList<IterationListener>();

    public void setListeners(@NonNull Collection<IterationListener> listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        this.listeners.clear();
        this.listeners.addAll(listeners);
        if (this.trainingMaster != null) {
            this.trainingMaster.setListeners(this.listeners);
        }
    }

    public void setListeners(IterationListener ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        this.setListeners(Arrays.asList(listeners));
    }

    public void setListeners(StatsStorageRouter statsStorage, IterationListener ... listeners) {
        this.setListeners(statsStorage, Arrays.asList(listeners));
    }

    public void setListeners(StatsStorageRouter statsStorage, Collection<? extends IterationListener> listeners) {
        VanillaStatsStorageRouterProvider routerProvider = null;
        if (listeners != null) {
            for (IterationListener iterationListener : listeners) {
                if (!(iterationListener instanceof RoutingIterationListener)) continue;
                RoutingIterationListener rl = (RoutingIterationListener)iterationListener;
                if (statsStorage == null && rl.getStorageRouter() == null) {
                    log.warn("RoutingIterationListener provided without providing any StatsStorage instance. Iterator may not function without one. Listener: {}", (Object)iterationListener);
                } else if (rl.getStorageRouter() != null && !(rl.getStorageRouter() instanceof Serializable)) {
                    throw new IllegalStateException("RoutingIterationListener provided with non-serializable storage router \nRoutingIterationListener class: " + rl.getClass().getName() + "\nStatsStorageRouter class: " + rl.getStorageRouter().getClass().getName());
                }
                if (routerProvider != null) continue;
                routerProvider = new VanillaStatsStorageRouterProvider();
            }
        }
        this.listeners.clear();
        if (listeners != null) {
            this.listeners.addAll(listeners);
            if (this.trainingMaster != null) {
                this.trainingMaster.setListeners(statsStorage, this.listeners);
            }
        }
    }
}

