/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.common;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.spark.api.java.function.Function2;

public class SplitPartitionsFunction<T>
implements Function2<Integer, Iterator<T>, Iterator<T>> {
    private final int splitIndex;
    private final int numSplits;
    private final long baseRngSeed;

    public Iterator<T> call(Integer v1, Iterator<T> iter) throws Exception {
        long thisRngSeed = this.baseRngSeed + (long)v1.intValue();
        Random r = new Random(thisRngSeed);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.numSplits; ++i) {
            list.add(i);
        }
        ArrayList<T> outputList = new ArrayList<T>();
        int i = 0;
        while (iter.hasNext()) {
            if (i % this.numSplits == 0) {
                Collections.shuffle(list, r);
            }
            T next = iter.next();
            if ((Integer)list.get(i % this.numSplits) == this.splitIndex) {
                outputList.add(next);
            }
            ++i;
        }
        return outputList.iterator();
    }

    @ConstructorProperties(value={"splitIndex", "numSplits", "baseRngSeed"})
    public SplitPartitionsFunction(int splitIndex, int numSplits, long baseRngSeed) {
        this.splitIndex = splitIndex;
        this.numSplits = numSplits;
        this.baseRngSeed = baseRngSeed;
    }
}

