/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.graph.evaluation;

import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.functions.FlatMapFunctionAdapter;
import org.deeplearning4j.datasets.iterator.IteratorMultiDataSetIterator;
import org.deeplearning4j.eval.IEvaluation;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.spark.iterator.SparkAMDSI;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IEvaluateMDSFlatMapFunctionAdapter<T extends IEvaluation>
implements FlatMapFunctionAdapter<Iterator<MultiDataSet>, T[]> {
    private static final Logger log = LoggerFactory.getLogger(IEvaluateMDSFlatMapFunctionAdapter.class);
    protected Broadcast<String> json;
    protected Broadcast<INDArray> params;
    protected int evalBatchSize;
    protected T[] evaluations;

    public IEvaluateMDSFlatMapFunctionAdapter(Broadcast<String> json, Broadcast<INDArray> params, int evalBatchSize, T[] evaluations) {
        this.json = json;
        this.params = params;
        this.evalBatchSize = evalBatchSize;
        this.evaluations = evaluations;
    }

    public Iterable<T[]> call(Iterator<MultiDataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyList();
        }
        INDArray val = ((INDArray)this.params.value()).unsafeDuplication();
        ComputationGraph graph = new ComputationGraph(ComputationGraphConfiguration.fromJson((String)((String)this.json.getValue())));
        graph.init();
        if (val.length() != graph.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcast set parameters");
        }
        graph.setParams(val);
        IEvaluation[] eval = graph.doEvaluation((MultiDataSetIterator)new SparkAMDSI((MultiDataSetIterator)new IteratorMultiDataSetIterator(dataSetIterator, this.evalBatchSize), 2, true), this.evaluations);
        return Collections.singletonList(eval);
    }
}

