/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer;

import java.io.IOException;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.DoubleFlatMapFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.eval.IEvaluation;
import org.deeplearning4j.eval.ROC;
import org.deeplearning4j.eval.ROCMultiClass;
import org.deeplearning4j.eval.RegressionEvaluation;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.spark.api.TrainingMaster;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.deeplearning4j.spark.impl.SparkListenable;
import org.deeplearning4j.spark.impl.common.reduce.IntDoubleReduceFunction;
import org.deeplearning4j.spark.impl.multilayer.evaluation.IEvaluateAggregateFunction;
import org.deeplearning4j.spark.impl.multilayer.evaluation.IEvaluateFlatMapFunction;
import org.deeplearning4j.spark.impl.multilayer.evaluation.IEvaluationReduceFunction;
import org.deeplearning4j.spark.impl.multilayer.scoring.FeedForwardWithKeyFunction;
import org.deeplearning4j.spark.impl.multilayer.scoring.ScoreExamplesFunction;
import org.deeplearning4j.spark.impl.multilayer.scoring.ScoreExamplesWithKeyFunction;
import org.deeplearning4j.spark.impl.multilayer.scoring.ScoreFlatMapFunction;
import org.deeplearning4j.spark.util.MLLibUtil;
import org.deeplearning4j.spark.util.SparkUtils;
import org.deeplearning4j.util.ModelSerializer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.heartbeat.Heartbeat;
import org.nd4j.linalg.heartbeat.reports.Environment;
import org.nd4j.linalg.heartbeat.reports.Event;
import org.nd4j.linalg.heartbeat.reports.Task;
import org.nd4j.linalg.heartbeat.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkDl4jMultiLayer
extends SparkListenable {
    private static final Logger log = LoggerFactory.getLogger(SparkDl4jMultiLayer.class);
    public static final int DEFAULT_EVAL_SCORE_BATCH_SIZE = 64;
    public static final int DEFAULT_ROC_THRESHOLD_STEPS = 32;
    private transient JavaSparkContext sc;
    private MultiLayerConfiguration conf;
    private MultiLayerNetwork network;
    private double lastScore;

    public SparkDl4jMultiLayer(SparkContext sparkContext, MultiLayerNetwork network, TrainingMaster<?, ?> trainingMaster) {
        this(new JavaSparkContext(sparkContext), network, trainingMaster);
    }

    public SparkDl4jMultiLayer(SparkContext sparkContext, MultiLayerConfiguration conf, TrainingMaster<?, ?> trainingMaster) {
        this(new JavaSparkContext(sparkContext), SparkDl4jMultiLayer.initNetwork(conf), trainingMaster);
    }

    public SparkDl4jMultiLayer(JavaSparkContext sc, MultiLayerConfiguration conf, TrainingMaster<?, ?> trainingMaster) {
        this(sc.sc(), conf, trainingMaster);
    }

    public SparkDl4jMultiLayer(JavaSparkContext javaSparkContext, MultiLayerNetwork network, TrainingMaster<?, ?> trainingMaster) {
        this.sc = javaSparkContext;
        this.conf = network.getLayerWiseConfigurations().clone();
        this.network = network;
        if (!network.isInitCalled()) {
            network.init();
        }
        this.trainingMaster = trainingMaster;
        SparkUtils.checkKryoConfiguration(javaSparkContext, log);
    }

    private static MultiLayerNetwork initNetwork(MultiLayerConfiguration conf) {
        MultiLayerNetwork net = new MultiLayerNetwork(conf);
        net.init();
        return net;
    }

    public JavaSparkContext getSparkContext() {
        return this.sc;
    }

    public MultiLayerNetwork getNetwork() {
        return this.network;
    }

    public TrainingMaster getTrainingMaster() {
        return this.trainingMaster;
    }

    public void setNetwork(MultiLayerNetwork network) {
        this.network = network;
    }

    public void setCollectTrainingStats(boolean collectTrainingStats) {
        this.trainingMaster.setCollectTrainingStats(collectTrainingStats);
    }

    public SparkTrainingStats getSparkTrainingStats() {
        return this.trainingMaster.getTrainingStats();
    }

    public Matrix predict(Matrix features) {
        return MLLibUtil.toMatrix(this.network.output(MLLibUtil.toMatrix(features)));
    }

    public Vector predict(Vector point) {
        return MLLibUtil.toVector(this.network.output(MLLibUtil.toVector(point)));
    }

    public MultiLayerNetwork fit(RDD<DataSet> trainingData) {
        return this.fit((JavaRDD<DataSet>)trainingData.toJavaRDD());
    }

    public MultiLayerNetwork fit(JavaRDD<DataSet> trainingData) {
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        this.trainingMaster.executeTraining(this, trainingData);
        return this.network;
    }

    public MultiLayerNetwork fit(String path) {
        JavaRDD<String> paths;
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        try {
            paths = SparkUtils.listPaths(this.sc, path);
        }
        catch (IOException e) {
            throw new RuntimeException("Error listing paths in directory", e);
        }
        return this.fitPaths(paths);
    }

    @Deprecated
    public MultiLayerNetwork fit(String path, int minPartitions) {
        return this.fit(path);
    }

    public MultiLayerNetwork fitPaths(JavaRDD<String> paths) {
        this.trainingMaster.executeTrainingPaths(this, paths);
        return this.network;
    }

    public MultiLayerNetwork fitLabeledPoint(JavaRDD<LabeledPoint> rdd) {
        int nLayers = this.network.getLayerWiseConfigurations().getConfs().size();
        FeedForwardLayer ffl = (FeedForwardLayer)this.network.getLayerWiseConfigurations().getConf(nLayers - 1).getLayer();
        JavaRDD<DataSet> ds = MLLibUtil.fromLabeledPoint(this.sc, rdd, ffl.getNOut());
        return this.fit(ds);
    }

    public MultiLayerNetwork fitContinuousLabeledPoint(JavaRDD<LabeledPoint> rdd) {
        return this.fit(MLLibUtil.fromContinuousLabeledPoint(this.sc, rdd));
    }

    public double getScore() {
        return this.lastScore;
    }

    public void setScore(double lastScore) {
        this.lastScore = lastScore;
    }

    public double calculateScore(RDD<DataSet> data, boolean average) {
        return this.calculateScore((JavaRDD<DataSet>)data.toJavaRDD(), average);
    }

    public double calculateScore(JavaRDD<DataSet> data, boolean average) {
        return this.calculateScore(data, average, 64);
    }

    public double calculateScore(JavaRDD<DataSet> data, boolean average, int minibatchSize) {
        JavaRDD rdd = data.mapPartitions((FlatMapFunction)new ScoreFlatMapFunction(this.conf.toJson(), (Broadcast<INDArray>)this.sc.broadcast((Object)this.network.params(false)), minibatchSize));
        Tuple2 countAndSumScores = (Tuple2)rdd.reduce((Function2)new IntDoubleReduceFunction());
        if (average) {
            return (Double)countAndSumScores._2() / (double)((Integer)countAndSumScores._1()).intValue();
        }
        return (Double)countAndSumScores._2();
    }

    public JavaDoubleRDD scoreExamples(RDD<DataSet> data, boolean includeRegularizationTerms) {
        return this.scoreExamples((JavaRDD<DataSet>)data.toJavaRDD(), includeRegularizationTerms);
    }

    public JavaDoubleRDD scoreExamples(JavaRDD<DataSet> data, boolean includeRegularizationTerms) {
        return this.scoreExamples(data, includeRegularizationTerms, 64);
    }

    public JavaDoubleRDD scoreExamples(RDD<DataSet> data, boolean includeRegularizationTerms, int batchSize) {
        return this.scoreExamples((JavaRDD<DataSet>)data.toJavaRDD(), includeRegularizationTerms, batchSize);
    }

    public JavaDoubleRDD scoreExamples(JavaRDD<DataSet> data, boolean includeRegularizationTerms, int batchSize) {
        return data.mapPartitionsToDouble((DoubleFlatMapFunction)new ScoreExamplesFunction((Broadcast<INDArray>)this.sc.broadcast((Object)this.network.params()), (Broadcast<String>)this.sc.broadcast((Object)this.conf.toJson()), includeRegularizationTerms, batchSize));
    }

    public <K> JavaPairRDD<K, Double> scoreExamples(JavaPairRDD<K, DataSet> data, boolean includeRegularizationTerms) {
        return this.scoreExamples(data, includeRegularizationTerms, 64);
    }

    public <K> JavaPairRDD<K, Double> scoreExamples(JavaPairRDD<K, DataSet> data, boolean includeRegularizationTerms, int batchSize) {
        return data.mapPartitionsToPair(new ScoreExamplesWithKeyFunction((Broadcast<INDArray>)this.sc.broadcast((Object)this.network.params()), (Broadcast<String>)this.sc.broadcast((Object)this.conf.toJson()), includeRegularizationTerms, batchSize));
    }

    public <K> JavaPairRDD<K, INDArray> feedForwardWithKey(JavaPairRDD<K, INDArray> featuresData, int batchSize) {
        return featuresData.mapPartitionsToPair(new FeedForwardWithKeyFunction((Broadcast<INDArray>)this.sc.broadcast((Object)this.network.params()), (Broadcast<String>)this.sc.broadcast((Object)this.conf.toJson()), batchSize));
    }

    public Evaluation evaluate(RDD<DataSet> data) {
        return this.evaluate((JavaRDD<DataSet>)data.toJavaRDD());
    }

    public Evaluation evaluate(JavaRDD<DataSet> data) {
        return this.evaluate(data, null);
    }

    public Evaluation evaluate(RDD<DataSet> data, List<String> labelsList) {
        return this.evaluate((JavaRDD<DataSet>)data.toJavaRDD(), labelsList);
    }

    public RegressionEvaluation evaluateRegression(JavaRDD<DataSet> data) {
        return this.evaluateRegression(data, 64);
    }

    public RegressionEvaluation evaluateRegression(JavaRDD<DataSet> data, int minibatchSize) {
        int nOut = ((FeedForwardLayer)this.network.getOutputLayer().conf().getLayer()).getNOut();
        return this.doEvaluation(data, new RegressionEvaluation(nOut), minibatchSize);
    }

    public Evaluation evaluate(JavaRDD<DataSet> data, List<String> labelsList) {
        return this.evaluate(data, labelsList, 64);
    }

    public ROC evaluateROC(JavaRDD<DataSet> data) {
        return this.evaluateROC(data, 32, 64);
    }

    public ROC evaluateROC(JavaRDD<DataSet> data, int thresholdSteps, int evaluationMinibatchSize) {
        return this.doEvaluation(data, new ROC(thresholdSteps), evaluationMinibatchSize);
    }

    public ROCMultiClass evaluateROCMultiClass(JavaRDD<DataSet> data) {
        return this.evaluateROCMultiClass(data, 32, 64);
    }

    public ROCMultiClass evaluateROCMultiClass(JavaRDD<DataSet> data, int thresholdSteps, int evaluationMinibatchSize) {
        return this.doEvaluation(data, new ROCMultiClass(thresholdSteps), evaluationMinibatchSize);
    }

    private void update(int mr, long mg) {
        Environment env = EnvironmentUtils.buildEnvironment();
        env.setNumCores(mr);
        env.setAvailableMemory(mg);
        Task task = ModelSerializer.taskByModel((Model)this.network);
        Heartbeat.getInstance().reportEvent(Event.SPARK, env, task);
    }

    public Evaluation evaluate(JavaRDD<DataSet> data, List<String> labelsList, int evalBatchSize) {
        Evaluation e = new Evaluation();
        e = this.doEvaluation(data, e, evalBatchSize);
        if (labelsList != null) {
            e.setLabelsList(labelsList);
        }
        return e;
    }

    public <T extends IEvaluation> T doEvaluation(JavaRDD<DataSet> data, T emptyEvaluation, int evalBatchSize) {
        return (T)this.doEvaluation(data, evalBatchSize, new IEvaluation[]{emptyEvaluation})[0];
    }

    public <T extends IEvaluation> T[] doEvaluation(JavaRDD<DataSet> data, int evalBatchSize, T ... emptyEvaluations) {
        IEvaluateFlatMapFunction evalFn = new IEvaluateFlatMapFunction(false, this.sc.broadcast((Object)this.conf.toJson()), this.sc.broadcast((Object)this.network.params()), evalBatchSize, emptyEvaluations);
        JavaRDD evaluations = data.mapPartitions((FlatMapFunction)evalFn);
        return (IEvaluation[])evaluations.treeAggregate(null, new IEvaluateAggregateFunction(), new IEvaluationReduceFunction());
    }
}

