/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer.evaluation;

import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.functions.FlatMapFunctionAdapter;
import org.deeplearning4j.datasets.iterator.IteratorDataSetIterator;
import org.deeplearning4j.eval.IEvaluation;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.spark.iterator.SparkADSI;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IEvaluateFlatMapFunctionAdapter<T extends IEvaluation>
implements FlatMapFunctionAdapter<Iterator<DataSet>, T[]> {
    private static final Logger log = LoggerFactory.getLogger(IEvaluateFlatMapFunctionAdapter.class);
    protected boolean isCompGraph;
    protected Broadcast<String> json;
    protected Broadcast<INDArray> params;
    protected int evalBatchSize;
    protected T[] evaluations;

    public IEvaluateFlatMapFunctionAdapter(boolean isCompGraph, Broadcast<String> json, Broadcast<INDArray> params, int evalBatchSize, T[] evaluations) {
        this.isCompGraph = isCompGraph;
        this.json = json;
        this.params = params;
        this.evalBatchSize = evalBatchSize;
        this.evaluations = evaluations;
    }

    public Iterable<T[]> call(Iterator<DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyList();
        }
        MultiLayerNetwork network = null;
        ComputationGraph graph = null;
        INDArray val = ((INDArray)this.params.value()).unsafeDuplication();
        if (this.isCompGraph) {
            graph = new ComputationGraph(ComputationGraphConfiguration.fromJson((String)((String)this.json.getValue())));
            graph.init();
            if (val.length() != graph.numParams(false)) {
                throw new IllegalStateException("Network did not have same number of parameters as the broadcast set parameters");
            }
            graph.setParams(val);
            IEvaluation[] eval = graph.doEvaluation((DataSetIterator)new SparkADSI((DataSetIterator)new IteratorDataSetIterator(dataSetIterator, this.evalBatchSize), 2, true), this.evaluations);
            return Collections.singletonList(eval);
        }
        network = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)((String)this.json.getValue())));
        network.init();
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcast set parameters");
        }
        network.setParameters(val);
        IEvaluation[] eval = network.doEvaluation((DataSetIterator)new SparkADSI((DataSetIterator)new IteratorDataSetIterator(dataSetIterator, this.evalBatchSize), 2, true), this.evaluations);
        return Collections.singletonList(eval);
    }
}

