/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer.scoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.functions.FlatMapFunctionAdapter;
import org.deeplearning4j.datasets.iterator.IteratorDataSetIterator;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.spark.impl.multilayer.scoring.ScoreFlatMapFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

class ScoreFlatMapFunctionAdapter
implements FlatMapFunctionAdapter<Iterator<DataSet>, Tuple2<Integer, Double>> {
    private static final Logger log = LoggerFactory.getLogger(ScoreFlatMapFunction.class);
    private String json;
    private Broadcast<INDArray> params;
    private int minibatchSize;

    public ScoreFlatMapFunctionAdapter(String json, Broadcast<INDArray> params, int minibatchSize) {
        this.json = json;
        this.params = params;
        this.minibatchSize = minibatchSize;
    }

    public Iterable<Tuple2<Integer, Double>> call(Iterator<DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.singletonList(new Tuple2((Object)0, (Object)0.0));
        }
        IteratorDataSetIterator iter = new IteratorDataSetIterator(dataSetIterator, this.minibatchSize);
        MultiLayerNetwork network = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)this.json));
        network.init();
        INDArray val = ((INDArray)this.params.value()).unsafeDuplication();
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcast set parameters");
        }
        network.setParameters(val);
        ArrayList<Tuple2<Integer, Double>> out = new ArrayList<Tuple2<Integer, Double>>();
        while (iter.hasNext()) {
            DataSet ds = (DataSet)iter.next();
            double score = network.score(ds, false);
            int numExamples = ds.getFeatureMatrix().size(0);
            out.add((Tuple2<Integer, Double>)new Tuple2((Object)numExamples, (Object)(score * (double)numExamples)));
        }
        Nd4j.getExecutioner().commit();
        return out;
    }
}

