/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.paramavg.util;

import java.io.IOException;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.api.java.JavaSparkContext;

public class ExportSupport {
    public static void assertExportSupported(@NonNull JavaSparkContext sc) {
        if (sc == null) {
            throw new NullPointerException("sc");
        }
        if (!ExportSupport.exportSupported(sc)) {
            throw new RuntimeException("Export training approach is not supported in the current environment. This means that the default Hadoop file system is the local file system and Spark is running in a non-local mode. You can fix this by either adding hadoop configuration to your environment or using the Direct training approach. Configuring Hadoop can be done by adding config files (https://spark.apache.org/docs/1.6.3/configuration.html#inheriting-hadoop-cluster-configuration) or adding a setting to your SparkConf object with `sparkConf.set(\"spark.hadoop.fs.defaultFS\", \"hdfs://my-hdfs-host:9000\");`. Alternatively, you can use some other non-local storage like S3.");
        }
    }

    public static boolean exportSupported(@NonNull JavaSparkContext sc) {
        if (sc == null) {
            throw new NullPointerException("sc");
        }
        try {
            return ExportSupport.exportSupported(sc.master(), FileSystem.get((Configuration)sc.hadoopConfiguration()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean exportSupported(@NonNull String sparkMaster, @NonNull FileSystem fs) {
        if (sparkMaster == null) {
            throw new NullPointerException("sparkMaster");
        }
        if (fs == null) {
            throw new NullPointerException("fs");
        }
        if (sparkMaster.matches("^local(\\[(\\d+|\\*)])?$")) {
            return true;
        }
        return !fs.getUri().getScheme().equals("file");
    }
}

