/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.iterator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.deeplearning4j.spark.iterator.BaseDataSetIterator;
import org.nd4j.linalg.dataset.api.DataSet;

public class PathSparkDataSetIterator
extends BaseDataSetIterator<String> {
    public static final int BUFFER_SIZE = 0x400000;
    private FileSystem fileSystem;

    public PathSparkDataSetIterator(Iterator<String> iter) {
        this.dataSetStreams = null;
        this.iter = iter;
    }

    public PathSparkDataSetIterator(Collection<String> dataSetStreams) {
        this.dataSetStreams = dataSetStreams;
        this.iter = dataSetStreams.iterator();
    }

    @Override
    public int totalExamples() {
        throw new UnsupportedOperationException("Total examples unknown for PathSparkDataSetIterator");
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        org.nd4j.linalg.dataset.DataSet ds;
        if (this.preloadedDataSet != null) {
            ds = this.preloadedDataSet;
            this.preloadedDataSet = null;
        } else {
            ds = this.load((String)this.iter.next());
        }
        this.totalOutcomes = ds.getLabels() == null ? 0 : ds.getLabels().size(1);
        this.inputColumns = ds.getFeatureMatrix().size(1);
        this.batch = ds.numExamples();
        if (this.preprocessor != null) {
            this.preprocessor.preProcess((DataSet)ds);
        }
        return ds;
    }

    @Override
    protected synchronized org.nd4j.linalg.dataset.DataSet load(String path) {
        if (this.fileSystem == null) {
            try {
                this.fileSystem = FileSystem.get((URI)new URI(path), (Configuration)new Configuration());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        org.nd4j.linalg.dataset.DataSet ds = new org.nd4j.linalg.dataset.DataSet();
        try (FSDataInputStream inputStream = this.fileSystem.open(new Path(path), 0x400000);){
            ds.load((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ++this.cursor;
        return ds;
    }
}

