/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.iterator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class PathSparkMultiDataSetIterator
implements MultiDataSetIterator {
    public static final int BUFFER_SIZE = 0x400000;
    private final Collection<String> dataSetStreams;
    private MultiDataSetPreProcessor preprocessor;
    private Iterator<String> iter;
    private FileSystem fileSystem;

    public PathSparkMultiDataSetIterator(Iterator<String> iter) {
        this.dataSetStreams = null;
        this.iter = iter;
    }

    public PathSparkMultiDataSetIterator(Collection<String> dataSetStreams) {
        this.dataSetStreams = dataSetStreams;
        this.iter = dataSetStreams.iterator();
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next(int num) {
        return this.next();
    }

    public boolean resetSupported() {
        return this.dataSetStreams != null;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        if (this.dataSetStreams == null) {
            throw new IllegalStateException("Cannot reset iterator constructed with an iterator");
        }
        this.iter = this.dataSetStreams.iterator();
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preprocessor;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next() {
        org.nd4j.linalg.dataset.api.MultiDataSet ds = this.load(this.iter.next());
        if (this.preprocessor != null) {
            this.preprocessor.preProcess(ds);
        }
        return ds;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private synchronized org.nd4j.linalg.dataset.api.MultiDataSet load(String path) {
        if (this.fileSystem == null) {
            try {
                this.fileSystem = FileSystem.get((URI)new URI(path), (Configuration)new Configuration());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        MultiDataSet ds = new MultiDataSet();
        try (FSDataInputStream inputStream = this.fileSystem.open(new Path(path), 0x400000);){
            ds.load((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ds;
    }
}

