/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.iterator;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.spark.input.PortableDataStream;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class PortableDataStreamMultiDataSetIterator
implements MultiDataSetIterator {
    private final Collection<PortableDataStream> dataSetStreams;
    private MultiDataSetPreProcessor preprocessor;
    private Iterator<PortableDataStream> iter;

    public PortableDataStreamMultiDataSetIterator(Iterator<PortableDataStream> iter) {
        this.dataSetStreams = null;
        this.iter = iter;
    }

    public PortableDataStreamMultiDataSetIterator(Collection<PortableDataStream> dataSetStreams) {
        this.dataSetStreams = dataSetStreams;
        this.iter = dataSetStreams.iterator();
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next(int num) {
        return this.next();
    }

    public boolean resetSupported() {
        return this.dataSetStreams != null;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        if (this.dataSetStreams == null) {
            throw new IllegalStateException("Cannot reset iterator constructed with an iterator");
        }
        this.iter = this.dataSetStreams.iterator();
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preprocessor;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next() {
        MultiDataSet ds = new MultiDataSet();
        PortableDataStream pds = this.iter.next();
        try (DataInputStream is = pds.open();){
            ds.load((InputStream)is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.preprocessor != null) {
            this.preprocessor.preProcess((org.nd4j.linalg.dataset.api.MultiDataSet)ds);
        }
        return ds;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

