/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.stats;

import org.deeplearning4j.spark.stats.EventStats;
import org.deeplearning4j.util.UIDProvider;

public class BaseEventStats
implements EventStats {
    protected final String machineId;
    protected final String jvmId;
    protected final long threadId;
    protected final long startTime;
    protected final long durationMs;

    public BaseEventStats(long startTime, long durationMs) {
        this(UIDProvider.getHardwareUID(), UIDProvider.getJVMUID(), Thread.currentThread().getId(), startTime, durationMs);
    }

    public BaseEventStats(String machineId, String jvmId, long threadId, long startTime, long durationMs) {
        this.machineId = machineId;
        this.jvmId = jvmId;
        this.threadId = threadId;
        this.startTime = startTime;
        this.durationMs = durationMs;
    }

    @Override
    public String getMachineID() {
        return this.machineId;
    }

    @Override
    public String getJvmID() {
        return this.jvmId;
    }

    @Override
    public long getThreadID() {
        return this.threadId;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getDurationMs() {
        return this.durationMs;
    }

    @Override
    public String asString(String delimiter) {
        return this.machineId + delimiter + this.jvmId + delimiter + this.threadId + delimiter + this.startTime + delimiter + this.durationMs;
    }

    @Override
    public String getStringHeader(String delimiter) {
        return "machineId" + delimiter + "jvmId" + delimiter + "threadId" + delimiter + "startTime" + delimiter + "durationMs";
    }
}

