/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.stats;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.deeplearning4j.spark.stats.EventStats;
import org.deeplearning4j.spark.stats.ExampleCountEventStats;
import org.deeplearning4j.spark.stats.PartitionCountEventStats;
import org.deeplearning4j.spark.util.SparkUtils;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.api.LengthUnit;
import org.deeplearning4j.ui.api.Style;
import org.deeplearning4j.ui.components.chart.ChartHistogram;
import org.deeplearning4j.ui.components.chart.ChartLine;
import org.deeplearning4j.ui.components.chart.ChartTimeline;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.deeplearning4j.ui.components.component.ComponentDiv;
import org.deeplearning4j.ui.components.component.style.StyleDiv;
import org.deeplearning4j.ui.components.text.ComponentText;
import org.deeplearning4j.ui.components.text.style.StyleText;
import org.deeplearning4j.ui.standalone.StaticPageUtil;
import scala.Tuple3;

public class StatsUtils {
    public static final long DEFAULT_MAX_TIMELINE_SIZE_MS = 1200000L;

    private StatsUtils() {
    }

    public static void exportStats(List<EventStats> list, String outputDirectory, String filename, String delimiter, SparkContext sc) throws IOException {
        String path = FilenameUtils.concat((String)outputDirectory, (String)filename);
        StatsUtils.exportStats(list, path, delimiter, sc);
    }

    public static void exportStats(List<EventStats> list, String outputPath, String delimiter, SparkContext sc) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (EventStats e : list) {
            if (first) {
                sb.append(e.getStringHeader(delimiter)).append("\n");
            }
            sb.append(e.asString(delimiter)).append("\n");
            first = false;
        }
        SparkUtils.writeStringToFile(outputPath, sb.toString(), sc);
    }

    public static String getDurationAsString(List<EventStats> list, String delim) {
        StringBuilder sb = new StringBuilder();
        int num = list.size();
        int count = 0;
        for (EventStats e : list) {
            sb.append(e.getDurationMs());
            if (count++ >= num - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static void exportStatsAsHtml(SparkTrainingStats sparkTrainingStats, String path, JavaSparkContext sc) throws Exception {
        StatsUtils.exportStatsAsHtml(sparkTrainingStats, path, sc.sc());
    }

    public static void exportStatsAsHtml(SparkTrainingStats sparkTrainingStats, String path, SparkContext sc) throws Exception {
        StatsUtils.exportStatsAsHtml(sparkTrainingStats, 1200000L, path, sc);
    }

    public static void exportStatsAsHtml(SparkTrainingStats sparkTrainingStats, long maxTimelineSizeMs, String path, SparkContext sc) throws Exception {
        FileSystem fileSystem = FileSystem.get((Configuration)sc.hadoopConfiguration());
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fileSystem.create(new Path(path)));){
            StatsUtils.exportStatsAsHTML(sparkTrainingStats, maxTimelineSizeMs, bos);
        }
    }

    public static void exportStatsAsHTML(SparkTrainingStats sparkTrainingStats, OutputStream outputStream) throws Exception {
        StatsUtils.exportStatsAsHTML(sparkTrainingStats, 1200000L, outputStream);
    }

    public static void exportStatsAsHTML(SparkTrainingStats sparkTrainingStats, long maxTimelineSizeMs, OutputStream outputStream) throws Exception {
        Set<String> keySet = sparkTrainingStats.getKeySet();
        ArrayList<ComponentDiv> components = new ArrayList<ComponentDiv>();
        StyleChart styleChart = ((StyleChart.Builder)((StyleChart.Builder)((StyleChart.Builder)new StyleChart.Builder().backgroundColor(Color.WHITE)).width(700.0, LengthUnit.Px)).height(400.0, LengthUnit.Px)).build();
        StyleText styleText = new StyleText.Builder().color(Color.BLACK).fontSize(20.0).build();
        ComponentText headerText = new ComponentText("Deeplearning4j - Spark Training Analysis", styleText);
        ComponentDiv header = new ComponentDiv((Style)((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().height(40.0, LengthUnit.Px)).width(100.0, LengthUnit.Percent)).build(), new Component[]{headerText});
        components.add(header);
        HashSet<String> keySetInclude = new HashSet<String>();
        for (String s : keySet) {
            if (!sparkTrainingStats.defaultIncludeInPlots(s)) continue;
            keySetInclude.add(s);
        }
        Collections.addAll(components, StatsUtils.getTrainingStatsTimelineChart(sparkTrainingStats, keySetInclude, maxTimelineSizeMs));
        for (String s : keySet) {
            ArrayList<EventStats> list = new ArrayList<EventStats>(sparkTrainingStats.getValue(s));
            Collections.sort(list, new StartTimeComparator());
            double[] x = new double[list.size()];
            double[] duration = new double[list.size()];
            double minDur = Double.MAX_VALUE;
            double maxDur = -1.7976931348623157E308;
            for (int i = 0; i < duration.length; ++i) {
                x[i] = i;
                duration[i] = ((EventStats)list.get(i)).getDurationMs();
                minDur = Math.min(minDur, duration[i]);
                maxDur = Math.max(maxDur, duration[i]);
            }
            ChartLine line = ((ChartLine.Builder)((ChartLine.Builder)new ChartLine.Builder(s, styleChart).addSeries("Duration", x, duration).setYMin(minDur == maxDur ? Double.valueOf(minDur - 1.0) : null)).setYMax(minDur == maxDur ? Double.valueOf(minDur + 1.0) : null)).build();
            Component hist = null;
            if (minDur != maxDur && !list.isEmpty()) {
                hist = StatsUtils.getHistogram(duration, 20, s, styleChart);
            }
            Component[] temp = hist != null ? new Component[]{line, hist} : new Component[]{line};
            components.add(new ComponentDiv((Style)((StyleDiv.Builder)new StyleDiv.Builder().width(100.0, LengthUnit.Percent)).build(), temp));
            if (list.isEmpty() || !(list.get(0) instanceof ExampleCountEventStats) && !(list.get(0) instanceof PartitionCountEventStats)) continue;
            boolean exCount = list.get(0) instanceof ExampleCountEventStats;
            double[] y = new double[list.size()];
            double miny = Double.MAX_VALUE;
            double maxy = -1.7976931348623157E308;
            for (int i = 0; i < y.length; ++i) {
                y[i] = exCount ? ((ExampleCountEventStats)list.get(i)).getTotalExampleCount() : ((PartitionCountEventStats)list.get(i)).getNumPartitions();
                miny = Math.min(miny, y[i]);
                maxy = Math.max(maxy, y[i]);
            }
            String title = s + " / " + (exCount ? "Number of Examples" : "Number of Partitions");
            ChartLine line2 = ((ChartLine.Builder)((ChartLine.Builder)new ChartLine.Builder(title, styleChart).addSeries(exCount ? "Examples" : "Partitions", x, y).setYMin(miny == maxy ? Double.valueOf(miny - 1.0) : null)).setYMax(miny == maxy ? Double.valueOf(miny + 1.0) : null)).build();
            Component hist2 = null;
            if (miny != maxy) {
                hist2 = StatsUtils.getHistogram(y, 20, title, styleChart);
            }
            Component[] temp2 = hist2 != null ? new Component[]{line2, hist2} : new Component[]{line2};
            components.add(new ComponentDiv((Style)((StyleDiv.Builder)new StyleDiv.Builder().width(100.0, LengthUnit.Percent)).build(), temp2));
        }
        String html = StaticPageUtil.renderHTML(components);
        outputStream.write(html.getBytes("UTF-8"));
    }

    private static Component[] getTrainingStatsTimelineChart(SparkTrainingStats stats, Set<String> includeSet, long maxDurationMs) {
        HashSet<Tuple3> uniqueTuples = new HashSet<Tuple3>();
        HashSet<String> machineIDs = new HashSet<String>();
        HashSet<String> jvmIDs = new HashSet<String>();
        HashMap<String, String> machineShortNames = new HashMap<String, String>();
        HashMap<String, String> jvmShortNames = new HashMap<String, String>();
        long earliestStart = Long.MAX_VALUE;
        long latestEnd = Long.MIN_VALUE;
        for (String string : includeSet) {
            List<EventStats> list = stats.getValue(string);
            for (EventStats e : list) {
                machineIDs.add(e.getMachineID());
                jvmIDs.add(e.getJvmID());
                uniqueTuples.add(new Tuple3((Object)e.getMachineID(), (Object)e.getJvmID(), (Object)e.getThreadID()));
                earliestStart = Math.min(earliestStart, e.getStartTime());
                latestEnd = Math.max(latestEnd, e.getStartTime() + e.getDurationMs());
            }
        }
        int count = 0;
        for (String s : machineIDs) {
            machineShortNames.put(s, "PC " + count++);
        }
        count = 0;
        for (String s : jvmIDs) {
            jvmShortNames.put(s, "JVM " + count++);
        }
        int n = uniqueTuples.size();
        ArrayList outputOrder = new ArrayList(uniqueTuples);
        Collections.sort(outputOrder, new TupleComparator());
        Color[] colors = StatsUtils.getColors(includeSet.size());
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        count = 0;
        for (String string : includeSet) {
            colorMap.put(string, colors[count++]);
        }
        ArrayList<ComponentDiv> tempList = new ArrayList<ComponentDiv>();
        for (String s : includeSet) {
            String key = stats.getShortNameForKey(s) + " - " + s;
            tempList.add(new ComponentDiv((Style)((StyleDiv.Builder)((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().backgroundColor((Color)colorMap.get(s))).width(33.3, LengthUnit.Percent)).height(25.0, LengthUnit.Px)).floatValue(StyleDiv.FloatValue.left).build(), new Component[]{new ComponentText(key, new StyleText.Builder().fontSize(11.0).build())}));
        }
        ComponentDiv componentDiv = new ComponentDiv((Style)((StyleDiv.Builder)new StyleDiv.Builder().width(100.0, LengthUnit.Percent)).build(), tempList);
        int nCharts = (int)((latestEnd - earliestStart) / maxDurationMs);
        if (nCharts < 1) {
            nCharts = 1;
        }
        long[] chartStartTimes = new long[nCharts];
        long[] chartEndTimes = new long[nCharts];
        for (int i = 0; i < nCharts; ++i) {
            chartStartTimes[i] = earliestStart + (long)i * maxDurationMs;
            chartEndTimes[i] = earliestStart + (long)(i + 1) * maxDurationMs;
        }
        ArrayList entriesByLane = new ArrayList();
        for (int c = 0; c < nCharts; ++c) {
            entriesByLane.add(new ArrayList());
            for (int i = 0; i < n; ++i) {
                ((List)entriesByLane.get(c)).add(new ArrayList());
            }
        }
        for (String s : includeSet) {
            List<EventStats> list = stats.getValue(s);
            for (EventStats e : list) {
                if (e.getDurationMs() == 0L) continue;
                long start = e.getStartTime();
                long end = start + e.getDurationMs();
                int chartIdx = -1;
                for (int j = 0; j < nCharts; ++j) {
                    if (start < chartStartTimes[j] || start >= chartEndTimes[j]) continue;
                    chartIdx = j;
                }
                if (chartIdx == -1) {
                    chartIdx = nCharts - 1;
                }
                Tuple3 tuple = new Tuple3((Object)e.getMachineID(), (Object)e.getJvmID(), (Object)e.getThreadID());
                int idx = outputOrder.indexOf(tuple);
                Color c = (Color)colorMap.get(s);
                ChartTimeline.TimelineEntry entry = new ChartTimeline.TimelineEntry(stats.getShortNameForKey(s), start, end, c);
                ((List)((List)entriesByLane.get(chartIdx)).get(idx)).add(entry);
            }
        }
        for (int i = 0; i < nCharts; ++i) {
            for (List l : (List)entriesByLane.get(i)) {
                Collections.sort(l, new Comparator<ChartTimeline.TimelineEntry>(){

                    @Override
                    public int compare(ChartTimeline.TimelineEntry o1, ChartTimeline.TimelineEntry o2) {
                        return Long.compare(o1.getStartTimeMs(), o2.getStartTimeMs());
                    }
                });
            }
        }
        StyleChart sc = ((StyleChart.Builder)((StyleChart.Builder)((StyleChart.Builder)new StyleChart.Builder().width(1280.0, LengthUnit.Px)).height((double)(35 * n + 105), LengthUnit.Px)).margin(LengthUnit.Px, Integer.valueOf(60), Integer.valueOf(20), Integer.valueOf(200), Integer.valueOf(10))).build();
        ArrayList<Object> list = new ArrayList<Object>(nCharts);
        for (int j = 0; j < nCharts; ++j) {
            ChartTimeline.Builder b = new ChartTimeline.Builder("Timeline: Training Activities", sc);
            int i = 0;
            for (List l : (List)entriesByLane.get(j)) {
                Tuple3 t3 = (Tuple3)outputOrder.get(i);
                String name = (String)machineShortNames.get(t3._1()) + ", " + (String)jvmShortNames.get(t3._2()) + ", Thread " + t3._3();
                b.addLane(name, l);
                ++i;
            }
            list.add(b.build());
        }
        list.add(componentDiv);
        return list.toArray(new Component[list.size()]);
    }

    private static Color[] getColors(int nColors) {
        Color[] c = new Color[nColors];
        double step = nColors <= 1 ? 1.0 : 1.0 / (double)(nColors + 1);
        for (int i = 0; i < nColors; ++i) {
            c[i] = i % 2 == 0 ? Color.getHSBColor((float)step * (float)i, 0.4f, 0.75f) : Color.getHSBColor((float)step * (float)i, 1.0f, 1.0f);
        }
        return c;
    }

    private static Component getHistogram(double[] data, int nBins, String title, StyleChart styleChart) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (double d : data) {
            min = Math.min(min, d);
            max = Math.max(max, d);
        }
        if (min == max) {
            return null;
        }
        double[] bins = new double[nBins + 1];
        int[] counts = new int[nBins];
        double step = (max - min) / (double)nBins;
        for (int i = 0; i < bins.length; ++i) {
            bins[i] = min + (double)i * step;
        }
        for (double d : data) {
            for (int i = 0; i < bins.length - 1; ++i) {
                if (!(d >= bins[i]) || !(d < bins[i + 1])) continue;
                int n = i;
                counts[n] = counts[n] + 1;
                break;
            }
            if (d != bins[bins.length - 1]) continue;
            int n = counts.length - 1;
            counts[n] = counts[n] + 1;
        }
        ChartHistogram.Builder b = new ChartHistogram.Builder(title, styleChart);
        for (int i = 0; i < bins.length - 1; ++i) {
            b.addBin(bins[i], bins[i + 1], (double)counts[i]);
        }
        return b.build();
    }

    private static class TupleComparator
    implements Comparator<Tuple3<String, String, Long>> {
        private TupleComparator() {
        }

        @Override
        public int compare(Tuple3<String, String, Long> o1, Tuple3<String, String, Long> o2) {
            if (((String)o1._1()).equals(o2._1())) {
                if (((String)o1._2()).equals(o2._2())) {
                    return Long.compare((Long)o1._3(), (Long)o2._3());
                }
                return ((String)o1._2()).compareTo((String)o2._2());
            }
            return ((String)o1._1()).compareTo((String)o2._1());
        }
    }

    public static class StartTimeComparator
    implements Comparator<EventStats> {
        @Override
        public int compare(EventStats o1, EventStats o2) {
            return Long.compare(o1.getStartTime(), o2.getStartTime());
        }
    }
}

