/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.util.serde;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.storage.StorageLevel;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.SerializerProvider;

public class StorageLevelSerializer
extends JsonSerializer<StorageLevel> {
    private static final Map<StorageLevel, String> map = StorageLevelSerializer.initMap();

    private static Map<StorageLevel, String> initMap() {
        HashMap<StorageLevel, String> map = new HashMap<StorageLevel, String>();
        map.put(StorageLevel.NONE(), "NONE");
        map.put(StorageLevel.DISK_ONLY(), "DISK_ONLY");
        map.put(StorageLevel.DISK_ONLY_2(), "DISK_ONLY_2");
        map.put(StorageLevel.MEMORY_ONLY(), "MEMORY_ONLY");
        map.put(StorageLevel.MEMORY_ONLY_2(), "MEMORY_ONLY_2");
        map.put(StorageLevel.MEMORY_ONLY_SER(), "MEMORY_ONLY_SER");
        map.put(StorageLevel.MEMORY_ONLY_SER_2(), "MEMORY_ONLY_SER_2");
        map.put(StorageLevel.MEMORY_AND_DISK(), "MEMORY_AND_DISK");
        map.put(StorageLevel.MEMORY_AND_DISK_2(), "MEMORY_AND_DISK_2");
        map.put(StorageLevel.MEMORY_AND_DISK_SER(), "MEMORY_AND_DISK_SER");
        map.put(StorageLevel.MEMORY_AND_DISK_SER_2(), "MEMORY_AND_DISK_SER_2");
        map.put(StorageLevel.OFF_HEAP(), "OFF_HEAP");
        return map;
    }

    public void serialize(StorageLevel storageLevel, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        String s = null;
        if (storageLevel != null) {
            s = map.get(storageLevel);
        }
        jsonGenerator.writeString(s);
    }
}

